/*
 * Decompiled with CFR 0.152.
 */
package netscape.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import netscape.net.SSLCallbackNotifier;
import netscape.net.SSLHandshakeCompletedEvent;
import netscape.net.SSLHandshakeCompletedListener;
import netscape.net.SSLInputStream;
import netscape.net.SSLOutputStream;
import netscape.net.SSLSecurityStatus;
import netscape.net.SSLSocket;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;

class SSLSocketImpl
extends SocketImpl {
    int timeout;
    private boolean requireClientAuth = false;
    private boolean useClientMode = false;
    private boolean clientModeInitialized = false;
    private boolean trustedForClientAuth = false;
    Vector handshakeListeners = new Vector();
    Thread callbackNotifier;
    SSLSocket socket;

    SSLSocketImpl() {
        this.socket = null;
        try {
            this.trustedForClientAuth = false;
            try {
                PrivilegeManager.checkPrivilegeEnabled("ClientAuth");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            this.trustedForClientAuth = true;
            return;
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            return;
        }
    }

    SSLSocketImpl(SSLSocket sSLSocket) {
        this.socket = sSLSocket;
        try {
            this.trustedForClientAuth = false;
            try {
                PrivilegeManager.checkPrivilegeEnabled("ClientAuth");
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
            this.trustedForClientAuth = true;
            return;
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            return;
        }
    }

    protected synchronized void create(boolean bl) throws IOException {
        if (!bl) {
            throw new IOException("UDP datagram sockets not supported in SSL.");
        }
        this.fd = new FileDescriptor();
        this.socketCreate(bl);
    }

    protected void connect(String string, int n) throws UnknownHostException, IOException {
        IOException iOException = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            try {
                this.connectToAddress(inetAddress, n);
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            iOException = unknownHostException;
        }
        this.close();
        throw iOException;
    }

    protected void connect(InetAddress inetAddress, int n) throws IOException {
        this.port = n;
        this.address = inetAddress;
        try {
            this.connectToAddress(inetAddress, n);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private void connectToAddress(InetAddress inetAddress, int n) throws IOException {
        this.doConnect(inetAddress, n);
    }

    public void setNeedClientAuth(boolean bl) {
        this.requireClientAuth = bl;
        this.socketSetNeedClientAuth(bl);
    }

    public boolean getNeedClientAuth() {
        return this.requireClientAuth;
    }

    public void setUseClientMode(boolean bl) {
        this.clientModeInitialized = true;
        this.useClientMode = bl;
    }

    public boolean getUseClientMode() {
        return this.useClientMode;
    }

    boolean isClientModeInitialized() {
        return this.clientModeInitialized;
    }

    public void setOption(int n, Object object) throws SocketException {
        int n2 = 0;
        boolean bl = true;
        switch (n) {
            case 128: {
                if (object == null || !(object instanceof Integer) && !(object instanceof Boolean)) {
                    throw new SocketException("Bad parameter for option");
                }
                if (object instanceof Boolean) {
                    bl = false;
                    n2 = 0;
                    break;
                }
                n2 = (Integer)object;
                break;
            }
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int n3 = (Integer)object;
                if (n3 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n3;
                return;
            }
            case 15: {
                throw new SocketException("Cannot re-bind socket");
            }
            case 1: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for TCP_NODELAY");
                }
                bl = (Boolean)object;
                break;
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + n);
            }
        }
        this.socketSetOptionIntVal(n, bl, n2);
    }

    public Object getOption(int n) throws SocketException {
        if (n == 4102) {
            return new Integer(this.timeout);
        }
        int n2 = this.socketGetOption(n);
        switch (n) {
            case 1: {
                if (n2 == -1) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 128: {
                if (n2 == -1) {
                    return new Boolean(false);
                }
                return new Integer(n2);
            }
            case 15: {
                InetAddress inetAddress = new InetAddress(n2);
                return inetAddress;
            }
        }
        return null;
    }

    private void doConnect(InetAddress inetAddress, int n) throws IOException {
        ProtocolException protocolException = null;
        if (!this.isClientModeInitialized()) {
            this.setUseClientMode(true);
        }
        int n2 = 0;
        while (n2 < 3) {
            try {
                this.socketConnect(inetAddress, n);
                return;
            }
            catch (ProtocolException protocolException2) {
                this.close();
                this.fd = new FileDescriptor();
                this.socketCreate(true);
                protocolException = protocolException2;
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            ++n2;
        }
        this.close();
        throw protocolException;
    }

    private boolean usingSocks() {
        return false;
    }

    protected synchronized void bind(InetAddress inetAddress, int n) throws IOException {
        this.socketBind(inetAddress, n);
    }

    protected synchronized void listen(int n) throws IOException {
        this.socketListen(n);
    }

    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        this.socketAccept(socketImpl);
    }

    protected synchronized InputStream getInputStream() throws IOException {
        return new SSLInputStream(this);
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        return new SSLOutputStream(this);
    }

    protected synchronized int available() throws IOException {
        return this.socketAvailable();
    }

    protected void close() throws IOException {
        if (this.fd != null && this.fd.valid()) {
            this.socketClose();
            this.fd = null;
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private native void socketCreate(boolean var1) throws IOException;

    private native void socketConnect(InetAddress var1, int var2) throws IOException;

    private native void socketBind(InetAddress var1, int var2) throws IOException;

    private native void socketListen(int var1) throws IOException;

    private native void socketAccept(SocketImpl var1) throws IOException;

    private native int socketAvailable() throws IOException;

    private native void socketClose() throws IOException;

    private native void socketSetNeedClientAuth(boolean var1);

    private native void socketSetOptionIntVal(int var1, boolean var2, int var3) throws SocketException;

    private native int socketGetOption(int var1) throws SocketException;

    protected FileDescriptor getFileDescriptor() {
        return this.fd;
    }

    protected InetAddress getInetAddress() {
        return this.address;
    }

    protected int getPort() {
        return this.port;
    }

    protected int getLocalPort() {
        return this.localport;
    }

    public void removeHandshakeCompletedListener(SSLHandshakeCompletedListener sSLHandshakeCompletedListener) {
        this.handshakeListeners.removeElement(sSLHandshakeCompletedListener);
    }

    public void addHandshakeCompletedListener(SSLHandshakeCompletedListener sSLHandshakeCompletedListener) {
        if (this.socket == null) {
            throw new RuntimeException("no socket in client-side SSLSocketImpl?");
        }
        if (this.callbackNotifier == null) {
            this.callbackNotifier = new SSLCallbackNotifier(this);
            this.callbackNotifier.start();
        }
        this.handshakeListeners.addElement(sSLHandshakeCompletedListener);
    }

    void callHandshakeCompletedListeners() {
        try {
            Thread thread = this.callbackNotifier;
            synchronized (thread) {
                this.callbackNotifier.notify();
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    void doCallHandshakeCompletedListeners() {
        if (this.socket == null) {
            throw new RuntimeException("no socket in SSLSocketImpl?");
        }
        Vector vector = this.handshakeListeners;
        synchronized (vector) {
            SSLHandshakeCompletedEvent sSLHandshakeCompletedEvent = new SSLHandshakeCompletedEvent(this.socket);
            Enumeration enumeration = this.handshakeListeners.elements();
            while (enumeration.hasMoreElements()) {
                SSLHandshakeCompletedListener sSLHandshakeCompletedListener = (SSLHandshakeCompletedListener)enumeration.nextElement();
                sSLHandshakeCompletedListener.handshakeCompleted(sSLHandshakeCompletedEvent);
            }
            return;
        }
    }

    boolean allowClientAuth() {
        return this.trustedForClientAuth;
    }

    native SSLSecurityStatus getStatus();

    native void resetHandshake();

    native void forceHandshake();

    native void redoHandshake();

    static {
        SecurityManager.enablePrivilege("SuperUser");
        SecurityManager.enablePrivilege("UniversalPropertyRead");
        System.loadLibrary(System.getProperty("netscape.net.dll", "net"));
    }
}

