/*
 * Decompiled with CFR 0.152.
 */
package netscape.secfile;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import netscape.secfile.SecureFile;
import netscape.secfile.SecureFileException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;

public class SecureRandomAccessFile
extends RandomAccessFile {
    private String prepend;
    private Principal prin;

    static String CheckLimitedFileAccess(String string) {
        PrivilegeManager.checkPrivilegeEnabled("LimitedFileAccess");
        return string;
    }

    public SecureRandomAccessFile(String string, String string2) throws IOException {
        this(string, string2, SecureFile.getClassPrincipal(1), 1);
    }

    public SecureRandomAccessFile(SecureFile secureFile, String string) throws IOException {
        this(secureFile.getPath(), string, secureFile.getPrincipal(), 1);
    }

    public SecureRandomAccessFile(FileDescriptor fileDescriptor, String string) {
        this(fileDescriptor, string, PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdRead")), PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdWrite")));
        this.prin = null;
    }

    private static FileDescriptor rethrow(String string, String string2, String string3) throws IOException {
        RandomAccessFile randomAccessFile;
        PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFileAccess"));
        try {
            randomAccessFile = new RandomAccessFile(string, string3);
        }
        catch (IOException iOException) {
            throw new IOException(string2);
        }
        try {
            return randomAccessFile.getFD();
        }
        catch (IOException iOException) {
            throw new SecureFileException("Internal error");
        }
    }

    public SecureRandomAccessFile(String string, String string2, Principal principal) throws IOException {
        this(string, string2, principal, 1);
    }

    private SecureRandomAccessFile(String string, String string2, Principal principal, int n) throws IOException {
        this(SecureRandomAccessFile.rethrow(SecureFile.getPrependedPath(SecureFile.getPrepend(principal, n + 1), string), string, string2), string2, PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdRead")), PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdWrite")));
        this.prepend = SecureFile.getPrepend(principal, n + 1);
        SecureFile.checkCanonicalPath(string, this.prepend);
        this.prin = principal;
    }

    private SecureRandomAccessFile(FileDescriptor fileDescriptor, String string, Object object, Object object2) {
        super(fileDescriptor, string);
    }

    public Principal getPrincipal() {
        return this.prin;
    }
}

