/*
 * Decompiled with CFR 0.152.
 */
package netscape.softupdate;

import java.text.MessageFormat;
import netscape.security.AppletSecurity;
import netscape.security.PrivilegeManager;
import netscape.security.Target;
import netscape.softupdate.FolderSpec;
import netscape.softupdate.InstallObject;
import netscape.softupdate.SoftUpdateException;
import netscape.softupdate.SoftwareUpdate;
import netscape.softupdate.Strings;
import netscape.softupdate.VersionRegistry;

class InstallDelete
extends InstallObject {
    private String finalFile;
    private String registryName;
    int FILE_DOES_NOT_EXIST;
    int FILE_READ_ONLY;
    int FILE_IS_DIRECTORY;
    int deleteStatus;
    static final int DELETE_FILE = 1;
    static final int DELETE_COMPONENT = 2;

    InstallDelete(SoftwareUpdate softwareUpdate, FolderSpec folderSpec, String string) throws SoftUpdateException {
        super(softwareUpdate);
        this.deleteStatus = 1;
        this.finalFile = folderSpec.MakeFullPath(string);
        this.FILE_DOES_NOT_EXIST = -214;
        this.FILE_READ_ONLY = -215;
        this.FILE_IS_DIRECTORY = -216;
        this.processInstallDelete();
    }

    InstallDelete(SoftwareUpdate softwareUpdate, String string) throws SoftUpdateException {
        super(softwareUpdate);
        this.deleteStatus = 2;
        this.registryName = string;
        this.FILE_DOES_NOT_EXIST = -214;
        this.FILE_READ_ONLY = -215;
        this.FILE_IS_DIRECTORY = -216;
        this.processInstallDelete();
    }

    private void processInstallDelete() throws SoftUpdateException {
        int n;
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        privilegeManager.enablePrivilege(target);
        Target target2 = Target.findTarget("SoftwareInstall");
        privilegeManager.enablePrivilege(target2, this.softUpdate.GetPrincipal());
        if (this.deleteStatus == 2) {
            n = VersionRegistry.inRegistry(this.registryName);
            if (n != 0) {
                throw new SoftUpdateException(String.valueOf(Strings.error_NotInRegistry()) + this.registryName, -213);
            }
            this.finalFile = VersionRegistry.componentPath(this.registryName);
        }
        if (this.finalFile != null && (n = this.NativeCheckFileStatus()) != 0) {
            if (n == -214) {
                throw new SoftUpdateException(String.valueOf(Strings.error_FileDoesNotExist()) + this.finalFile, n);
            }
            if (n == -215) {
                throw new SoftUpdateException(String.valueOf(Strings.error_FileReadOnly()) + this.finalFile, n);
            }
            if (n == -216) {
                throw new SoftUpdateException(String.valueOf(Strings.error_FileIsDirectory()) + this.finalFile, n);
            }
            throw new SoftUpdateException(String.valueOf(Strings.error_Unexpected()) + this.finalFile, n);
        }
    }

    protected void Prepare() throws SoftUpdateException {
    }

    protected void Complete() throws SoftUpdateException {
        int n = -1;
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        Target target = Target.findTarget("Impersonator");
        privilegeManager.enablePrivilege(target);
        Target target2 = Target.findTarget("SoftwareInstall");
        privilegeManager.enablePrivilege(target2, this.softUpdate.GetPrincipal());
        if (this.deleteStatus == 2) {
            n = VersionRegistry.deleteComponent(this.registryName);
        }
        if (this.deleteStatus == 1 || n == 0) {
            if (this.finalFile != null && (n = this.NativeComplete()) != 0 && n != -214) {
                privilegeManager.revertPrivilege(target2);
                throw new SoftUpdateException(String.valueOf(Strings.error_Unexpected()) + this.finalFile, n);
            }
        } else {
            throw new SoftUpdateException(String.valueOf(Strings.error_Unexpected()) + this.finalFile, n);
        }
    }

    protected void Abort() {
    }

    private native int NativeComplete() throws SoftUpdateException;

    private native int NativeCheckFileStatus() throws SoftUpdateException;

    public String toString() {
        Object[] objectArray = new Object[]{this.finalFile};
        Object[] objectArray2 = new Object[]{this.registryName};
        if (this.deleteStatus == 1) {
            return MessageFormat.format(Strings.details_DeleteFile(), objectArray);
        }
        return MessageFormat.format(Strings.details_DeleteComponent(), objectArray2);
    }

    protected boolean CanUninstall() {
        return false;
    }

    protected boolean RegisterPackageNode() {
        return false;
    }
}

