/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

class ObjectPool {
    Object[] freePool = new Object[1];
    int freePoolMaxLength = 1;
    int freePoolNextSlot = 0;
    Class objectClass;
    int allocSaved;
    int allocDone;
    int maxCapacity;

    public ObjectPool(String string) {
        this(string, 32);
    }

    public ObjectPool(String string, int n) {
        try {
            this.objectClass = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("ObjectPool cannot find class " + string);
        }
        this.allocSaved = 0;
        this.allocDone = 0;
        this.maxCapacity = n;
    }

    public Object allocateObject() {
        Object object = null;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.freePoolNextSlot > 0) {
                --this.freePoolNextSlot;
                object = this.freePool[this.freePoolNextSlot];
            }
        }
        if (object == null) {
            ++this.allocDone;
            try {
                object = this.objectClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Cannot instantiate instance of class " + this.objectClass);
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Cannot instantiate instance of class. Illegal." + this.objectClass);
            }
        } else {
            ++this.allocSaved;
        }
        return object;
    }

    public void recycleObject(Object object) {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.freePoolMaxLength < this.maxCapacity) {
                if (this.freePoolNextSlot == this.freePoolMaxLength) {
                    Object[] objectArray = new Object[this.freePoolMaxLength * 2];
                    System.arraycopy(this.freePool, 0, objectArray, 0, this.freePoolMaxLength);
                    this.freePool = objectArray;
                    this.freePoolMaxLength *= 2;
                }
                this.freePool[this.freePoolNextSlot++] = object;
            }
            return;
        }
    }

    protected void finalize() {
        int n = 0;
        while (n < this.freePoolNextSlot) {
            this.freePool[n] = null;
            ++n;
        }
        this.freePool = null;
    }

    public String toString() {
        return "Object pool for class " + this.objectClass + " has " + this.freePoolNextSlot + " instances." + " " + this.allocSaved + " allocations avoided allocation performed:" + this.allocDone;
    }
}

