/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Event;
import netscape.application.EventFilter;
import netscape.application.EventLoop;
import netscape.application.EventProcessor;
import netscape.application.Target;
import netscape.application.TimerQueue;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Timer
implements EventProcessor,
EventFilter {
    EventLoop eventLoop;
    Target target;
    String command;
    Object data;
    long timeStamp;
    int initialDelay;
    int delay;
    boolean repeats = true;
    boolean coalesce = true;
    boolean removeEvents;
    long expirationTime;
    Timer nextTimer;
    boolean running;

    public Timer(EventLoop eventLoop, Target target, String string, int n) {
        if (eventLoop == null) {
            throw new InconsistencyException("eventLoop parameter is null");
        }
        this.eventLoop = eventLoop;
        this.target = target;
        this.command = string;
        this.setDelay(n);
        this.setInitialDelay(n);
    }

    public Timer(Target target, String string, int n) {
        this(Application.application().eventLoop(), target, string, n);
    }

    TimerQueue timerQueue() {
        if (this.eventLoop != null && this.eventLoop.application != null) {
            return this.eventLoop.application.timerQueue();
        }
        return Application.application().timerQueue();
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String command() {
        return this.command;
    }

    public void setData(Object object) {
        this.data = object;
    }

    public Object data() {
        return this.data;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new InconsistencyException("Invalid initial delay: " + n);
        }
        this.delay = n;
        if (this.isRunning()) {
            TimerQueue timerQueue = this.timerQueue();
            timerQueue.removeTimer(this);
            this.removeEvents();
            timerQueue.addTimer(this, System.currentTimeMillis() + (long)n);
        }
    }

    public int delay() {
        return this.delay;
    }

    public void setInitialDelay(int n) {
        if (n < 0) {
            throw new InconsistencyException("Invalid initial delay: " + n);
        }
        this.initialDelay = n;
    }

    public int initialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean bl) {
        this.repeats = bl;
    }

    public boolean repeats() {
        return this.repeats;
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    public void setCoalesce(boolean bl) {
        this.coalesce = bl;
    }

    public boolean doesCoalesce() {
        return this.coalesce;
    }

    public void start() {
        this.timerQueue().addTimer(this, System.currentTimeMillis() + (long)this.initialDelay());
    }

    public boolean isRunning() {
        return this.timerQueue().containsTimer(this);
    }

    public void stop() {
        this.timerQueue().removeTimer(this);
        this.removeEvents();
    }

    synchronized void removeEvents() {
        this.removeEvents = true;
        this.eventLoop.filterEvents(this);
    }

    synchronized boolean peekEvent() {
        this.removeEvents = false;
        return this.eventLoop.filterEvents(this) != null;
    }

    public Object filterEvents(Vector vector) {
        int n = vector.count();
        while (n-- > 0) {
            Event event = (Event)vector.elementAt(n);
            if (event.processor() != this) continue;
            if (this.removeEvents) {
                vector.removeElementAt(n);
                continue;
            }
            return event;
        }
        return null;
    }

    public void processEvent(Event event) {
        this.timeStamp = event.timeStamp;
        if (this.target != null) {
            this.target.performCommand(this.command, this.data);
        }
    }

    public String toString() {
        return "Timer {target = " + this.target + "; command = " + this.command + "; delay = " + this.delay + "; initialDelay = " + this.initialDelay + "; repeats = " + this.repeats + "}";
    }

    void post(long l) {
        if (!this.coalesce || !this.peekEvent()) {
            Event event = new Event(l);
            event.setProcessor(this);
            this.eventLoop.addEvent(event);
        }
    }
}

