/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class Choice
extends Component
implements ItemSelectable {
    Vector pItems;
    int selectedIndex = -1;
    transient ItemListener itemListener;
    private static final String base = "choice";
    private static int nameCounter;
    private static final long serialVersionUID = -4075310674757313071L;
    private int choiceSerializedDataVersion = 1;

    public Choice() {
        this.name = base + nameCounter++;
        this.pItems = new Vector();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public synchronized void add(String string) {
        this.addItem(string);
    }

    public synchronized void addItem(String string) {
        if (string == null) {
            throw new NullPointerException("cannot add null item to Choice");
        }
        this.pItems.addElement(string);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.addItem(string, this.pItems.size() - 1);
        }
        if (this.selectedIndex < 0) {
            this.select(0);
        }
    }

    public synchronized void insert(String string, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        int n2 = this.getItemCount();
        Vector vector = new Vector();
        int n3 = n;
        while (n3 < n2) {
            vector.addElement(this.getItem(n));
            this.remove(n);
            ++n3;
        }
        this.add(string);
        int n4 = 0;
        while (n4 < vector.size()) {
            this.add((String)vector.elementAt(n4));
            ++n4;
        }
    }

    public synchronized void remove(String string) {
        int n = this.pItems.indexOf(string);
        if (n < 0) {
            throw new IllegalArgumentException("item " + string + " not found in choice");
        }
        this.remove(n);
    }

    public synchronized void remove(int n) {
        this.pItems.removeElementAt(n);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.remove(n);
        }
        if (this.pItems.size() == 0) {
            this.selectedIndex = -1;
            return;
        }
        if (this.selectedIndex == n) {
            this.select(0);
        }
    }

    public synchronized void removeAll() {
        int n = this.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.remove(0);
            ++n2;
        }
    }

    public synchronized String getSelectedItem() {
        if (this.selectedIndex >= 0) {
            return this.getItem(this.selectedIndex);
        }
        return null;
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex >= 0) {
            Object[] objectArray = new Object[]{this.getItem(this.selectedIndex)};
            return objectArray;
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int n) {
        if (n >= this.pItems.size()) {
            throw new IllegalArgumentException("illegal Choice item position: " + n);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = n;
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            if (choicePeer != null) {
                choicePeer.select(n);
            }
        }
    }

    public synchronized void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(itemEvent);
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",current=" + this.getSelectedItem();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "itemL") {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }
}

