/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;

public class IndexColorModel
extends ColorModel {
    private int[] rgb;
    private int map_size;
    private boolean opaque;
    private int transparent_index;

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n);
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n);
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
        this.setTransparentPixel(n3);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n);
        if (n2 > 0 && byArray4 == null) {
            throw new NullPointerException();
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, byArray4);
    }

    private void setRGBs(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        this.map_size = n;
        this.rgb = new int[Math.max(n, 256)];
        int n2 = 255;
        this.opaque = true;
        int n3 = 0;
        while (n3 < n) {
            if (byArray4 != null && (n2 = byArray4[n3] & 0xFF) != 255) {
                this.opaque = false;
            }
            this.rgb[n3] = n2 << 24 | (byArray[n3] & 0xFF) << 16 | (byArray2[n3] & 0xFF) << 8 | byArray3[n3] & 0xFF;
            ++n3;
        }
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        super(n);
        this.map_size = n2;
        this.rgb = new int[Math.max(n2, 256)];
        int n5 = n3;
        int n6 = 255;
        this.opaque = true;
        int n7 = 0;
        while (n7 < n2) {
            this.rgb[n7] = (byArray[n5++] & 0xFF) << 16 | (byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF;
            if (bl && (n6 = byArray[n5++]) != 255) {
                this.opaque = false;
            }
            int n8 = n7++;
            this.rgb[n8] = this.rgb[n8] | n6 << 24;
        }
        this.setTransparentPixel(n4);
    }

    public final int getMapSize() {
        return this.map_size;
    }

    public final int getTransparentPixel() {
        return this.transparent_index;
    }

    public final void getReds(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)(this.rgb[n] >> 16);
            ++n;
        }
    }

    public final void getGreens(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)(this.rgb[n] >> 8);
            ++n;
        }
    }

    public final void getBlues(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)this.rgb[n];
            ++n;
        }
    }

    public final void getAlphas(byte[] byArray) {
        int n = 0;
        while (n < this.map_size) {
            byArray[n] = (byte)(this.rgb[n] >> 24);
            ++n;
        }
    }

    private void setTransparentPixel(int n) {
        if (n >= this.map_size || n < 0) {
            n = -1;
        } else {
            int n2 = n;
            this.rgb[n2] = this.rgb[n2] & 0xFFFFFF;
            this.opaque = false;
        }
        this.transparent_index = n;
    }

    public final int getRed(int n) {
        return this.rgb[n] >> 16 & 0xFF;
    }

    public final int getGreen(int n) {
        return this.rgb[n] >> 8 & 0xFF;
    }

    public final int getBlue(int n) {
        return this.rgb[n] & 0xFF;
    }

    public final int getAlpha(int n) {
        return this.rgb[n] >> 24 & 0xFF;
    }

    public final int getRGB(int n) {
        return this.rgb[n];
    }
}

