/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcCallableStatement;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcDatabaseMetaData;
import sun.jdbc.odbc.JdbcOdbcDriverInterface;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcPreparedStatement;
import sun.jdbc.odbc.JdbcOdbcStatement;
import sun.jdbc.odbc.JdbcOdbcTypeInfo;

public class JdbcOdbcConnection
extends JdbcOdbcObject
implements JdbcOdbcConnectionInterface {
    protected JdbcOdbc OdbcApi;
    protected JdbcOdbcDriverInterface myDriver;
    protected int hEnv;
    protected int hDbc;
    protected SQLWarning lastWarning;
    protected boolean closed;
    protected String URL;
    protected int odbcVer;
    protected Hashtable typeInfo;
    protected Hashtable statements;

    public JdbcOdbcConnection(JdbcOdbc jdbcOdbc, int n, JdbcOdbcDriverInterface jdbcOdbcDriverInterface) {
        this.OdbcApi = jdbcOdbc;
        this.myDriver = jdbcOdbcDriverInterface;
        this.hEnv = n;
        this.hDbc = 0;
        this.URL = null;
        this.lastWarning = null;
        this.closed = true;
    }

    protected void finalize() {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Connection.finalize " + this);
        }
        try {
            this.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public void initialize(String string, Properties properties, int n) throws SQLException {
        String string2 = "";
        if (this.closed) {
            this.hDbc = this.myDriver.allocConnection(this.hEnv);
        }
        if (n > 0) {
            this.setLoginTimeout(n);
        }
        String string3 = properties.getProperty("user", "");
        String string4 = properties.getProperty("password", "");
        string2 = "DSN=" + string;
        if (string3 != null) {
            string2 = String.valueOf(string2) + ";UID=" + string3;
        }
        if (string4 != null) {
            string2 = String.valueOf(string2) + ";PWD=" + string4;
        }
        try {
            this.OdbcApi.SQLDriverConnect(this.hDbc, string2);
        }
        catch (SQLWarning sQLWarning) {
            this.lastWarning = sQLWarning;
        }
        catch (SQLException sQLException) {
            this.myDriver.closeConnection(this.hDbc);
            throw sQLException;
        }
        this.closed = false;
        this.statements = new Hashtable();
        if (JdbcOdbcObject.isTracing()) {
            DatabaseMetaData databaseMetaData = this.getMetaData();
            JdbcOdbcObject.trace("Driver name:    " + databaseMetaData.getDriverName());
            JdbcOdbcObject.trace("Driver version: " + databaseMetaData.getDriverVersion());
        }
        this.buildTypeInfo();
    }

    public Statement createStatement() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.createStatement");
        }
        JdbcOdbcStatement jdbcOdbcStatement = new JdbcOdbcStatement(this);
        jdbcOdbcStatement.initialize(this.OdbcApi, this.hDbc);
        this.registerStatement(jdbcOdbcStatement);
        return jdbcOdbcStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.prepareStatement (" + string + ")");
        }
        JdbcOdbcPreparedStatement jdbcOdbcPreparedStatement = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLPrepare(n, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcPreparedStatement = new JdbcOdbcPreparedStatement(this);
        jdbcOdbcPreparedStatement.initialize(this.OdbcApi, this.hDbc, n, this.typeInfo);
        jdbcOdbcPreparedStatement.setWarning(sQLWarning);
        this.registerStatement(jdbcOdbcPreparedStatement);
        return jdbcOdbcPreparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.prepareCall (" + string + ")");
        }
        JdbcOdbcCallableStatement jdbcOdbcCallableStatement = null;
        SQLWarning sQLWarning = null;
        int n = this.OdbcApi.SQLAllocStmt(this.hDbc);
        try {
            this.OdbcApi.SQLPrepare(n, string);
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        catch (SQLException sQLException) {
            this.OdbcApi.SQLFreeStmt(n, 1);
            throw sQLException;
        }
        jdbcOdbcCallableStatement = new JdbcOdbcCallableStatement(this);
        jdbcOdbcCallableStatement.initialize(this.OdbcApi, this.hDbc, n, this.typeInfo);
        jdbcOdbcCallableStatement.setWarning(sQLWarning);
        this.registerStatement(jdbcOdbcCallableStatement);
        return jdbcOdbcCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        String string2;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.nativeSQL (" + string + ")");
        }
        try {
            string2 = this.OdbcApi.SQLNativeSql(this.hDbc, string);
        }
        catch (SQLException sQLException) {
            string2 = string;
        }
        return string2;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setAutoCommit (" + bl + ")");
        }
        int n = 1;
        this.validateConnection();
        if (!bl) {
            n = 0;
        }
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)102, n);
    }

    public boolean getAutoCommit() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getAutoCommit");
        }
        boolean bl = false;
        this.validateConnection();
        int n = this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)102);
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public void commit() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.commit");
        }
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)0);
    }

    public void rollback() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.rollback");
        }
        this.OdbcApi.SQLTransact(this.hEnv, this.hDbc, (short)1);
    }

    public void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.close");
        }
        this.closeAllStatements();
        if (!this.closed) {
            this.myDriver.disconnect(this.hDbc);
            this.myDriver.closeConnection(this.hDbc);
        }
        this.closed = true;
        this.URL = null;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getMetaData");
        }
        this.validateConnection();
        JdbcOdbcDatabaseMetaData jdbcOdbcDatabaseMetaData = new JdbcOdbcDatabaseMetaData(this.OdbcApi, this);
        return jdbcOdbcDatabaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setReadOnly (" + bl + ")");
        }
        int n = 0;
        this.validateConnection();
        if (bl) {
            n = 1;
        }
        try {
            this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)101, n);
            return;
        }
        catch (SQLException sQLException) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("setReadOnly exception ignored");
            }
            return;
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.isReadOnly");
        }
        boolean bl = false;
        this.validateConnection();
        int n = this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)101);
        if (n == 1) {
            bl = true;
        }
        return bl;
    }

    public void setCatalog(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setCatalog (" + string + ")");
        }
        this.validateConnection();
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)109, string);
    }

    public String getCatalog() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getCatalog");
        }
        this.validateConnection();
        return this.OdbcApi.SQLGetInfoString(this.hDbc, (short)16);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.setTransactionIsolation (" + n + ")");
        }
        this.validateConnection();
        switch (n) {
            case 0: {
                this.setAutoCommit(true);
                return;
            }
            case 1: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 1);
                return;
            }
            case 2: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 2);
                return;
            }
            case 4: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 4);
                return;
            }
            case 8: {
                this.setAutoCommit(false);
                this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, 8);
                return;
            }
        }
        this.setAutoCommit(false);
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)108, n);
    }

    public int getTransactionIsolation() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getTransactionIsolation");
        }
        int n = 0;
        this.validateConnection();
        int n2 = this.OdbcApi.SQLGetConnectOption(this.hDbc, (short)108);
        switch (n2) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 8: {
                n = 8;
                break;
            }
            default: {
                n = n2;
            }
        }
        return n;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Connection.getWarnings");
        }
        return this.lastWarning;
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public void validateConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    public int getHDBC() {
        return this.hDbc;
    }

    public void setURL(String string) {
        this.URL = string;
    }

    public String getURL() {
        return this.URL;
    }

    protected void setLoginTimeout(int n) throws SQLException {
        this.OdbcApi.SQLSetConnectOption(this.hDbc, (short)103, n);
    }

    public int getODBCVer() {
        if (this.odbcVer == 0) {
            String string;
            try {
                string = this.OdbcApi.SQLGetInfoString(this.hDbc, (short)10);
            }
            catch (SQLException sQLException) {
                string = "-1";
            }
            Integer n = new Integer(string.substring(0, 2));
            this.odbcVer = n;
        }
        return this.odbcVer;
    }

    protected void buildTypeInfo() throws SQLException {
        this.typeInfo = new Hashtable();
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Caching SQL type information");
        }
        ResultSet resultSet = this.getMetaData().getTypeInfo();
        boolean bl = resultSet.next();
        while (bl) {
            String string = resultSet.getString(1);
            int n = resultSet.getInt(2);
            if (this.typeInfo.get(new Integer(n)) == null) {
                JdbcOdbcTypeInfo jdbcOdbcTypeInfo = new JdbcOdbcTypeInfo();
                jdbcOdbcTypeInfo.setName(string);
                jdbcOdbcTypeInfo.setPrec(resultSet.getInt(3));
                this.typeInfo.put(new Integer(n), jdbcOdbcTypeInfo);
            }
            bl = resultSet.next();
        }
        resultSet.close();
    }

    protected void registerStatement(Statement statement) {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("Registering Statement " + statement);
        }
        this.statements.put(statement, "");
    }

    public void deregisterStatement(Statement statement) {
        if (this.statements.get(statement) != null) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("deregistering Statement " + statement);
            }
            this.statements.remove(statement);
        }
    }

    public synchronized void closeAllStatements() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace(this.statements.size() + " Statement(s) to close");
        }
        if (this.statements.size() == 0) {
            return;
        }
        Enumeration enumeration = this.statements.keys();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            statement.close();
        }
    }
}

