/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFBaseContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModDNContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;
import netscape.ldap.util.MimeBase64Decoder;
import netscape.ldap.util.MimeBase64Encoder;

public class LDIF
implements Serializable {
    private static final char COMMENT = '#';
    static final long serialVersionUID = -2710382547996750924L;
    private int m_version = 1;
    private boolean m_done = false;
    private LineReader m_reader;
    private String m_source;
    private MimeBase64Decoder m_decoder;
    private boolean m_currEntryDone = false;

    public LDIF() throws IOException {
        DataInputStream dataInputStream = new DataInputStream(System.in);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "UTF8"));
        this.m_reader = new LineReader(bufferedReader);
        this.m_source = "System.in";
        this.m_decoder = new MimeBase64Decoder();
    }

    public LDIF(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "UTF8"));
        this.m_reader = new LineReader(bufferedReader);
        this.m_source = string;
        this.m_decoder = new MimeBase64Decoder();
    }

    public LDIF(DataInputStream dataInputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)dataInputStream, "UTF8"));
        this.m_reader = new LineReader(bufferedReader);
        this.m_source = dataInputStream.toString();
    }

    public LDIFRecord nextRecord() throws IOException {
        if (this.m_done) {
            return null;
        }
        return this.parse_ldif_record(this.m_reader);
    }

    private LDIFRecord parse_ldif_record(LineReader lineReader) throws IOException {
        Object object;
        String string = null;
        String string2 = null;
        new Vector();
        LDIFRecord lDIFRecord = null;
        while ((string = lineReader.readLine()) != null && string.length() < 1) {
        }
        if (string == null) {
            return null;
        }
        if (string.startsWith("version:")) {
            this.m_version = Integer.parseInt(string.substring("version:".length()).trim());
            if (this.m_version != 1) {
                throw new IOException("Unexpected " + string);
            }
            string = lineReader.readLine();
            if (string != null && string.length() == 0) {
                string = lineReader.readLine();
            }
            if (string == null) {
                return null;
            }
        }
        if (!string.startsWith("dn:")) {
            throw new IOException("no dn found in <" + string + ">");
        }
        string2 = string.substring(3).trim();
        if (string2.startsWith(":") && string2.length() > 1) {
            object = string2.substring(1).trim();
            string2 = new String(this.getDecodedBytes((String)object), "UTF8");
        }
        object = this.parse_ldif_content(lineReader);
        lDIFRecord = new LDIFRecord(string2, (LDIFContent)object);
        return lDIFRecord;
    }

    private LDIFContent parse_ldif_content(LineReader lineReader) throws IOException {
        Object object;
        Vector<LDAPControl> vector;
        Hashtable<String, LDAPAttribute> hashtable;
        block28: {
            String string = lineReader.readLine();
            if (string == null || string.length() < 1 || string.equals("-")) {
                if (string != null && string.length() < 1) {
                    this.m_currEntryDone = true;
                }
                return null;
            }
            if (string.startsWith("changetype:")) {
                LDIFBaseContent lDIFBaseContent = null;
                String string2 = string.substring(11).trim();
                if (string2.equals("modify")) {
                    lDIFBaseContent = this.parse_mod_spec(lineReader);
                } else if (string2.equals("add")) {
                    lDIFBaseContent = this.parse_add_spec(lineReader);
                } else if (string2.equals("delete")) {
                    lDIFBaseContent = this.parse_delete_spec(lineReader);
                } else if (string2.equals("moddn") || string2.equals("modrdn")) {
                    lDIFBaseContent = this.parse_moddn_spec(lineReader);
                } else {
                    throw new IOException("change type not supported");
                }
                return lDIFBaseContent;
            }
            hashtable = new Hashtable<String, LDAPAttribute>();
            String string3 = null;
            Object object2 = null;
            LDAPAttribute lDAPAttribute = null;
            vector = null;
            do {
                if (string.startsWith("control:")) {
                    if (vector == null) {
                        vector = new Vector<LDAPControl>();
                    }
                    vector.addElement(this.parse_control_spec(string));
                    continue;
                }
                int n = string.length();
                if (n < 1) break block28;
                int n2 = string.indexOf(58);
                if (n2 == -1) {
                    throw new IOException("no ':' found in <" + string + ">");
                }
                string3 = string.substring(0, n2).toLowerCase();
                object2 = "";
                if (n > ++n2) {
                    if (string.charAt(n2) == ':') {
                        object = string.substring(++n2).trim();
                        object2 = this.getDecodedBytes((String)object);
                    } else if (string.charAt(n2) == '<') {
                        try {
                            object = new URL(string.substring(n2 + 1).trim());
                            String string4 = ((URL)object).getFile();
                            object2 = this.getFileContent(string4);
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new IOException(String.valueOf(malformedURLException) + ": cannot construct url " + string.substring(n2 + 1).trim());
                        }
                    } else {
                        object2 = string.substring(n2).trim();
                    }
                }
                if ((lDAPAttribute = (LDAPAttribute)hashtable.get(string3)) == null) {
                    lDAPAttribute = new LDAPAttribute(string3);
                }
                if (object2 instanceof String) {
                    lDAPAttribute.addValue((String)object2);
                } else {
                    lDAPAttribute.addValue((byte[])object2);
                }
                hashtable.put(string3, lDAPAttribute);
            } while ((string = lineReader.readLine()) != null && string.length() >= 1 && !string.equals("-"));
            if (string != null && string.length() < 1) {
                this.m_currEntryDone = true;
            }
        }
        LDIFAttributeContent lDIFAttributeContent = new LDIFAttributeContent();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            lDIFAttributeContent.addElement((LDAPAttribute)enumeration.nextElement());
        }
        hashtable.clear();
        if (vector != null) {
            object = new LDAPControl[vector.size()];
            vector.copyInto((Object[])object);
            lDIFAttributeContent.setControls((LDAPControl[])object);
            vector.removeAllElements();
        }
        return lDIFAttributeContent;
    }

    private byte[] getDecodedBytes(String string) {
        ByteBuf byteBuf = new ByteBuf(string);
        ByteBuf byteBuf2 = new ByteBuf();
        this.m_decoder.translate(byteBuf, byteBuf2);
        return byteBuf2.toBytes();
    }

    private byte[] getFileContent(String string) throws IOException {
        Object object;
        Object object2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        String string2 = string;
        int n = stringTokenizer.countTokens();
        if (n == 2) {
            object2 = (String)stringTokenizer.nextElement();
            int n2 = ((String)object2).lastIndexOf("/");
            object = ((String)object2).substring(n2 + 1);
            object2 = (String)stringTokenizer.nextElement();
            object2 = ((String)object2).replace('/', '\\');
            string2 = String.valueOf(object) + ":" + (String)object2;
        }
        object2 = new File(string2);
        byte[] byArray = new byte[(int)((File)object2).length()];
        object = new FileInputStream(string2);
        ((FileInputStream)object).read(byArray);
        return byArray;
    }

    private LDIFAddContent parse_add_spec(LineReader lineReader) throws IOException {
        LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)this.parse_ldif_content(lineReader);
        if (this.m_currEntryDone) {
            this.m_currEntryDone = false;
        }
        LDAPAttribute[] lDAPAttributeArray = lDIFAttributeContent.getAttributes();
        LDIFAddContent lDIFAddContent = new LDIFAddContent(lDAPAttributeArray);
        LDAPControl[] lDAPControlArray = lDIFAttributeContent.getControls();
        if (lDAPControlArray != null) {
            lDIFAddContent.setControls(lDAPControlArray);
        }
        return lDIFAddContent;
    }

    private LDIFDeleteContent parse_delete_spec(LineReader lineReader) throws IOException {
        Vector<LDAPControl> vector = null;
        LDIFDeleteContent lDIFDeleteContent = new LDIFDeleteContent();
        String string = lineReader.readLine();
        while (string != null && !string.equals("")) {
            if (string.startsWith("control:")) {
                if (vector == null) {
                    vector = new Vector<LDAPControl>();
                }
            } else {
                throw new IOException("invalid SEP");
            }
            vector.addElement(this.parse_control_spec(string));
            string = lineReader.readLine();
        }
        if (vector != null) {
            Object[] objectArray = new LDAPControl[vector.size()];
            vector.copyInto(objectArray);
            lDIFDeleteContent.setControls((LDAPControl[])objectArray);
            vector.removeAllElements();
        }
        return lDIFDeleteContent;
    }

    private LDIFModifyContent parse_mod_spec(LineReader lineReader) throws IOException {
        Vector<LDAPControl> vector = null;
        String string = null;
        string = lineReader.readLine();
        LDIFModifyContent lDIFModifyContent = new LDIFModifyContent();
        do {
            Object object;
            int n = -1;
            if (string.startsWith("add:")) {
                n = 0;
            } else if (string.startsWith("delete:")) {
                n = 1;
            } else if (string.startsWith("replace:")) {
                n = 2;
            } else {
                throw new IOException("unknown modify type");
            }
            LDIFAttributeContent lDIFAttributeContent = (LDIFAttributeContent)this.parse_ldif_content(lineReader);
            if (lDIFAttributeContent != null) {
                LDAPAttribute[] lDAPAttributeArray = lDIFAttributeContent.getAttributes();
                int n2 = 0;
                while (n2 < lDAPAttributeArray.length) {
                    object = new LDAPModification(n, lDAPAttributeArray[n2]);
                    lDIFModifyContent.addElement((LDAPModification)object);
                    ++n2;
                }
                object = lDIFAttributeContent.getControls();
                if (object != null) {
                    if (vector == null) {
                        vector = new Vector<LDAPControl>();
                    }
                    int n3 = 0;
                    while (n3 < ((LDAPControl[])object).length) {
                        vector.addElement(object[n3]);
                        ++n3;
                    }
                }
            } else {
                int n4 = string.indexOf(":");
                if (n4 == -1) {
                    throw new IOException("colon missing in " + string);
                }
                String string2 = string.substring(n4 + 1).trim();
                if (n == 0) {
                    throw new IOException("add operation needs the value for attribute " + string2);
                }
                object = new LDAPAttribute(string2);
                LDAPModification lDAPModification = new LDAPModification(n, (LDAPAttribute)object);
                lDIFModifyContent.addElement(lDAPModification);
            }
            if (!this.m_currEntryDone) continue;
            this.m_currEntryDone = false;
            break;
        } while ((string = lineReader.readLine()) != null && !string.equals(""));
        if (vector != null) {
            Object[] objectArray = new LDAPControl[vector.size()];
            vector.copyInto(objectArray);
            lDIFModifyContent.setControls((LDAPControl[])objectArray);
            vector.removeAllElements();
        }
        return lDIFModifyContent;
    }

    private LDIFModDNContent parse_moddn_spec(LineReader lineReader) throws IOException {
        Object[] objectArray;
        Vector<LDAPControl> vector = null;
        String string = null;
        string = lineReader.readLine();
        LDIFModDNContent lDIFModDNContent = new LDIFModDNContent();
        do {
            if (string.startsWith("newrdn:") && string.length() > "newrdn:".length() + 1) {
                lDIFModDNContent.setRDN(string.substring("newrdn:".length()).trim());
                continue;
            }
            if (string.startsWith("deleteoldrdn:") && string.length() > "deleteoldrdn:".length() + 1) {
                objectArray = string.substring("deleteoldrdn:".length()).trim();
                if (objectArray.equals("0")) {
                    lDIFModDNContent.setDeleteOldRDN(false);
                    continue;
                }
                if (objectArray.equals("1")) {
                    lDIFModDNContent.setDeleteOldRDN(true);
                    continue;
                }
                throw new IOException("Incorrect input for deleteOldRdn ");
            }
            if (string.startsWith("newsuperior:") && string.length() > "newsuperior:".length() + 1) {
                lDIFModDNContent.setNewParent(string.substring("newsuperior:".length()).trim());
                continue;
            }
            if (string.startsWith("newparent:") && string.length() > "newparent:".length() + 1) {
                lDIFModDNContent.setNewParent(string.substring("newparent:".length()).trim());
                continue;
            }
            if (!string.startsWith("control:")) continue;
            if (vector == null) {
                vector = new Vector<LDAPControl>();
            }
            vector.addElement(this.parse_control_spec(string));
        } while ((string = lineReader.readLine()) != null && !string.equals(""));
        if (vector != null) {
            objectArray = new LDAPControl[vector.size()];
            vector.copyInto(objectArray);
            lDIFModDNContent.setControls((LDAPControl[])objectArray);
            vector.removeAllElements();
        }
        return lDIFModDNContent;
    }

    protected LDAPControl parse_control_spec(String string) throws IOException {
        String string2;
        boolean bl = true;
        byte[] byArray = null;
        int n = string.length();
        int n2 = string.indexOf(58) + 2;
        if (n2 >= n) {
            throw new IOException("OID required for control");
        }
        if ((n2 = (string = string.substring(n2).trim()).indexOf(32)) < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n2);
            String string3 = (n2 = (string = string.substring(n2 + 1)).indexOf(58)) > 0 ? string.substring(0, n2) : string;
            if (string3.compareTo("true") == 0) {
                bl = true;
            } else if (string3.compareTo("false") == 0) {
                bl = false;
            } else {
                throw new IOException("Criticality for control must be true or false, not " + string3);
            }
            if (n2 > 0 && string.length() > ++n2) {
                if (string.charAt(n2) == ':') {
                    string = string.substring(++n2).trim();
                    byArray = this.getDecodedBytes(string);
                } else {
                    if (string.charAt(n2) == '<') {
                        String string4 = string.substring(n2 + 1).trim();
                        try {
                            URL uRL = new URL(string4);
                            String string5 = uRL.getFile();
                            byArray = this.getFileContent(string5);
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new IOException(String.valueOf(malformedURLException) + ": cannot construct url " + string4);
                        }
                    }
                    try {
                        byArray = string.substring(n2).trim().getBytes("UTF8");
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return new LDAPControl(string2, bl, byArray);
    }

    public static boolean isPrintable(byte[] byArray) {
        int n = byArray.length - 1;
        while (n >= 0) {
            if ((byArray[n] < 32 || byArray[n] > 127) && byArray[n] != 9) {
                return false;
            }
            --n;
        }
        return true;
    }

    public static void breakString(PrintWriter printWriter, String string, int n) {
        int n2 = string.length();
        int n3 = 0;
        int n4 = n;
        while (n2 > 0) {
            int n5 = Math.min(n4, n2);
            String string2 = string.substring(n3, n3 + n5);
            if (n3 != 0) {
                printWriter.print(" " + string2);
            } else {
                printWriter.print(string2);
                --n4;
            }
            n3 += n5;
            n2 -= n5;
            printWriter.print('\n');
        }
    }

    public int getVersion() {
        return this.m_version;
    }

    public String toString() {
        return "LDIF {" + this.m_source + "}";
    }

    public static String toPrintableString(byte[] byArray) {
        String string = "";
        if (LDIF.isPrintable(byArray)) {
            try {
                string = new String(byArray, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            ByteBuf byteBuf = new ByteBuf(byArray, 0, byArray.length);
            ByteBuf byteBuf2 = new ByteBuf();
            MimeBase64Encoder mimeBase64Encoder = new MimeBase64Encoder();
            mimeBase64Encoder.translate(byteBuf, byteBuf2);
            int n = byteBuf2.length();
            if (n > 0) {
                string = new String(byteBuf2.toBytes(), 0, n);
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: java LDIF <FILENAME>");
            System.exit(1);
        }
        LDIF lDIF = null;
        try {
            lDIF = new LDIF(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.println("Failed to read LDIF file " + stringArray[0] + ", " + exception.toString());
            System.exit(1);
        }
        try {
            LDIFRecord lDIFRecord = lDIF.nextRecord();
            while (lDIFRecord != null) {
                System.out.println(String.valueOf(lDIFRecord.toString()) + '\n');
                lDIFRecord = lDIF.nextRecord();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(1);
        }
        System.exit(0);
    }

    class LineReader {
        private BufferedReader _d;
        String _next;

        LineReader(BufferedReader bufferedReader) {
            LDIF.this = LDIF.this;
            this._d = bufferedReader;
        }

        String readLine() throws IOException {
            String string = null;
            String string2 = null;
            while (true) {
                if (this._next != null) {
                    string = this._next;
                    this._next = null;
                } else {
                    string = this._d.readLine();
                }
                if (string == null) break;
                if (string.length() < 1) {
                    if (string2 == null) {
                        string2 = string;
                        continue;
                    }
                    this._next = string;
                    break;
                }
                if (string.charAt(0) == COMMENT) continue;
                if (string.charAt(0) != ' ') {
                    if (string2 == null) {
                        string2 = string;
                        continue;
                    }
                    this._next = string;
                    break;
                }
                if (string2 == null) {
                    throw new IOException("continuation out of nowhere <" + string + ">");
                }
                string2 = String.valueOf(string2) + string.substring(1);
            }
            if (string == null) {
                LDIF.this.m_done = true;
            }
            return string2;
        }
    }
}

