/* -*- buffer-read-only: t -*- vi: set ro: */
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.6u-20010802-1407
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* Implementation : GUILE */

/* -*- c -*-
 * -----------------------------------------------------------------------
 * swig_lib/guile/guiledec.swg
 * Copyright (C) 2000 Matthias Koeppe
 *
 * Guile configuration file -- declarations
 * ----------------------------------------------------------------------- */

#define SWIGGUILE
#include "guile/gh.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(SWIG_NOINCLUDE)
#	define SWIGSTATIC
#elif defined(SWIG_GLOBAL)
#	define SWIGSTATIC
#else
#	define SWIGSTATIC static
#endif

#define GH_NOT_PASSED    SCM_UNDEFINED
#define GH_UNSPECIFIED   SCM_UNSPECIFIED

#define GUILE_APPEND_RESULT(object)						\
    if (gswig_result == GH_UNSPECIFIED)						\
        gswig_result = object;							\
    else {									\
        if (!gswig_list_p) {							\
	    gswig_list_p = 1;							\
	    gswig_result = gh_list(gswig_result, object, GH_NOT_PASSED);	\
        }									\
        else									\
            gswig_result = gh_append2(gswig_result,				\
                                      gh_list(object, GH_NOT_PASSED));		\
    }

/* scm_values was implemented on C level in 1.4.1, and the prototype
   is not included in libguile.h, so play safe and lookup `values'... */
#define GUILE_MAYBE_VALUES						\
    if (gswig_list_p)							\
        gswig_result = gh_apply(gh_lookup("values"), gswig_result);
    
#define GUILE_MAYBE_VECTOR				\
    if (gswig_list_p)					\
        gswig_result = gh_list_to_vector(gswig_result);

static char *
GSWIG_scm2str (SCM s)
{
  return gh_scm2newstr (s, NULL);
}

/* SCM_CHAR and SCM_CHARP were introduced in Guile 1.4; the following is for
   1.3.4 compatibility. */
#ifndef SCM_CHAR
#  define SCM_CHAR SCM_ICHR
#endif
#ifndef SCM_CHARP
#  define SCM_CHARP SCM_ICHRP
#endif

/* This function replaces gh_scm2char, which is broken in Guile 1.4 */
static char
GSWIG_scm2char (SCM s)
{
  if (SCM_CHARP(s)) return SCM_CHAR(s);
  scm_wrong_type_arg(NULL, 0, s);
}

/* More 1.3.4 compatibility */
#ifndef SCM_INPUT_PORT_P
#  define SCM_INPUT_PORT_P SCM_INPORTP
#  define SCM_OUTPUT_PORT_P SCM_OUTPORTP
#endif

/* Type system */

typedef struct SwigPtrType SwigPtrType;

typedef struct swig_type_info {
  const char  *name;
  void *(*converter)(void *);
  const char  *str;
  size_t tag;
} swig_type_info;

SWIGSTATIC void
SWIG_Guile_RegisterTypes (swig_type_info **table,
			  swig_type_info **init);

/* Register a new type-mapping with the type-checker.  origtype is the
   original datatype and newtype is an equivalent type.  cast is optional
   pointer to a function to cast pointer values between types (this is
   typically used to cast pointers from derived classes to base classes in
   C++).  */

SWIGSTATIC void
SWIG_RegisterMapping (const char *origtype, const char *newtype,
                      void *(*cast)(void *));

/* Register SWIG smobs with Guile.  */
SWIGSTATIC void
SWIG_Guile_Init();

/* Initialization function for this SWIG module; actually renamed by a
   #define */
/* extern void SWIG_init(); */

/* Get a pointer value from a smob.  If there is a type-mismatch,
   return nonzero; on success, return 0.  */
SWIGSTATIC int
SWIG_Guile_GetPtr (SCM s, void **result, swig_type_info *type);

/* Get a pointer value from a smob.  If there is a type-mismatch,
   signal a wrong-type-arg error for the given argument number. */
SWIGSTATIC void *
SWIG_Guile_MustGetPtr_ (SCM s, swig_type_info *type,
			int argnum, const char *func_name);

/* Use this convenience macro instead of the above function. */
#define SWIG_Guile_MustGetPtr(s, type, argnum) \
  SWIG_Guile_MustGetPtr_(s, type, argnum, FUNC_NAME)

/* Make a smob from a pointer and typeinfo.  */
SWIGSTATIC SCM
SWIG_Guile_MakePtr (void *ptr, swig_type_info *type);

/* Get arguments from an argument list */
SWIGSTATIC void
SWIG_Guile_GetArgs (SCM *dest, SCM rest,
		    int reqargs, int optargs,
		    const char *procname);

#ifdef __cplusplus
}
#endif

/* guiledec.swg ends here */
/* -*- c -*-
 * -----------------------------------------------------------------------
 * swig_lib/guile/guile.swg
 *
 * Guile configuration file.
 * ----------------------------------------------------------------------- */

/* SWIG pointer structure */

#ifdef __cplusplus
extern "C" {
#endif

struct SwigCast {
  unsigned short      type;		  /* Index into SwigPtrTbl          */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigCast    *next;		  /* Linked list pointer            */
};

struct SwigPtrType {
  const char         *name;               /* Datatype name                  */
  const char	     *prettyname;         /* Pretty datatype name           */
  unsigned short      tag;		  /* Index in SwigPtrTable          */
  struct SwigCast    *cast;		  /* List of compatible types       */
};

/* Some variables  */

static int SwigPtrMax  = 64;            /* Max entries that can be held */
                                        /* (may be adjusted dynamically) */
static int SwigPtrN    = 0;             /* Current number of entries */
static int SwigPtrSort = 0;             /* Status flag indicating sort */

/* Pointer table */
static SwigPtrType *SwigPtrList = 0;    /* Table containing types and
					   equivalences; items will only
                                           be appended */
static size_t *SwigPtrTbl = 0;          /* Sorted indirect table; items will
					   be inserted */

/* Sort comparison function */
static int
swigsort (const void *data1, const void *data2)
{
  size_t index1 = * (size_t *) data1;
  size_t index2 = * (size_t *) data2;
  return strcmp(SwigPtrList[index1].name, SwigPtrList[index2].name);
}

/* Register a new datatype with the type-checker */
SWIGSTATIC size_t
SWIG_RegisterType (const char *type, const char *prettyname)
{
  int i;

  /* Allocate the pointer table if necessary */
  if (!SwigPtrList) {
    SwigPtrList = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrTbl = (size_t *) malloc(SwigPtrMax*sizeof(size_t));
    SwigPtrN = 0;
  }
  /* Grow the table if necessary */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrList = (SwigPtrType *) realloc((char *) SwigPtrList,
					  SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrTbl = (size_t *) realloc((char *) SwigPtrTbl,
				    SwigPtrMax*sizeof(size_t));
  }
  /* Look up type */
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrList[i].name,type) == 0) {
      if (prettyname!=NULL)
	SwigPtrList[i].prettyname = prettyname;
      return i;
    }
  {
    struct SwigPtrType *t;
    size_t tag;
#if 0
    fprintf(stderr, "New type: %s\n", type);
#endif
    tag = SwigPtrTbl[SwigPtrN] = SwigPtrN;
    t = &SwigPtrList[tag];
    t->name = type;
    t->prettyname = prettyname;
    t->tag = SwigPtrN;
    t->cast = NULL;
    SwigPtrN++;
    SwigPtrSort = 0; 
    return tag;
  }
}

/* Register two data types and their mapping with the type checker. */
SWIGSTATIC void
SWIG_RegisterMapping (const char *origtype, const char *newtype, void *(*cast)(void *))
{
  size_t t = SWIG_RegisterType(origtype, NULL);

  if (newtype!=NULL) {
    size_t t1 = SWIG_RegisterType(newtype, NULL);
    struct SwigCast *c;
    /* Check for existing cast */
    for (c = SwigPtrList[t].cast; c && c->type!=t1; c=c->next) /* nothing */;
    if (c) {
      if (cast) c->cast = cast;
    }
    else {
      c = (struct SwigCast *) malloc(sizeof(struct SwigCast));
      c->type = t1;
      c->cast = cast;
      c->next = SwigPtrList[t].cast;
      SwigPtrList[t].cast = c;
    }
  }
}

/* Sort table */

static void
SWIG_SortTable (void)
{
  qsort ((void *) SwigPtrTbl, SwigPtrN, sizeof(size_t), swigsort);
  /* Indicate that everything is sorted */
  SwigPtrSort = 1;
}

/* Look up pointer-type entry in table */

static int
swigcmp (const void *key, const void *data)
{
  char *k = (char *) key;
  size_t index = *(size_t *)data;
  return strcmp(k, SwigPtrList[index].name);
}

static SwigPtrType *
SWIG_GetPtrType (const char *_t)
{
  size_t *result;
  if (!SwigPtrSort) SWIG_SortTable();
  result = (size_t *) bsearch(_t, SwigPtrTbl, SwigPtrN, sizeof(size_t), swigcmp);
  if (result!=NULL) return SwigPtrList+*result;
  else return NULL;
}

/* Cast a pointer if possible; returns 1 if successful */

static int
SWIG_Cast (void *source, size_t source_type,
	   void **ptr, size_t dest_type)
{
  if (dest_type != source_type) {
    /* We have a type mismatch.  Will have to look through our type
       mapping table to figure out whether or not we can accept this
       datatype.  */
    struct SwigCast *c;
    for (c = SwigPtrList[dest_type].cast;
	 c && c->type!=source_type; c = c->next) /* nothing */;
    if (c) {
      /* Get pointer value. */
      if (c->cast) *ptr = (*(c->cast))(source);
      else *ptr = source;
      return 1;
    }
    /* Didn't find any sort of match for this data.
       Get the pointer value and return false.  */
    *ptr = source;
    return 0;
  } else {
    /* Found a match on the first try.  Return pointer value.  */
    *ptr = source;
    return 1;
  }
}

/* Function for getting a pointer value */

static unsigned long swig_tag = 0;

SWIGSTATIC SCM
SWIG_Guile_MakePtr (void *ptr, swig_type_info *type)
{
  if (ptr==NULL) return SCM_EOL;
  SCM_RETURN_NEWSMOB((((unsigned long)type->tag << 16) | swig_tag),
		     ptr);
}

/* Return 0 if successful. */
SWIGSTATIC int
SWIG_Guile_GetPtr(SCM s, void **result, swig_type_info *type)
{
  if (SCM_NULLP(s)) {
    *result = NULL;
    return 0;
  }
  else if (SCM_NIMP(s)
	   && (unsigned long) SCM_TYP16(s) == swig_tag) {
    if (type) 
      return !SWIG_Cast((void *) SCM_CDR(s),
			(long) SCM_CAR(s) >> 16,
			result, type->tag);
    else {
      *result = (void *) SCM_CDR(s);
      return 0;
    }
  }
  return 1;
}

SWIGSTATIC void *
SWIG_Guile_MustGetPtr_ (SCM s, swig_type_info *type,
			int argnum, const char *func_name)
{
  void *result;
  if (SWIG_Guile_GetPtr(s, &result, type)) {
    /* type mismatch */
    scm_wrong_type_arg((char *) func_name, argnum, s);
  }
  return result;
}

/* Init */

static int
print_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  scm_puts("#<swig ", port);
  if (SwigPtrList[(long) SCM_CAR(swig_smob) >> 16].prettyname != NULL)
    scm_puts(SwigPtrList[(long) SCM_CAR(swig_smob) >> 16].prettyname, port);
  else scm_puts(SwigPtrList[(long) SCM_CAR(swig_smob) >> 16].name, port);
  scm_puts(" ", port);
  scm_intprint((long) SCM_CDR(swig_smob), 16, port);
  scm_puts(">", port);
  /* non-zero means success */
  return 1;
}

static SCM
equalp_swig (SCM A, SCM B)
{
  if (SCM_CAR(A) == SCM_CAR(B)
      && SCM_CDR(A) == SCM_CDR(B))
    return SCM_BOOL_T;
  else return SCM_BOOL_F;
}

SWIGSTATIC void
SWIG_Guile_Init (void)
{
  if (swig_tag == 0) {
    swig_tag = scm_make_smob_type_mfpe((char *) "swig", 0, NULL, NULL,
				       print_swig, equalp_swig);
  }
}

/* Convert datatype table */

SWIGSTATIC
void SWIG_Guile_RegisterTypes(swig_type_info **table,
			      swig_type_info **init)
{
  for (; *init; table++, init++) {
    swig_type_info *type = *table = *init;
    const char *origname = type->name;
    /* Register datatype itself and store pointer back */
    type->tag = SWIG_RegisterType(origname, type->str);
    /* Register compatible types */
    for (type++; type->name; type++)
      SWIG_RegisterMapping(origname, type->name, type->converter);
  }    
}

SWIGSTATIC void
SWIG_Guile_GetArgs (SCM *dest, SCM rest,
		    int reqargs, int optargs,
		    const char *procname)
{
  int i;
  for (i = 0; i<reqargs; i++) {
    if (!SCM_CONSP(rest))
      scm_wrong_num_args(gh_str02scm((char *) procname));
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
  }
  for (i = 0; i<optargs && SCM_CONSP(rest); i++) {
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
  }
  for (; i<optargs; i++)
    *dest++ = GH_NOT_PASSED;
  if (!SCM_NULLP(rest))
    scm_wrong_num_args(gh_str02scm((char *) procname));
}

#ifdef __cplusplus
}
#endif

/* guile.swg ends here */
extern void
SWIG_init (void)
;

/* -------- TYPES TABLE (BEGIN) -------- */

#define  SWIGTYPE_p_instance swig_types[0] 
#define  SWIGTYPE_p_p_instance swig_types[1] 
#define  SWIGTYPE_p_gui_item swig_types[2] 
#define  SWIGTYPE_p_parameter_description swig_types[3] 
#define  SWIGTYPE_p_void swig_types[4] 
#define  SWIGTYPE_p_GtkWidget swig_types[5] 
#define  SWIGTYPE_p_p_void swig_types[6] 
#define  SWIGTYPE_p_componant swig_types[7] 
static swig_type_info *swig_types[9];

/* -------- TYPES TABLE (END) -------- */


#include "gtk/gtk.h"
#include "crank.h"
#include "componant.h"
#include "parameter.h"
#include "files.h"

/* Return new instance of a componant */
instance *make_new_instance(struct componant *componant_class);

/* Return a copy of the instance */
instance *duplicate_instance(instance *i);

/* Deallocate instance */
void free_instance(instance *i); 

/* Change a parameter of an instance */
void poke_param(instance *i, int param_index, void *value_ptr);

/* Query a parameter of an instance */
void *peek_param(instance *i, int param_index);

/* Request a parameter dump from an instance */
char *dump_parameters(instance *i);
    
/* Set an instance from a parameter set */
instance *instantiate_parameters(char *parameter_string);

/** transform componant specific *******/

char *transform(instance *transform, char *text);

/** fitness componant specific *******/

double fitness(instance *fitness, char *text);

/** gui componant specific *******/

gui_item *build_gui_item(instance *gui, instance *i); 

int fact(int n);
componant *lookup_componant(componant *, int n);
const char *componant_type_lookup(componant_type type);
void free_componant(componant *componant_record);
void free_componant_list(componant *componant_list);

instance *get_current_transform(void);
instance *get_current_heuristic(void);
instance *get_current_fitness(void);
instance *get_current_gui_transform(void);
instance *get_current_gui_heuristic(void);
instance *get_current_gui_fitness(void);
void set_current_transform(instance *i);
void set_current_heuristic(instance *i);
void set_current_fitness(instance *i);
void set_current_gui_transform(instance *i);
void set_current_gui_heuristic(instance *i);
void set_current_gui_fitness(instance *i);

componant *get_componant_list(void);
void set_componant_list(componant *componant_list);

int get_number_of_componants(void);
void set_number_of_componants(int number_of_componants);

void clear_gui_globals(void);

GtkWidget *get_heuristic_log(void);
void set_heuristic_log(GtkWidget *heuristic_log);

int get_stop_heuristic(void);
void set_stop_heuristic(int stop_heuristic);

GtkWidget *get_current_transform_gui(void);
void set_current_transform_gui(GtkWidget *current_transform_gui);
GtkWidget *get_current_heuristic_gui(void);
void set_current_heuristic_gui(GtkWidget *current_heuristic_gui);
GtkWidget *get_current_fitness_gui(void);
void set_current_fitness_gui(GtkWidget *current_fitness_gui);


GtkWidget *get_main_window(void);
void set_main_window(GtkWidget *main_window);

instance **get_componant_choice_install_here(void);
void set_componant_choice_install_here(char *id_string);

componant *get_componant_choice_clist_selected_componant(void);
void set_componant_choice_clist_selected_componant(componant *);

void lock_callbacks(void);
void unlock_callbacks(void);
int islocked(void);

char *parameter_enum_value_name(parameter_description *param_descrip, int value_index);
const char *parameter_type_lookup(parameter_type type);

char *file_load_text(char *filename);
int file_save_text(char *filename, char *text);

void enter_gui(void);
void start_gui(void);
void flush_gui(void);
void post_cleanup_gui(void);

void *int2void(int i);
void *double2void(double d);
void *string2void(char *txt);

int void2int(void *v);
double void2double(void *v);
char *void2string(void *v);

componant *lookup_componant_by_name(componant *componant_list, char *name) ;

int parameter_get_default_int_or_enum(parameter_description *param_descrip);
double parameter_get_default_double(parameter_description *param_descrip);
char *parameter_get_default_string(parameter_description *param_descrip);

void set_returned_instance(instance *i);
instance *get_returned_instance(void);

char *generate_patch(instance *transform, instance *heuristic, instance *fitness,
		     instance *gui_transform, instance *gui_heuristic, instance *gui_fitness,
		     char *name, char *description);

static SCM
_wrap_make_new_instance (SCM s_0)
{
    #define FUNC_NAME "make-new-instance"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (instance *)make_new_instance(arg0);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_duplicate_instance (SCM s_0)
{
    #define FUNC_NAME "duplicate-instance"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (instance *)duplicate_instance(arg0);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_free_instance (SCM s_0)
{
    #define FUNC_NAME "free-instance"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    free_instance(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_poke_param (SCM s_0, SCM s_1, SCM s_2)
{
    #define FUNC_NAME "poke-param"
    
    instance *arg0 ;
    int arg1 ;
    void *arg2 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = gh_scm2int(s_1);
    }
    {
        if (SWIG_Guile_GetPtr(s_2, (void **) &arg2, NULL))
        scm_wrong_type_arg(FUNC_NAME, 3, s_2);
    }
    gh_defer_ints();
    poke_param(arg0,arg1,arg2);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_peek_param (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "peek-param"
    
    instance *arg0 ;
    int arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    void *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = gh_scm2int(s_1);
    }
    gh_defer_ints();
    result = (void *)peek_param(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_void);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_dump_parameters (SCM s_0)
{
    #define FUNC_NAME "dump-parameters"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *)dump_parameters(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_instantiate_parameters (SCM s_0)
{
    #define FUNC_NAME "instantiate-parameters"
    
    char *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    {
        arg0 = GSWIG_scm2str(s_0);
    }
    gh_defer_ints();
    result = (instance *)instantiate_parameters(arg0);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    if (arg0) scm_must_free(arg0);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_transform (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "transform"
    
    instance *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    result = (char *)transform(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_fitness (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "fitness"
    
    instance *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    double result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    result = (double )fitness(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = gh_double2scm(result);
    }
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_build_gui_item (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "build-gui-item"
    
    instance *arg0 ;
    instance *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    gui_item *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        if (SWIG_Guile_GetPtr(s_1, (void **) &arg1, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 2, s_1);
    }
    gh_defer_ints();
    result = (gui_item *)build_gui_item(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_gui_item);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_lookup_componant (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "lookup-componant"
    
    componant *arg0 ;
    int arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    componant *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = gh_scm2int(s_1);
    }
    gh_defer_ints();
    result = (componant *)lookup_componant(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_componant);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_type_lookup (SCM s_0)
{
    #define FUNC_NAME "componant-type-lookup"
    
    int arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        arg0 = gh_scm2int(s_0);
    }
    gh_defer_ints();
    result = (char *)componant_type_lookup(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_free_componant (SCM s_0)
{
    #define FUNC_NAME "free-componant"
    
    componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    free_componant(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_free_componant_list (SCM s_0)
{
    #define FUNC_NAME "free-componant-list"
    
    componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    free_componant_list(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_transform ()
{
    #define FUNC_NAME "get-current-transform"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    gh_defer_ints();
    result = (instance *)get_current_transform();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_heuristic ()
{
    #define FUNC_NAME "get-current-heuristic"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    gh_defer_ints();
    result = (instance *)get_current_heuristic();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_fitness ()
{
    #define FUNC_NAME "get-current-fitness"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    gh_defer_ints();
    result = (instance *)get_current_fitness();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_gui_transform ()
{
    #define FUNC_NAME "get-current-gui-transform"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    gh_defer_ints();
    result = (instance *)get_current_gui_transform();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_gui_heuristic ()
{
    #define FUNC_NAME "get-current-gui-heuristic"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    gh_defer_ints();
    result = (instance *)get_current_gui_heuristic();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_gui_fitness ()
{
    #define FUNC_NAME "get-current-gui-fitness"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    gh_defer_ints();
    result = (instance *)get_current_gui_fitness();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_transform (SCM s_0)
{
    #define FUNC_NAME "set-current-transform"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_transform(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_heuristic (SCM s_0)
{
    #define FUNC_NAME "set-current-heuristic"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_heuristic(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_fitness (SCM s_0)
{
    #define FUNC_NAME "set-current-fitness"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_fitness(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_gui_transform (SCM s_0)
{
    #define FUNC_NAME "set-current-gui-transform"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_gui_transform(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_gui_heuristic (SCM s_0)
{
    #define FUNC_NAME "set-current-gui-heuristic"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_gui_heuristic(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_gui_fitness (SCM s_0)
{
    #define FUNC_NAME "set-current-gui-fitness"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_gui_fitness(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_componant_list ()
{
    #define FUNC_NAME "get-componant-list"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    componant *result ;
    
    gh_defer_ints();
    result = (componant *)get_componant_list();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_componant);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_componant_list (SCM s_0)
{
    #define FUNC_NAME "set-componant-list"
    
    componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_componant_list(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_number_of_componants ()
{
    #define FUNC_NAME "get-number-of-componants"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    gh_defer_ints();
    result = (int )get_number_of_componants();
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_number_of_componants (SCM s_0)
{
    #define FUNC_NAME "set-number-of-componants"
    
    int arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg0 = gh_scm2int(s_0);
    }
    gh_defer_ints();
    set_number_of_componants(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_clear_gui_globals ()
{
    #define FUNC_NAME "clear-gui-globals"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    
    gh_defer_ints();
    clear_gui_globals();
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_heuristic_log ()
{
    #define FUNC_NAME "get-heuristic-log"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    GtkWidget *result ;
    
    gh_defer_ints();
    result = (GtkWidget *)get_heuristic_log();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_GtkWidget);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_heuristic_log (SCM s_0)
{
    #define FUNC_NAME "set-heuristic-log"
    
    GtkWidget *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_GtkWidget))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_heuristic_log(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_stop_heuristic ()
{
    #define FUNC_NAME "get-stop-heuristic"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    gh_defer_ints();
    result = (int )get_stop_heuristic();
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_stop_heuristic (SCM s_0)
{
    #define FUNC_NAME "set-stop-heuristic"
    
    int arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg0 = gh_scm2int(s_0);
    }
    gh_defer_ints();
    set_stop_heuristic(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_transform_gui ()
{
    #define FUNC_NAME "get-current-transform-gui"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    GtkWidget *result ;
    
    gh_defer_ints();
    result = (GtkWidget *)get_current_transform_gui();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_GtkWidget);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_transform_gui (SCM s_0)
{
    #define FUNC_NAME "set-current-transform-gui"
    
    GtkWidget *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_GtkWidget))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_transform_gui(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_heuristic_gui ()
{
    #define FUNC_NAME "get-current-heuristic-gui"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    GtkWidget *result ;
    
    gh_defer_ints();
    result = (GtkWidget *)get_current_heuristic_gui();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_GtkWidget);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_heuristic_gui (SCM s_0)
{
    #define FUNC_NAME "set-current-heuristic-gui"
    
    GtkWidget *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_GtkWidget))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_heuristic_gui(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_current_fitness_gui ()
{
    #define FUNC_NAME "get-current-fitness-gui"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    GtkWidget *result ;
    
    gh_defer_ints();
    result = (GtkWidget *)get_current_fitness_gui();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_GtkWidget);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_current_fitness_gui (SCM s_0)
{
    #define FUNC_NAME "set-current-fitness-gui"
    
    GtkWidget *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_GtkWidget))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_current_fitness_gui(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_main_window ()
{
    #define FUNC_NAME "get-main-window"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    GtkWidget *result ;
    
    gh_defer_ints();
    result = (GtkWidget *)get_main_window();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_GtkWidget);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_main_window (SCM s_0)
{
    #define FUNC_NAME "set-main-window"
    
    GtkWidget *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_GtkWidget))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_main_window(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_componant_choice_install_here ()
{
    #define FUNC_NAME "get-componant-choice-install-here"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance **result ;
    
    gh_defer_ints();
    result = (instance **)get_componant_choice_install_here();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_componant_choice_install_here (SCM s_0)
{
    #define FUNC_NAME "set-componant-choice-install-here"
    
    char *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        arg0 = GSWIG_scm2str(s_0);
    }
    gh_defer_ints();
    set_componant_choice_install_here(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg0) scm_must_free(arg0);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_componant_choice_clist_selected_componant ()
{
    #define FUNC_NAME "get-componant-choice-clist-selected-componant"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    componant *result ;
    
    gh_defer_ints();
    result = (componant *)get_componant_choice_clist_selected_componant();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_componant);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_componant_choice_clist_selected_componant (SCM s_0)
{
    #define FUNC_NAME "set-componant-choice-clist-selected-componant"
    
    componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_componant_choice_clist_selected_componant(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_lock_callbacks ()
{
    #define FUNC_NAME "lock-callbacks"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    
    gh_defer_ints();
    lock_callbacks();
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_unlock_callbacks ()
{
    #define FUNC_NAME "unlock-callbacks"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    
    gh_defer_ints();
    unlock_callbacks();
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_islocked ()
{
    #define FUNC_NAME "islocked"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    gh_defer_ints();
    result = (int )islocked();
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_enum_value_name (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "parameter-enum-value-name"
    
    parameter_description *arg0 ;
    int arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = gh_scm2int(s_1);
    }
    gh_defer_ints();
    result = (char *)parameter_enum_value_name(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_type_lookup (SCM s_0)
{
    #define FUNC_NAME "parameter-type-lookup"
    
    int arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        arg0 = gh_scm2int(s_0);
    }
    gh_defer_ints();
    result = (char *)parameter_type_lookup(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_file_load_text (SCM s_0)
{
    #define FUNC_NAME "file-load-text"
    
    char *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        arg0 = GSWIG_scm2str(s_0);
    }
    gh_defer_ints();
    result = (char *)file_load_text(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    if (arg0) scm_must_free(arg0);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_file_save_text (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "file-save-text"
    
    char *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    {
        arg0 = GSWIG_scm2str(s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    result = (int )file_save_text(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    if (arg0) scm_must_free(arg0);
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_enter_gui ()
{
    #define FUNC_NAME "enter-gui"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    
    gh_defer_ints();
    enter_gui();
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_start_gui ()
{
    #define FUNC_NAME "start-gui"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    
    gh_defer_ints();
    start_gui();
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_flush_gui ()
{
    #define FUNC_NAME "flush-gui"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    
    gh_defer_ints();
    flush_gui();
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_post_cleanup_gui ()
{
    #define FUNC_NAME "post-cleanup-gui"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    
    gh_defer_ints();
    post_cleanup_gui();
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_int2void (SCM s_0)
{
    #define FUNC_NAME "int2void"
    
    int arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    void *result ;
    
    {
        arg0 = gh_scm2int(s_0);
    }
    gh_defer_ints();
    result = (void *)int2void(arg0);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_void);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_double2void (SCM s_0)
{
    #define FUNC_NAME "double2void"
    
    double arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    void *result ;
    
    {
        arg0 = gh_scm2double(s_0);
    }
    gh_defer_ints();
    result = (void *)double2void(arg0);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_void);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_string2void (SCM s_0)
{
    #define FUNC_NAME "string2void"
    
    char *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    void *result ;
    
    {
        arg0 = GSWIG_scm2str(s_0);
    }
    gh_defer_ints();
    result = (void *)string2void(arg0);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_void);
    }
    if (arg0) scm_must_free(arg0);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_void2int (SCM s_0)
{
    #define FUNC_NAME "void2int"
    
    void *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, NULL))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (int )void2int(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_void2double (SCM s_0)
{
    #define FUNC_NAME "void2double"
    
    void *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    double result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, NULL))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (double )void2double(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_double2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_void2string (SCM s_0)
{
    #define FUNC_NAME "void2string"
    
    void *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, NULL))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *)void2string(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_lookup_componant_by_name (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "lookup-componant-by-name"
    
    componant *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    componant *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    result = (componant *)lookup_componant_by_name(arg0,arg1);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_componant);
    }
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_get_default_int_or_enum (SCM s_0)
{
    #define FUNC_NAME "parameter-get-default-int-or-enum"
    
    parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (int )parameter_get_default_int_or_enum(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_get_default_double (SCM s_0)
{
    #define FUNC_NAME "parameter-get-default-double"
    
    parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    double result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (double )parameter_get_default_double(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_double2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_get_default_string (SCM s_0)
{
    #define FUNC_NAME "parameter-get-default-string"
    
    parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *)parameter_get_default_string(arg0);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_set_returned_instance (SCM s_0)
{
    #define FUNC_NAME "set-returned-instance"
    
    instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    set_returned_instance(arg0);
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_get_returned_instance ()
{
    #define FUNC_NAME "get-returned-instance"
    
    SCM gswig_result;
    int gswig_list_p = 0;
    instance *result ;
    
    gh_defer_ints();
    result = (instance *)get_returned_instance();
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_instance);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_generate_patch (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5, SCM s_6, SCM s_7)
{
    #define FUNC_NAME "generate-patch"
    
    instance *arg0 ;
    instance *arg1 ;
    instance *arg2 ;
    instance *arg3 ;
    instance *arg4 ;
    instance *arg5 ;
    char *arg6 ;
    char *arg7 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        if (SWIG_Guile_GetPtr(s_1, (void **) &arg1, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 2, s_1);
    }
    {
        if (SWIG_Guile_GetPtr(s_2, (void **) &arg2, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 3, s_2);
    }
    {
        if (SWIG_Guile_GetPtr(s_3, (void **) &arg3, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 4, s_3);
    }
    {
        if (SWIG_Guile_GetPtr(s_4, (void **) &arg4, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 5, s_4);
    }
    {
        if (SWIG_Guile_GetPtr(s_5, (void **) &arg5, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 6, s_5);
    }
    {
        arg6 = GSWIG_scm2str(s_6);
    }
    {
        arg7 = GSWIG_scm2str(s_7);
    }
    gh_defer_ints();
    result = (char *)generate_patch(arg0,arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    if (arg6) scm_must_free(arg6);
    if (arg7) scm_must_free(arg7);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_type_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "parameter-description-type-set"
    
    struct parameter_description *arg0 ;
    int arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = gh_scm2int(s_1);
    }
    gh_defer_ints();
    arg0->type = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_type_get (SCM s_0)
{
    #define FUNC_NAME "parameter-description-type-get"
    
    struct parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = ( int ) (arg0->type);
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_name_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "parameter-description-name-set"
    
    struct parameter_description *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->name = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_name_get (SCM s_0)
{
    #define FUNC_NAME "parameter-description-name-get"
    
    struct parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->name);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_data_one_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "parameter-description-data-one-set"
    
    struct parameter_description *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->data_one = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_data_one_get (SCM s_0)
{
    #define FUNC_NAME "parameter-description-data-one-get"
    
    struct parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->data_one);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_data_two_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "parameter-description-data-two-set"
    
    struct parameter_description *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->data_two = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_data_two_get (SCM s_0)
{
    #define FUNC_NAME "parameter-description-data-two-get"
    
    struct parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->data_two);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_default_value_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "parameter-description-default-value-set"
    
    struct parameter_description *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->default_value = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_default_value_get (SCM s_0)
{
    #define FUNC_NAME "parameter-description-default-value-get"
    
    struct parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->default_value);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_description_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "parameter-description-description-set"
    
    struct parameter_description *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->description = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_parameter_description_description_get (SCM s_0)
{
    #define FUNC_NAME "parameter-description-description-get"
    
    struct parameter_description *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->description);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_instance_componant_class_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "instance-componant-class-set"
    
    struct instance *arg0 ;
    struct componant *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        if (SWIG_Guile_GetPtr(s_1, (void **) &arg1, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 2, s_1);
    }
    gh_defer_ints();
    arg0->componant_class = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_instance_componant_class_get (SCM s_0)
{
    #define FUNC_NAME "instance-componant-class-get"
    
    struct instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    struct componant *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (struct componant *) (arg0->componant_class);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_componant);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_instance_parameters_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "instance-parameters-set"
    
    struct instance *arg0 ;
    void **arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        if (SWIG_Guile_GetPtr(s_1, (void **) &arg1, SWIGTYPE_p_p_void))
        scm_wrong_type_arg(FUNC_NAME, 2, s_1);
    }
    gh_defer_ints();
    arg0->parameters = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_instance_parameters_get (SCM s_0)
{
    #define FUNC_NAME "instance-parameters-get"
    
    struct instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    void **result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (void **) (arg0->parameters);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_p_void);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_instance_data_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "instance-data-set"
    
    struct instance *arg0 ;
    void *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        if (SWIG_Guile_GetPtr(s_1, (void **) &arg1, NULL))
        scm_wrong_type_arg(FUNC_NAME, 2, s_1);
    }
    gh_defer_ints();
    arg0->data = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_instance_data_get (SCM s_0)
{
    #define FUNC_NAME "instance-data-get"
    
    struct instance *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    void *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_instance))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (void *) (arg0->data);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_void);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_filename_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "componant-filename-set"
    
    struct componant *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->filename = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_filename_get (SCM s_0)
{
    #define FUNC_NAME "componant-filename-get"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->filename);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_name_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "componant-name-set"
    
    struct componant *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->name = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_name_get (SCM s_0)
{
    #define FUNC_NAME "componant-name-get"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->name);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_type_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "componant-type-set"
    
    struct componant *arg0 ;
    int arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = gh_scm2int(s_1);
    }
    gh_defer_ints();
    arg0->type = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_type_get (SCM s_0)
{
    #define FUNC_NAME "componant-type-get"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = ( int ) (arg0->type);
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_description_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "componant-description-set"
    
    struct componant *arg0 ;
    char *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = GSWIG_scm2str(s_1);
    }
    gh_defer_ints();
    arg0->description = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    if (arg1) scm_must_free(arg1);
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_description_get (SCM s_0)
{
    #define FUNC_NAME "componant-description-get"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    char *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (char *) (arg0->description);
    gh_allow_ints();
    {
        gswig_result = gh_str02scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_number_of_parameters_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "componant-number-of-parameters-set"
    
    struct componant *arg0 ;
    int arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        arg1 = gh_scm2int(s_1);
    }
    gh_defer_ints();
    arg0->number_of_parameters = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_number_of_parameters_get (SCM s_0)
{
    #define FUNC_NAME "componant-number-of-parameters-get"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    int result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (int ) (arg0->number_of_parameters);
    gh_allow_ints();
    {
        gswig_result = gh_int2scm(result);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_parameter_description_table_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "componant-parameter-description-table-set"
    
    struct componant *arg0 ;
    parameter_description *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        if (SWIG_Guile_GetPtr(s_1, (void **) &arg1, SWIGTYPE_p_parameter_description))
        scm_wrong_type_arg(FUNC_NAME, 2, s_1);
    }
    gh_defer_ints();
    arg0->parameter_description_table = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_parameter_description_table_get (SCM s_0)
{
    #define FUNC_NAME "componant-parameter-description-table-get"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    parameter_description *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (parameter_description *) (arg0->parameter_description_table);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_parameter_description);
    }
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_next_set (SCM s_0, SCM s_1)
{
    #define FUNC_NAME "componant-next-set"
    
    struct componant *arg0 ;
    struct componant *arg1 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    {
        if (SWIG_Guile_GetPtr(s_1, (void **) &arg1, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 2, s_1);
    }
    gh_defer_ints();
    arg0->next = arg1;
    gh_allow_ints();
    gswig_result = GH_UNSPECIFIED;
    return gswig_result;
    #undef FUNC_NAME
}


static SCM
_wrap_componant_next_get (SCM s_0)
{
    #define FUNC_NAME "componant-next-get"
    
    struct componant *arg0 ;
    SCM gswig_result;
    int gswig_list_p = 0;
    struct componant *result ;
    
    {
        if (SWIG_Guile_GetPtr(s_0, (void **) &arg0, SWIGTYPE_p_componant))
        scm_wrong_type_arg(FUNC_NAME, 1, s_0);
    }
    gh_defer_ints();
    result = (struct componant *) (arg0->next);
    gh_allow_ints();
    {
        gswig_result = SWIG_Guile_MakePtr (result, SWIGTYPE_p_componant);
    }
    return gswig_result;
    #undef FUNC_NAME
}



/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_instance[] = {{"_p_instance", 0, "struct instance *"},{"_p_instance"},{0}};
static swig_type_info _swigt__p_p_instance[] = {{"_p_p_instance", 0, "instance **"},{"_p_p_instance"},{0}};
static swig_type_info _swigt__p_gui_item[] = {{"_p_gui_item", 0, "gui_item *"},{"_p_gui_item"},{0}};
static swig_type_info _swigt__p_parameter_description[] = {{"_p_parameter_description", 0, "parameter_description *"},{"_p_parameter_description"},{0}};
static swig_type_info _swigt__p_void[] = {{"_p_void", 0, "void *"},{"_p_void"},{0}};
static swig_type_info _swigt__p_GtkWidget[] = {{"_p_GtkWidget", 0, "GtkWidget *"},{"_p_GtkWidget"},{0}};
static swig_type_info _swigt__p_p_void[] = {{"_p_p_void", 0, "void **"},{"_p_p_void"},{0}};
static swig_type_info _swigt__p_componant[] = {{"_p_componant", 0, "struct componant *"},{"_p_componant"},{0}};

static swig_type_info *swig_types_initial[] = {
_swigt__p_instance, 
_swigt__p_p_instance, 
_swigt__p_gui_item, 
_swigt__p_parameter_description, 
_swigt__p_void, 
_swigt__p_GtkWidget, 
_swigt__p_p_void, 
_swigt__p_componant, 
0
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

extern void
SWIG_init (void)
{
    SWIG_Guile_Init();
    gh_new_procedure("make-new-instance", (SCM (*) ()) _wrap_make_new_instance, 1, 0, 0);
    gh_new_procedure("duplicate-instance", (SCM (*) ()) _wrap_duplicate_instance, 1, 0, 0);
    gh_new_procedure("free-instance", (SCM (*) ()) _wrap_free_instance, 1, 0, 0);
    gh_new_procedure("poke-param", (SCM (*) ()) _wrap_poke_param, 3, 0, 0);
    gh_new_procedure("peek-param", (SCM (*) ()) _wrap_peek_param, 2, 0, 0);
    gh_new_procedure("dump-parameters", (SCM (*) ()) _wrap_dump_parameters, 1, 0, 0);
    gh_new_procedure("instantiate-parameters", (SCM (*) ()) _wrap_instantiate_parameters, 1, 0, 0);
    gh_new_procedure("transform", (SCM (*) ()) _wrap_transform, 2, 0, 0);
    gh_new_procedure("fitness", (SCM (*) ()) _wrap_fitness, 2, 0, 0);
    gh_new_procedure("build-gui-item", (SCM (*) ()) _wrap_build_gui_item, 2, 0, 0);
    gh_new_procedure("lookup-componant", (SCM (*) ()) _wrap_lookup_componant, 2, 0, 0);
    gh_new_procedure("componant-type-lookup", (SCM (*) ()) _wrap_componant_type_lookup, 1, 0, 0);
    gh_new_procedure("free-componant", (SCM (*) ()) _wrap_free_componant, 1, 0, 0);
    gh_new_procedure("free-componant-list", (SCM (*) ()) _wrap_free_componant_list, 1, 0, 0);
    gh_new_procedure("get-current-transform", (SCM (*) ()) _wrap_get_current_transform, 0, 0, 0);
    gh_new_procedure("get-current-heuristic", (SCM (*) ()) _wrap_get_current_heuristic, 0, 0, 0);
    gh_new_procedure("get-current-fitness", (SCM (*) ()) _wrap_get_current_fitness, 0, 0, 0);
    gh_new_procedure("get-current-gui-transform", (SCM (*) ()) _wrap_get_current_gui_transform, 0, 0, 0);
    gh_new_procedure("get-current-gui-heuristic", (SCM (*) ()) _wrap_get_current_gui_heuristic, 0, 0, 0);
    gh_new_procedure("get-current-gui-fitness", (SCM (*) ()) _wrap_get_current_gui_fitness, 0, 0, 0);
    gh_new_procedure("set-current-transform", (SCM (*) ()) _wrap_set_current_transform, 1, 0, 0);
    gh_new_procedure("set-current-heuristic", (SCM (*) ()) _wrap_set_current_heuristic, 1, 0, 0);
    gh_new_procedure("set-current-fitness", (SCM (*) ()) _wrap_set_current_fitness, 1, 0, 0);
    gh_new_procedure("set-current-gui-transform", (SCM (*) ()) _wrap_set_current_gui_transform, 1, 0, 0);
    gh_new_procedure("set-current-gui-heuristic", (SCM (*) ()) _wrap_set_current_gui_heuristic, 1, 0, 0);
    gh_new_procedure("set-current-gui-fitness", (SCM (*) ()) _wrap_set_current_gui_fitness, 1, 0, 0);
    gh_new_procedure("get-componant-list", (SCM (*) ()) _wrap_get_componant_list, 0, 0, 0);
    gh_new_procedure("set-componant-list", (SCM (*) ()) _wrap_set_componant_list, 1, 0, 0);
    gh_new_procedure("get-number-of-componants", (SCM (*) ()) _wrap_get_number_of_componants, 0, 0, 0);
    gh_new_procedure("set-number-of-componants", (SCM (*) ()) _wrap_set_number_of_componants, 1, 0, 0);
    gh_new_procedure("clear-gui-globals", (SCM (*) ()) _wrap_clear_gui_globals, 0, 0, 0);
    gh_new_procedure("get-heuristic-log", (SCM (*) ()) _wrap_get_heuristic_log, 0, 0, 0);
    gh_new_procedure("set-heuristic-log", (SCM (*) ()) _wrap_set_heuristic_log, 1, 0, 0);
    gh_new_procedure("get-stop-heuristic", (SCM (*) ()) _wrap_get_stop_heuristic, 0, 0, 0);
    gh_new_procedure("set-stop-heuristic", (SCM (*) ()) _wrap_set_stop_heuristic, 1, 0, 0);
    gh_new_procedure("get-current-transform-gui", (SCM (*) ()) _wrap_get_current_transform_gui, 0, 0, 0);
    gh_new_procedure("set-current-transform-gui", (SCM (*) ()) _wrap_set_current_transform_gui, 1, 0, 0);
    gh_new_procedure("get-current-heuristic-gui", (SCM (*) ()) _wrap_get_current_heuristic_gui, 0, 0, 0);
    gh_new_procedure("set-current-heuristic-gui", (SCM (*) ()) _wrap_set_current_heuristic_gui, 1, 0, 0);
    gh_new_procedure("get-current-fitness-gui", (SCM (*) ()) _wrap_get_current_fitness_gui, 0, 0, 0);
    gh_new_procedure("set-current-fitness-gui", (SCM (*) ()) _wrap_set_current_fitness_gui, 1, 0, 0);
    gh_new_procedure("get-main-window", (SCM (*) ()) _wrap_get_main_window, 0, 0, 0);
    gh_new_procedure("set-main-window", (SCM (*) ()) _wrap_set_main_window, 1, 0, 0);
    gh_new_procedure("get-componant-choice-install-here", (SCM (*) ()) _wrap_get_componant_choice_install_here, 0, 0, 0);
    gh_new_procedure("set-componant-choice-install-here", (SCM (*) ()) _wrap_set_componant_choice_install_here, 1, 0, 0);
    gh_new_procedure("get-componant-choice-clist-selected-componant", (SCM (*) ()) _wrap_get_componant_choice_clist_selected_componant, 0, 0, 0);
    gh_new_procedure("set-componant-choice-clist-selected-componant", (SCM (*) ()) _wrap_set_componant_choice_clist_selected_componant, 1, 0, 0);
    gh_new_procedure("lock-callbacks", (SCM (*) ()) _wrap_lock_callbacks, 0, 0, 0);
    gh_new_procedure("unlock-callbacks", (SCM (*) ()) _wrap_unlock_callbacks, 0, 0, 0);
    gh_new_procedure("islocked", (SCM (*) ()) _wrap_islocked, 0, 0, 0);
    gh_new_procedure("parameter-enum-value-name", (SCM (*) ()) _wrap_parameter_enum_value_name, 2, 0, 0);
    gh_new_procedure("parameter-type-lookup", (SCM (*) ()) _wrap_parameter_type_lookup, 1, 0, 0);
    gh_new_procedure("file-load-text", (SCM (*) ()) _wrap_file_load_text, 1, 0, 0);
    gh_new_procedure("file-save-text", (SCM (*) ()) _wrap_file_save_text, 2, 0, 0);
    gh_new_procedure("enter-gui", (SCM (*) ()) _wrap_enter_gui, 0, 0, 0);
    gh_new_procedure("start-gui", (SCM (*) ()) _wrap_start_gui, 0, 0, 0);
    gh_new_procedure("flush-gui", (SCM (*) ()) _wrap_flush_gui, 0, 0, 0);
    gh_new_procedure("post-cleanup-gui", (SCM (*) ()) _wrap_post_cleanup_gui, 0, 0, 0);
    gh_new_procedure("int2void", (SCM (*) ()) _wrap_int2void, 1, 0, 0);
    gh_new_procedure("double2void", (SCM (*) ()) _wrap_double2void, 1, 0, 0);
    gh_new_procedure("string2void", (SCM (*) ()) _wrap_string2void, 1, 0, 0);
    gh_new_procedure("void2int", (SCM (*) ()) _wrap_void2int, 1, 0, 0);
    gh_new_procedure("void2double", (SCM (*) ()) _wrap_void2double, 1, 0, 0);
    gh_new_procedure("void2string", (SCM (*) ()) _wrap_void2string, 1, 0, 0);
    gh_new_procedure("lookup-componant-by-name", (SCM (*) ()) _wrap_lookup_componant_by_name, 2, 0, 0);
    gh_new_procedure("parameter-get-default-int-or-enum", (SCM (*) ()) _wrap_parameter_get_default_int_or_enum, 1, 0, 0);
    gh_new_procedure("parameter-get-default-double", (SCM (*) ()) _wrap_parameter_get_default_double, 1, 0, 0);
    gh_new_procedure("parameter-get-default-string", (SCM (*) ()) _wrap_parameter_get_default_string, 1, 0, 0);
    gh_new_procedure("set-returned-instance", (SCM (*) ()) _wrap_set_returned_instance, 1, 0, 0);
    gh_new_procedure("get-returned-instance", (SCM (*) ()) _wrap_get_returned_instance, 0, 0, 0);
    gh_new_procedure("generate-patch", (SCM (*) ()) _wrap_generate_patch, 8, 0, 0);
    gh_new_procedure("parameter-description-type-set", (SCM (*) ()) _wrap_parameter_description_type_set, 2, 0, 0);
    gh_new_procedure("parameter-description-type-get", (SCM (*) ()) _wrap_parameter_description_type_get, 1, 0, 0);
    gh_new_procedure("parameter-description-name-set", (SCM (*) ()) _wrap_parameter_description_name_set, 2, 0, 0);
    gh_new_procedure("parameter-description-name-get", (SCM (*) ()) _wrap_parameter_description_name_get, 1, 0, 0);
    gh_new_procedure("parameter-description-data-one-set", (SCM (*) ()) _wrap_parameter_description_data_one_set, 2, 0, 0);
    gh_new_procedure("parameter-description-data-one-get", (SCM (*) ()) _wrap_parameter_description_data_one_get, 1, 0, 0);
    gh_new_procedure("parameter-description-data-two-set", (SCM (*) ()) _wrap_parameter_description_data_two_set, 2, 0, 0);
    gh_new_procedure("parameter-description-data-two-get", (SCM (*) ()) _wrap_parameter_description_data_two_get, 1, 0, 0);
    gh_new_procedure("parameter-description-default-value-set", (SCM (*) ()) _wrap_parameter_description_default_value_set, 2, 0, 0);
    gh_new_procedure("parameter-description-default-value-get", (SCM (*) ()) _wrap_parameter_description_default_value_get, 1, 0, 0);
    gh_new_procedure("parameter-description-description-set", (SCM (*) ()) _wrap_parameter_description_description_set, 2, 0, 0);
    gh_new_procedure("parameter-description-description-get", (SCM (*) ()) _wrap_parameter_description_description_get, 1, 0, 0);
    gh_new_procedure("instance-componant-class-set", (SCM (*) ()) _wrap_instance_componant_class_set, 2, 0, 0);
    gh_new_procedure("instance-componant-class-get", (SCM (*) ()) _wrap_instance_componant_class_get, 1, 0, 0);
    gh_new_procedure("instance-parameters-set", (SCM (*) ()) _wrap_instance_parameters_set, 2, 0, 0);
    gh_new_procedure("instance-parameters-get", (SCM (*) ()) _wrap_instance_parameters_get, 1, 0, 0);
    gh_new_procedure("instance-data-set", (SCM (*) ()) _wrap_instance_data_set, 2, 0, 0);
    gh_new_procedure("instance-data-get", (SCM (*) ()) _wrap_instance_data_get, 1, 0, 0);
    gh_new_procedure("componant-filename-set", (SCM (*) ()) _wrap_componant_filename_set, 2, 0, 0);
    gh_new_procedure("componant-filename-get", (SCM (*) ()) _wrap_componant_filename_get, 1, 0, 0);
    gh_new_procedure("componant-name-set", (SCM (*) ()) _wrap_componant_name_set, 2, 0, 0);
    gh_new_procedure("componant-name-get", (SCM (*) ()) _wrap_componant_name_get, 1, 0, 0);
    gh_new_procedure("componant-type-set", (SCM (*) ()) _wrap_componant_type_set, 2, 0, 0);
    gh_new_procedure("componant-type-get", (SCM (*) ()) _wrap_componant_type_get, 1, 0, 0);
    gh_new_procedure("componant-description-set", (SCM (*) ()) _wrap_componant_description_set, 2, 0, 0);
    gh_new_procedure("componant-description-get", (SCM (*) ()) _wrap_componant_description_get, 1, 0, 0);
    gh_new_procedure("componant-number-of-parameters-set", (SCM (*) ()) _wrap_componant_number_of_parameters_set, 2, 0, 0);
    gh_new_procedure("componant-number-of-parameters-get", (SCM (*) ()) _wrap_componant_number_of_parameters_get, 1, 0, 0);
    gh_new_procedure("componant-parameter-description-table-set", (SCM (*) ()) _wrap_componant_parameter_description_table_set, 2, 0, 0);
    gh_new_procedure("componant-parameter-description-table-get", (SCM (*) ()) _wrap_componant_parameter_description_table_get, 1, 0, 0);
    gh_new_procedure("componant-next-set", (SCM (*) ()) _wrap_componant_next_set, 2, 0, 0);
    gh_new_procedure("componant-next-get", (SCM (*) ()) _wrap_componant_next_get, 1, 0, 0);
    SWIG_Guile_RegisterTypes(swig_types, swig_types_initial);
}


/* Linkage: simple */

