/*
 * SourceSafe/CVS conversion server
 * cserver.h
 * Header for the central part of server
 *
 * Here are the global variables for the server, along with constant and 
 * function	definitions
 *
 * (c) Benjamin Loo - 2001
 * 
 * You may distribute under the terms of the GNU General Public License as
 * specified in the README file that comes with the VSSExtractor/Cserver
 * source distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 
 *
 * Visual SourceSafe is a registered trademark from Microsoft Corporation.
 * 
 */


#ifndef __CSERVER_server
#define __CSERVER_server

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <string.h>
#include <errno.h>
#include <dlfcn.h>
#include <signal.h>

#include "file.h"

#define BUFSIZE 4096
#define RECVBUFSIZE 1024

/* List of commands recognized by the server */
#define CMD_BEGIN	0
#define CMD_BYE		1
#define CMD_PING	2
#define CMD_CONFIG	3
#define CMD_PUT		4
#define CMD_DIR		5
#define CMD_FLABEL	6
#define CMD_PLABEL	7
#define CMD_DELETE	8
#define CMD_RECOVER	9
#define CMD_MOVE	10
#define CMD_USERS	11

#define CMD_INVALID	255

/* utility linked-list structure */
struct LList {
	char * entry;
	struct LList * next;
};


/* global variables for the server */

/* socket parameters (command socket and data socket) */
int serversocket;
int sock;
int port;

int dataserversocket;
int datasock;
int dataport;

/* parameters for the conversion process */

char * cvs_path;
char * current_dir;
char * temp_dir;
char * logfilename;

char * lastline;

/* List of users */
struct LList * userlist;
char * usermode;
char * defaultuser;

/* List of files in the current repository */
struct FileList * repository_files;

/* server parameters */
int writemode;
int allowbinaries;

/* config file functions */
int parseConfigline(char * line, char ** var, char ** content);
void readConfig(char * file);

/* server functions */
void server_init();
void server_run();

char * getLine();
int getCommand();
void getFile();
int getFilecontent(struct FileHeader h);
int getHeader(struct FileHeader * h);
void initTempfile(struct FileHeader * h);
void getConfig();
void getDir();
void getFLabel();
void getPLabel();
void getDelete();
void getRecover();
void getMove();
void getUsers();
void reply(char * msg);

#endif


