/*
 * SourceSafe/CVS conversion server
 * file.h
 * Header for file-related operations and tools
 *
 * (c) Benjamin Loo - 2001
 *
 * 
 * You may distribute under the terms of the GNU General Public License as
 * specified in the README file that comes with the VSSExtractor/Cserver
 * source distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 
 *
 * Visual SourceSafe is a registered trademark from Microsoft Corporation.
 * 
 */


#ifndef __CSERVER_file
#define __CSERVER_file

#include "time.h"

/* File header structure definition */
struct FileHeader {
	char * tempfile;
	char * project;
	char * filename;
	char * RCSversion;
	char * author;
	char * timestamp;
	char * comment;
	char * label;
	int type;
	long filesize;
};

/* File linked-list structure definition */
struct FileList {
	char * filename;
	char * RCSversion;
	char * RCSfile;
	time_t lasttime;
	int type;
	struct FileList * next;
};



/* file-related function declarations */

void getHeaderElement(char * line, struct FileHeader * h);
void clearHeader(struct FileHeader * h);
void printHeader(struct FileHeader h);
void deleteHeader(struct FileHeader * h);

struct FileList * findinList(char * filename, struct FileList * f);
struct FileList * newList(char * filename, int type);
void deleteList(struct FileList * f);
void printList(struct FileList * l);

char * updateVersion(char * timestamp);
char * makeRCSfile(char * filename);
time_t makeTime(char * timestamp);
time_t makeGMTime(char * timestamp);

struct FileList * checkupdateList(char * filename, char * timestamp);
struct FileList * checkaddList(char * filename, char * timestamp, int type);

char * trimFilename(char * filename);
void setFiletime(char * filename, char * timestamp);

void setRCSEntry(struct FileList * f, struct FileHeader h);

void parseDir(char * dir);

void cleanTempdir();

#endif

