/*
 * VSS/CVS conversion server
 * servlog.c
 *
 * Functions for writing to a log file
 *
 * (c) Benjamin Loo - 2001
 *
 * You may distribute under the terms of the GNU General Public License as
 * specified in the README file that comes with the VSSExtractor/Cserver
 * source distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 
 *
 * Visual SourceSafe is a registered trademark from Microsoft Corporation.
 * 
 */

#include"servlog.h"
#include<time.h>
#include "string.h"

/*
 * initializes logging facility
 */
void startLogging(char * filename) {
	tzset();

	logfilename = (char *) malloc(sizeof(char) * (strlen(filename) + 1));
	strcpy(logfilename, filename);
	logfilehandle = fopen(logfilename, "a+");

	if (logfilehandle == NULL) fprintf(stderr, "WARNING : can't open log file!\n");
		
}

/* 
 * puts a message line at the end of the log file
 * the log line looks like
 * DD/MM/YY|HH:MM:SS|Event type   |Message
 */
void logMessage(char * event, char * message) {
	struct tm * timeval;
	time_t timenow;
	char datebuffer[20];
	char eventbuffer[17];
	
	if (logfilehandle == NULL) return;
	
	timenow = time(NULL);
	timeval = localtime(&timenow);
	strftime(datebuffer, 20, "%D|%T", timeval);

	if (strlen(event)>16) {
		strncpy(eventbuffer, event, 16);
		eventbuffer[16] = 0;
	}
	else {
		strcpy(eventbuffer, "                ");
		strncpy(eventbuffer, event, strlen(event));
	}

	fprintf(logfilehandle, "%s|%s|%s\n", datebuffer, eventbuffer, message);
	fflush(logfilehandle);

}

/*
 * closes log file
 */
void endLogging() {
	fclose(logfilehandle);
	free(logfilename);
}


