/*
 * Sourcesafe/CVS conversion server
 * users.c
 *
 * user management functions
 *
 * (c) Benjamin Loo - 2001
 *
 * 
 * You may distribute under the terms of the GNU General Public License as
 * specified in the README file that comes with the VSSExtractor/Cserver
 * source distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 
 *
 * Visual SourceSafe is a registered trademark from Microsoft Corporation.
 * 
 */


#include "users.h"
#include "cserver.h"
#include "servlog.h"

#include<stdio.h>
#include<string.h>


/*
 * generates a filename for CVS user/password file
 *
 * returns a new string containing the filename
 */
char * makeUserfilename() {
	char * name;
	int len = strlen(cvs_path) + 18;

	name = (char *) malloc(sizeof(char) * len);
	strcpy(name, cvs_path);
	strcat(name, "/CVSROOT/passwd");

	return name;
}


/*
 * parses a line from CVS user/passwd file
 *
 * returns a pointer to a freshly allocated UserEntry element
 */
struct UserEntry * parseUserline(char * line) {
	int len = strlen(line);
	int i;
	int start;
	struct UserEntry * entry = (struct UserEntry *) malloc(sizeof(struct UserEntry));

	entry->shadow = NULL;
	entry->unixname = NULL;
	entry->next = NULL;
	for(i = 0; i<len && line[i] != ':'; i++);
	if (i==len) {
		free(entry);
		return NULL;
	}

	entry->name = (char *) malloc(sizeof(char) * (i+1));
	strncpy(entry->name, line, i);
	entry->name[i] = 0;

	start = i+1;
	if (line[start] != ':') {
		for (i=0; (start+i)<len && line[start+i] != ':'; i++);
		entry->shadow = (char *) malloc(sizeof(char) * (i+1));
		strncpy(entry->shadow, &line[start], i);
		entry->shadow[i] = 0;
	}
	else {
		entry->shadow = NULL;
		i=0;
	}

	if (start+i<len) {
		start = start+i+1;
		i = len - start;
		entry->unixname = (char *) malloc(sizeof(char) * (i+1));
		strncpy(entry->unixname, &line[start], i);
		entry->unixname[i] = 0;
	}

	return entry;
}
	

/*
 * reads CVS user/passwd file and builds a userlist
 *
 * returns a pointer to the head of the list
 */
struct UserEntry * readUserfile() {
	FILE * f;	
	char * filename;
	char buffer[256];
	struct UserEntry * list;
	struct UserEntry * entry;
	int blen;
	
	filename = makeUserfilename();
	if ((f = fopen(filename, "r")) == NULL) {
		fprintf(stderr, "$CVSROOT/passwd file does not exist\n");
		return NULL;
	}

	list = NULL;
	while (! feof(f)) {
		fgets(buffer, 256, f);
		blen = strlen(buffer);
		if (buffer[blen-1] == '\n') buffer[blen-1] = ' ';
		if ((entry = parseUserline(buffer)) != NULL) {
			entry->next = list;
			list = entry;
		}
	}

	fclose(f);

	return list;
}


/*
 * checks whether a user is already registered in CVS user list
 *
 * returns 0 if user was found, -1 if it was not
 */
int inUserlist(char * user, struct UserEntry * e) {
	struct UserEntry * l;

	for (l = e; l != NULL && strcmp(user, l->name) != 0; l = l->next);
	if (l == NULL) return -1; else return 0;
	return 0;
}

/*
 * gets a linked list of user names and register them into CVS user file
 * uses the default password "dummy" (shadowed) for all users
 */
void addUsers(struct LList * userlist) {
	FILE * f;
	char * filename;
	struct LList * l;
	
	struct UserEntry * list = readUserfile();
	struct UserEntry * dummy;

	filename = makeUserfilename();

	if ((f = fopen(filename, "a+")) == NULL) {
		fprintf(stderr, "Can't open user/passwd file for writing\n");
		return;
	}

	for (l = userlist; l != NULL; l = l->next) {
		if (inUserlist(l->entry, list) != 0) {
			fprintf(f, "%s:4b5WGIJ0URNDE:%s\n", l->entry, defaultuser);
		}
	}

	fclose(f);
	
	while (list != NULL) {
		dummy = list->next;
		list->next = NULL;
		free(list);
		list = dummy;
	}

}

/*
 * Checks if the user names in a linked list actually exist in CVS user list
 * issues a warning if user is not found
 */	
void checkUsers(struct LList * userlist) {
	struct LList * l;
	struct UserEntry * list = readUserfile();
	struct UserEntry * dummy;
	char logbuffer[256];

	for (l = userlist; l != NULL; l = l->next) {
		if (inUserlist(l->entry, list) != 0) {
			fprintf(stderr, "WARNING : user %s does not exist in CVS\n", l->entry);
			snprintf(logbuffer, 256, "User %s does not exist in CVS", l->entry);
			logMessage("User Warning", logbuffer);
		}
	}

	while (list != NULL) {
		dummy = list->next;
		list->next = NULL;
		free(list);
		list = dummy;
	}

}

		
		
		


