.\" 
.\" "$Id: cups-lpd.man,v 1.1 2004/10/20 18:00:54 mike Exp $"
.\" 
.\" cups-lpd man page for the Common UNIX Printing System (CUPS).
.\" 
.\" Copyright 1997-2004 by Easy Software Products.
.\" 
.\" These coded instructions, statements, and computer programs are the
.\" property of Easy Software Products and are protected by Federal
.\" copyright law.  Distribution and use rights are outlined in the file
.\" "LICENSE.txt" which should have been included with this file.  If this
.\" file is missing or damaged please contact Easy Software Products
.\" at:
.\" 
.\" Attn: CUPS Licensing Information
.\" Easy Software Products
.\" 44141 Airport View Drive, Suite 204
.\" Hollywood, Maryland 20636-3142 USA
.\" 
.\" Voice: (301) 373-9600
.\" EMail: cups-info@cups.org
.\" WWW: http://www.cups.org
.\" 
.TH "cups-lpd" "8" "Common UNIX Printing System" "11 de Agosto de 2004" "Easy Software Products"
.SH "NOMBRE"
cups\-lpd \- recibe los trabajos de impresin e informa del estado de la impresora a los clientes lpd
.SH "SINOPSIS"
.B cups\-lpd
[ \-o
.I opcin=valor
]
.SH "DESCRIPCIN"
\fBcups\-lpd\fR es el mini\-servidor Line Printer Daemon ("LPD") que soporta los clientes que usan el protocolo LPD.
\fBcups\-lpd\fR no acta como un demonio de red solitario sino que funciona usando el "super\-servidor" de Internet \fBinetd(8)\fR. Aada la siguiente lnea al archivo  \fBinetd.conf\fR para activar el demonio \fBcups\-lpd\fR:
.br 
.nf 

    printer stream tcp nowait lp /camino/a/demonio/cups/cups\-lpd cups\-lpd \-o document\-format=application/octet\-stream
.fi 
.LP 
Si est usando el nuevo demonio \fIxinetd(8)\fR, aada las siguientes lneas al archivo \fBxinetd.conf\fR:
.br 
.nf 

    service printer
    {
        socket_type = stream
        protocol = tcp
        wait = no
        user = lp
	group = sys
	passenv =
        server = /camino/a/demonio/cups/cups\-lpd
	server_args = \-o document\-format=application/octet\-stream
    }
.fi 
.LP 
El /camino/a/demonio/cups es normalmente /usr/lib/cups/daemon o
/usr/libexec/cups/daemon, dependiendo del sistema operativo.
Consulte el archivo cupsd.conf para lo establecido localmente.
.SH "OPCIONES"
La opcin \fI\-o\fR de \fBcups\-lpd\fR aade opciones para todas las colas de impresin.
La mayora de las veces se usa para deshabilitar el filtro "l" para que los trabajos de impresin remotos sean filtrados correctamente:
.br 
.nf 

    printer stream tcp nowait lp /usr/lib/cups/daemon/cups\-lpd cups\-lpd \
        \-o document\-format=application/octet\-stream

    server = /usr/lib/cups/daemon/cups\-lpd
    server_args = \-o document\-format=application/octet\-stream
.fi 
.LP 
En el ejemplo se muestra como el formato del documento es reinicializado a 
\fIapplication/octet\-stream\fR, lo que fuerza la auto deteccin del tipo de archivo a imprimir.
.SH "RENDIMIENTO"
\fBcups\-lpd\fR funciona bien con un nmero pequeo de clientes e impresoras. Sin embargo, ya que se crea un nuevo proceso con cada conexin y que cada proceso debe hacer peticiones al sistema de impresin antes de cada envo de un trabajo, no funciona bien con configuraciones grandes. Recomendamos que las configuraciones grandes usen el soporte nativo IPP que proporciona CUPS.
.SH "SEGURIDAD"
\fBcups\-lpd\fR actualmente no realiza ningn control de acceso basado en lo establecido en los archivos \fIcupsd.conf(5)\fR o en \fIhosts.allow(5)\fR o en  \fIhosts.deny\fR usados por los envoltorios TCP. Por lo tanto, la ejecucin de \fBcups\-lpd\fR en su servidor permitir imprimir a cualquier ordenador de su red (y quizs de todo Internet).
.LP 
Aunque \fIxinetd\fR incorpora soporte de control de acceso, debera usar el paquete de envoltorios TCP junto a \fIinetd\fR para permitir el acceso slamente a aquellos ordenadores que tengan permiso para imprimir en su servidor.
.LP 
\fBcups\-lpd\fR no est activado en la distribucin estandar de CUPS.
Por favor consulte al vendedor de su sistema operativo para saber si est activado en su distribucin.
.SH "COMPATIBILIDAD"
\fBcups\-lpd\fR no cumple el uso restringido de nmeros de puerto especificado en  RFC 1179, ya que ste uso restringido no impide a los usuarios que enven trabajos de impresin. Aunque este comportamiento es diferente de la implementacin estandar de LPD Berkeley, sto no debera afectar a las operaciones normales de los clientes.
.LP 
La salida de las peticiones de estado cumplen RFC 2569, mapeando entre los protocolos LPD e IPP. Ya que muchas implementaciones de LPD se alejan de esta definicin, la informacin del estado remoto a clientes LPD puede ser poco fiable.
.SH "VASE TAMBIN"
cupsd(8), inetd(8), xinetd(8),
Manual de administrador de CUPS,
http://localhost:631/documentation.html
.SH "DERECHOS DE COPIA"
Los derechos de copia 1993\-2004 son de Easy Software Products. Todos los derechos reservados.
.SH "TRADUCCIN"
Juan Pablo Gonzlez Riopedre <riopedre@tiscali.es>
.\"
.\" End of "$Id: cups-lpd.man,v 1.1 2004/10/20 18:00:54 mike Exp $".
.\"

