.\"
.\" "$Id: lpoptions.man,v 1.13 2004/08/11 13:48:15 mike Exp $"
.\"
.\"   lpoptions man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 1997-2004 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Easy Software Products and are protected by Federal
.\"   copyright law.  Distribution and use rights are outlined in the file
.\"   "LICENSE.txt" which should have been included with this file.  If this
.\"   file is missing or damaged please contact Easy Software Products
.\"   at:
.\"
.\"       Attn: CUPS Licensing Information
.\"       Easy Software Products
.\"       44141 Airport View Drive, Suite 204
.\"       Hollywood, Maryland 20636-3142 USA
.\"
.\"       Voice: (301) 373-9600
.\"       EMail: cups-info@cups.org
.\"         WWW: http://www.cups.org
.\"
.TH lpoptions 1 "Common UNIX Printing System" "21 October 2002" "Easy Software Products"
.SH NAME
lpoptions \- display or set printer options and defaults
.SH SYNOPSIS
.B lpoptions
[ -h
.I server
] -d
.I dest[/instance]
[ -o
.I option=value
] ... [ -o
.I option=value
]
.br
.B lpoptions
[ -h
.I server
] [ -E ] [ -p
.I dest[/instance]
] -l
.br
.B lpoptions
[ -h
.I server
] [ -E ] [ -o
.I option=value
] ... [ -o
.I option=value
] [ -p
.I dest[/instance]
] -r
.I option
.br
.B lpoptions
[ -h
.I server
] [ -E ] -x
.I dest[/instance]
.SH DESCRIPTION
\fBlpoptions\fR displays or sets printer options and defaults.
\fBlpoptions\fR shows the default printer options when run with no
arguments. Other options include:
.TP 5
\-E
.br
Enables encryption when communicating with the CUPS server.
.TP 5
\-d \fIdest[/instance]\fR
.br
Sets the default printer to \fIdest\fR. If \fIinstance\fR is supplied then
that particular instance is used. This option overrides the system default
printer for the current user.
.TP 5
\-h \fIserver\fR
.br
Specifies the CUPS server to communicate with.
.TP 5
\-l
.br
Lists the printer specific options and their current settings.
.TP 5
\-o \fIoption=value\fR
.br
Specifies a new option for the named destination.
.TP 5
\-p \fIdest[/instance]\fR
.br
Sets the destination and instance, if specified, for any options that follow.
If the named instance does not exist then it is created.
.TP 5
\-r \fIoption\fR
.br
Removes the specified option for the named destination.
.TP 5
\-x \fIdest[/instance]\fR
.br
Removes the options for the named destination and instance, if specified.
If the named instance does not exist then this does nothing.
.LP
If no options are specified using the \fI-o\fR option then the current
options for the named printer are reported on the standard output.
.LP
Options set with the \fBlpoptions\fR command are used by the \fBlp(1)\fR
and \fBlpr(1)\fR commands when submitting jobs.
.SH ROOT ACCOUNT OPTIONS
When run by the root user, \fBlpoptions\fR gets and sets default
options and instances for \fIall users\fR in the
/etc/cups/lpoptions file.
.SH COMPATIBILITY
The \fBlpoptions\fR command is unique to CUPS.
.SH FILES
~/.lpoptions - user defaults and instances created by non-root users.
.br
/etc/cups/lpoptions - system-wide defaults and instances created by the root
user.
.SH SEE ALSO
cancel(1), lp(1),
CUPS Software Users Manual,
http://localhost:631/documentation.html
.SH COPYRIGHT
Copyright 1993-2004 by Easy Software Products, All Rights Reserved.
.\"
.\" End of "$Id: lpoptions.man,v 1.13 2004/08/11 13:48:15 mike Exp $".
.\"
