#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <glib.h>
#include <gdk/gdk.h>

#include "dctc_com.h"
#include "userinfo.h"
#include "lmp.h"

/**********************************************************/
/* allocate a new DCTC_COM structure for the given socket */
/**********************************************************/
/* running_base_path = "$HOME/.dctc/dctc-xxxxxxxx-ip" */
/******************************************************/
DCTC_COM *create_new_dctc_com(int sock_fd, const char *running_base_path)
{
	DCTC_COM *cm;

	cm=malloc(sizeof(DCTC_COM));
	if(cm==NULL)
		return NULL;

	cm->dctc_fd=sock_fd;
	cm->tag_read=-1;
	cm->tag_write=-1;
	cm->write_q=g_ptr_array_new();
	cm->incoming_data=g_string_new("");

	{	/* create userinfo LMP filename "base_path" + ".userinfo" */
		gchar *userinfo_lmp_path=g_strconcat(running_base_path,".userinfo",NULL);
		cm->user_info_lmp=lmp_new(userinfo_lmp_path,sizeof(LMP_UINFO));
		g_free(userinfo_lmp_path);
	}
	return cm;
}

/***************************************************/
/* close socket and free memory used by a DCTC_COM */
/***************************************************/
void close_and_free_dctc_com(DCTC_COM *cm)
{
	if(cm==NULL)
		return;

	shutdown(cm->dctc_fd,2);
	close(cm->dctc_fd);
	if(cm->tag_read!=-1)
	{
		gdk_input_remove(cm->tag_read);
		cm->tag_read=-1;
	}
	if(cm->tag_write!=-1)
	{
		gdk_input_remove(cm->tag_write);
		cm->tag_write=-1;
	}

	if(cm->write_q)
	{
		int i;
		for(i=0;i<cm->write_q->len;i++)
		{
			char *str;

			str=g_ptr_array_index(cm->write_q,i);
			if(str)
				free(str);
		}
		g_ptr_array_free(cm->write_q,TRUE);
		cm->write_q=NULL;
	}

	if(cm->incoming_data)
	{
		g_string_free(cm->incoming_data,TRUE);
		cm->incoming_data=NULL;
	}

	if(cm->user_info_lmp)
	{
		lmp_close(cm->user_info_lmp);
		cm->user_info_lmp=NULL;
	}

	free(cm);
}

