#ifndef __FIND_RESULT_CLIST_H__
#define __FIND_RESULT_CLIST_H__

typedef struct
{
	char *nickname;
	char *filename;
	unsigned long file_size;
	int free_slot;
	int ttl_slot;
	char *hubname;
	char *connection_speed;
} FIND_CL_ENTRY;

/*******************************************************/
/* free memory used by a FIND_CL_ENTRY and its content */
/*******************************************************/
void free_find_cl_entry(FIND_CL_ENTRY *gce);

FIND_CL_ENTRY *new_cl_entry(char *nickname, char *filename, unsigned long file_size, int free_slot, int ttl_slot, char *hubname, char *connection_speed);

/****************************************************************************************/
/* this function calls the given fnc for each selected entry of the "find_result" clist */
/****************************************************************************************/
void generic_selected_find_result_calls(void (*fnc)(FIND_CL_ENTRY *, void *), void *data);

#endif
