#ifndef __MAIN_H__
#define __MAIN_H__

#include "lmp.h"
/*****************************/
/* widget of the main window */
/*****************************/
extern GtkWidget *main_window;

/* popup menu */
extern GtkWidget *dl_popup;
extern GtkWidget *ul_popup;
extern GtkWidget *q_popup;
extern GtkWidget *user_popup;
extern GtkWidget *start_dl_popup;
extern GtkWidget *gdl_popup;
extern GtkWidget *uaddr_popup;
extern GtkWidget *done_popup;
extern GtkWidget *fav_popup;

/* some useful colors */
extern GdkColor light_red, white, black, light_grey, green, light_orange;
extern GdkColor greyEE,greyDD;

/* this string is "$HOME/.dctc" */
extern GString *dctc_main_dir;
/**************************************************************/
/* this string contains the path to directory ~/.dctc/running */
/**************************************************************/
extern GString *dctc_dir;
extern GString *dctc_active_client_file;

extern int local_udp_socket;                  /* this socket is used to send data to DCTC UDP communication socket, it is not bind to anything */

/***************************/
/* periodic internal tasks */
/***************************/
extern guint32 running_client_list_refresh_rate;  /* delay between 2 refresh of the running client list (in 1/1000ths of seconds) */
extern guint running_client_list_refresh_rate_gta;   /* handle returned by gtk_timeout_add for this refresh (only meaningful if the previous var !=0) */

extern guint32 favorite_client_autostart_check_rate; /* delay between 2 checks of the favorite client autostart (in 1/1000ths of seconds) */
extern guint favorite_client_autostart_check_rate_gta;  /* handle returned by gtk_timeout_add for this refresh (only meaningful if the previous var !=0) */

extern int (*nickname_sort_function)(const char*, const char *); /* sensitivity of nickname sorting:  button default value is OFF, we use strcmp */

extern int auto_start_disabled;      /* if TRUE, don't start new client for hub having the autostart flag set and without client */

/********************************************/
/* set the periodic call rate of a function */
/*************************************************************/
/* if new_rate=0, a current running periodic call is removed */
/*************************************************************/
void set_periodic_function_call_rate(guint32 *rate, guint *handle, GtkFunction function_to_call, gpointer xtra_data_to_send_to_function, guint32 new_rate);


#include "dctc_com.h"

extern DCTC_COM *current_dctc;

extern GString *last_search[2];     /* the last search is kept because if multi-hub search is enabled */
                                    /* the command(s) must be resent */
extern gint last_search_tag;        /* when a search may start a multi-hub search, this value is the tag return by gtk_timeout_add */

extern gchar **last_started_search; /* it is an array of gchar * produced by splitting the last entered search pattern */

extern LMP_ENTRY *unode_lmp;
G_LOCK_EXTERN(unode_lmp);

/*********************************/
/* add a label to the blink list */
/*********************************/
void blink_on(char *label_name);

/**************************************/
/* remove a label from the blink list */
/**************************************/
void blink_off(char *label_name);

/************************************************************************/
/* check if the given pattern exists inside filename (case insensitive) */
/************************************************************************/
/* output: address of the pattern or NULL */
/******************************************/
char *my_strcasestr(GString *pattern, char *filename);

#endif
