#ifndef __MINI_DB_H__
#define __MINI_DB_H__

/************************************************************/
/* the following function provides a mini database function */
/************************************************************/

/***********************************/
/* CREATE, LOAD and SAVE functions */
/***********************************/

/**********************************************************************/
/* create a new "database" having the given number of entries per row */
/**********************************************************************/
struct minidb *db_new(const char *db_name, int nb_fields);

/*****************************************************/
/* load the given "database" (gnome key) into memory */
/*****************************************************/
struct minidb *db_load_db(const char *db_name);

/****************************************************************************/
/* save the given allocated minidb (the minidb structure remains available) */
/****************************************************************************/
void db_save_db(struct minidb *mdb);

/***********************************/
/* free the given allocated minidb */
/***********************************/
void free_loaded_db(struct minidb *mdb);

/***********************************/
/* ADDING, REMOVING, UPDATING rows */
/***********************************/

/* add a new row to the database (without taking duplicate row into account) */
void db_add_row(struct minidb *mdb, const char *col[]);		/* col is an array of "nb_fields" string */

/* add a new row to the database (taking duplicate row into account) */
/* if with_overwrite is not set and a row with the same key exist, the row is not added */
/* if with_overwrite is set and a row with the same key exist, the row is updated */
void db_add_row_uniq(struct minidb *mdb, int with_overwrite,int which_uniq_column, const char *col[]);		/* col is an array of "nb_fields" string */

/* delete a row of the database using its "key" */
void db_del_row(struct minidb *mdb, int which_column, const char *value);

#endif
