#ifndef __STATUS_H__
#define __STATUS_H__
/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * status.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

enum
{
	NOT_EXIST=0,
	IS_OFFLINE=1,		/* client is not connected to the hub */
	IS_ONLINE=2,		/* client is connected to the hub */
};

#define NB_LONG_PER_ENTRY 32

/***********************************************/
/* get client status in the global status file */
/***********************************************/
/* output: one of the above value */
/*****************************************************/
/* if result is not NOT_EXIST and array is not NULL, */
/* array is filled with the client parameter         */
/* array is an unsigned long [NB_LONG_PER_ENTRY]     */
/*****************************************************/
int get_client_status(pid_t pid, unsigned long *array);

void del_client_status(pid_t pid);


typedef enum
{
	GSTATUS_PID=0,					/* unsigned long */
	GSTATUS_CNX_STATUS=1,		/* unsigned long */
	GSTATUS_NB_GDL=2,				/* unsigned long */
	GSTATUS_NB_USERS=3,			/* unsigned long */
	GSTATUS_FLAG1=4,              /* unsigned long */
	GSTATUS_NB_UL=5,				/* unsigned long */
} GSTATUS_POSITION_ENUM;

typedef union
{
   unsigned long int full;
   struct
   {
      unsigned int is_clock_master:1;  /* if ==1, this client is the clock master */
      unsigned int unused:31;    /* unused bits */
   } bf;
} FLAG1_STRUCT;

#endif
