#ifndef __USER_FILE_LIST_CLIST_H__
#define __USER_FILE_LIST_CLIST_H__

typedef enum
{
	UFL_NICK_ROOT_ENTRY=0,		/* it is the root of the user file list */
	UFL_DIR_ENTRY,					/* it is a directory */
	UFL_FILE_ENTRY,				/* it is a file */
} USER_FILE_ENTRY_TYPE;

typedef struct
{
	USER_FILE_ENTRY_TYPE entry_type;
	union
	{
		char *nickname;		/* for UFL_NICK_ROOT_ENTRY */
		char *dir_name;		/* for UFL_DIR_ENTRY */
		struct
		{
			char *filename;
			unsigned long file_size;
		} file;
	} c;
} USER_FILE_CL_ENTRY;

/************************************************************/
/* free memory used by a USER_FILE_CL_ENTRY and its content */
/************************************************************/
void free_user_file_cl_entry(USER_FILE_CL_ENTRY *ufce);

USER_FILE_CL_ENTRY *new_user_file_cl_entry_as_nick_root(const char *nickname);
USER_FILE_CL_ENTRY *new_user_file_cl_entry_as_dir(const char *dir_name);
USER_FILE_CL_ENTRY *new_user_file_cl_entry_as_file(const char *filename, unsigned long file_size);

/*******************************************************************************************/
/* this function calls the given fnc for each selected entry of the "user_file_list" clist */
/*******************************************************************************************/
void generic_selected_user_file_list_calls(void (*fnc)(GtkCTree *ctree, USER_FILE_CL_ENTRY *, void *), void *data);

/******************************************************************/
/* find the UFL_NICK_ROOT_ENTRY of a given entry (DIR|FILE)_ENTRY */
/******************************************************************/
USER_FILE_CL_ENTRY *get_nick_entry_for_user_file_list_from_ufce(GtkCTree *ctree, USER_FILE_CL_ENTRY *fce);
USER_FILE_CL_ENTRY *get_nick_entry_for_user_file_list_from_ctnode(GtkCTree *ctree, GtkCTreeNode *base);

#endif
