#ifndef __BOOKMARK_H__
#define __BOOKMARK_H__

/**************************************************************/
/* colorize entry of favorite clist existing in running clist */
/**************************************************************/
void colorize_favorite(GtkCList *fav_clst, GtkCList *running_clst);

/********************************************************************/
/* this function reloads the bookmark into the 'hub_favorite_clist' */
/********************************************************************/
void reload_bookmark(void);

/******************************************/
/* add/update a new entry to the bookmark */
/*****************************************************************************/
/* if id_to_use==-1, the function uses a free id, else, the given id is used */
/*****************************************************************************/
void add_entry_to_bookmark(int id_to_use,char *name,char *description, char *address, char *profilename, char *flags, int no_reload);

/************************************/
/* delete a entry from the bookmark */
/************************************/
void delete_entry_from_bookmark_by_id(unsigned int bm_id, int no_reload);

/*********************************************/
/* toggle a flag of an entry of the bookmark */
/*********************************************/
void toggle_entry_flag_from_bookmark_by_id(int my_id, char *flag_to_toggle, int no_reload);

/***********************************************/
/* set the profile of an entry of the bookmark */
/***********************************************/
void set_entry_profile_from_bookmark_by_id(int my_id, char *profile_to_use, int no_reload);

/******************************************************************************************************/
/* Convert bookmarks from the old bookmark format (in /Bookmark/Content) into the new bookmark format */
/******************************************************************************************************/
void convert_old_bookmark_to_new_bookmark_format(void);

/*********************************************************/
/* search if the searched_flag is inside the flag_string */
/*********************************************************/
/* output: 1=yes, 0=no */
/***********************/
int flag_is_set(char *flag_string,char *searched_flag);

#endif
