#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <math.h>
#include <sys/types.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <dirent.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <linux/sem.h>
#include <gnome.h>
#include <glib.h>
#include <time.h>
#include <db.h>
#include <string.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "gui_layout.h"
#include "main.h"
#include "misc_gtk.h"
#include "init_fnc.h"
#include "do_connect.h"
#include "dctc_process.h"
#include "gui_define.h"
#include "bookmark.h"
#include "misc.h"
#include "bdb.h"
#include "unode.h"
#include "ls_cache.h"
#include "gdl_ctree.h"
#include "find_result_clist.h"
#include "user_file_list_clist.h"
#include "ls_cache_clist.h"

static void start_download_from_find_result_clist(void);
static void reload_flagged_user_clist(int only_if_empty);
static void reload_unode_clist(int only_if_empty);

void
on_connect1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),CONNECT_TAB);
}


void
on_disconnect1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	send_data_to_dctc("/FORCEQUIT\n");
}


void
on_find1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),FIND_TAB);
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gui_full_save(main_window,NULL);
	gtk_main_quit();
}


void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),USER_PREFERENCES_TAB);
	
	fix_pref_window();
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_about2();
	gtk_widget_show(w);
}


void
on_hub_favorite_clist_click_column     (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	gtk_clist_freeze(clist);

	if(clist->sort_column==column)
	{
		if(clist->sort_type==GTK_SORT_ASCENDING)
			gtk_clist_set_sort_type(clist,GTK_SORT_DESCENDING);
		else
			gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
	}
	else
	{
		gtk_clist_set_sort_column(clist,column);
		gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
	}
	gtk_clist_sort(clist);

#if 0
	/* File size high-lighting, 10/5/02, Idea and first version of code by thomas@stewarts.org.uk */
	if(column == 2)
	{ /* if we are sorting by size */
		gint total_rows;

		total_rows = clist->rows; 
		if(total_rows!=0)
		{
			gchar *text;
			int num_color=0;
			static GdkColor *color_list[]={&white,&greyDD,&greyEE};
			gint row, size, old_size;

			row=0;
			gtk_clist_get_text(clist,row,column, &text);
			old_size=size=atoi(text);
		
			for(row=0; row < total_rows; row++)
			{ /* loop every row */
				gtk_clist_get_text(clist,row,column, &text);
				size=atoi(text); /* size = current row value */
				if(old_size != size)
				{ /* size has changed, so swap */
					num_color=(num_color+1)%3;
				}
				gtk_clist_set_background(clist,row,color_list[num_color]);
				old_size = size; /* remember old value */
			}
		}
	}
	else
	{
		gint row, total_rows;
		total_rows = clist->rows;
		for(row=0; row < total_rows; row++)
			gtk_clist_set_background(clist,row,&white);
	}
#endif
	
	gtk_clist_thaw(clist);
}

/*****************************************************************************************/
/* this function is called when the user clicks on a profile entry of the fav_popup_menu */
/*****************************************************************************************/
/* prof_name is the profile name to use */
/****************************************/
static void set_fav_profile(GtkMenuItem *menuitem, gpointer prof_name)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name("hub_favorite_clist");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			gpointer data;

			data=gtk_clist_get_row_data(clst,row);

			set_entry_profile_from_bookmark_by_id(GPOINTER_TO_INT(data),prof_name,1);		/* toggle without reload */
		}
	}

	reload_bookmark();
}


/*******************************************************************/
/* rebuild a new favorite_popup menu including the current profile */
/*******************************************************************/
static void build_favorite_popup(void)
{
	GtkWidget *mitem;
	static GStringChunk *gsc_entry=NULL;
	gchar *ent;

	if(fav_popup!=NULL)
	{
		widget_unlog(fav_popup);
		gtk_widget_destroy(fav_popup);
	}

	if(gsc_entry!=NULL)
	{
		g_string_chunk_free(gsc_entry);
	}
	gsc_entry=g_string_chunk_new(64);

	/* create the default fav_popup_menu */
	fav_popup=create_fav_popup_menu();

	/* and add it the list of profiles */
	mitem=gtk_menu_item_new_with_label(_("-- use profile"));
	gtk_widget_set_sensitive(mitem,FALSE);
	gtk_menu_append(GTK_MENU(fav_popup),mitem);
	gtk_widget_show(mitem);

	/* first, an empty profile to use the current one */
	mitem=gtk_menu_item_new_with_label(_("Current one"));
	gtk_menu_append(GTK_MENU(fav_popup),mitem);
	ent=g_string_chunk_insert(gsc_entry,"");
	gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(set_fav_profile),ent);
	gtk_widget_show(mitem);

	/* and add the list of existing one */
	{
		void *iter;
		iter=gnome_config_init_iterator("/" PROGNAME "/ProfileNames/");
		while(iter!=NULL)
		{
			char *prof_name=NULL;
			char *buf=NULL;
			
			iter=gnome_config_iterator_next(iter,&prof_name,&buf);
			if(iter!=NULL)
			{
				/* prof_name is the profile name, buf is unused */
				if((prof_name!=NULL)&&(strlen(prof_name)))
				{
					mitem=gtk_menu_item_new_with_label(prof_name);
					gtk_menu_append(GTK_MENU(fav_popup),mitem);
					ent=g_string_chunk_insert(gsc_entry,prof_name);
					gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(set_fav_profile),ent);
					gtk_widget_show(mitem);
				}
			}
		}
	}
}


gboolean
on_hub_favorite_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;
				char *prof_name;

				if( (gtk_clist_get_text(GTK_CLIST(widget),row,2,&col))&&
					 (gtk_clist_get_text(GTK_CLIST(widget),row,3,&prof_name)) )
				{
					if((prof_name==NULL)||(strlen(prof_name)==0))
						start_a_new_dctc(col,0,NULL);
					else
						start_a_new_dctc(col,0,prof_name);
				}
			}
		}
		return TRUE;
	}

	if(event->button==3)
	{	/* right-click */
		build_favorite_popup();
		gtk_menu_popup(GTK_MENU(fav_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

	return FALSE;
}


void
on_hub_public_clist_click_column       (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_hub_public_clist_button_press_event (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,3,&col))
					start_a_new_dctc(col,0,NULL);
			}
		}
		return TRUE;
	}

  return FALSE;
}


void
on_hub_recent_clist_click_column       (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_hub_recent_clist_button_press_event (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,3,&col))
					start_a_new_dctc(col,0,NULL);
			}
		}
		return TRUE;
	}


  return FALSE;
}


void
on_find_result_click_column            (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
#if 1
	gtk_clist_freeze(clist);

	if(clist->sort_column==column)
	{
		if(clist->sort_type==GTK_SORT_ASCENDING)
			gtk_clist_set_sort_type(clist,GTK_SORT_DESCENDING);
		else
			gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
	}
	else
	{
		gtk_clist_set_sort_column(clist,column);
		gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
	}
	gtk_clist_sort(clist);

	/* File size high-lighting, 10/5/02, Idea and first version of code by thomas@stewarts.org.uk */
	if(column == 2)
	{ /* if we are sorting by size */
		gint total_rows;

		total_rows = clist->rows; 
		if(total_rows!=0)
		{
			gchar *text;
			int num_color=0;
			static GdkColor *color_list[]={&white,&greyDD,&greyEE};
			gint row, size, old_size;

			row=0;
			gtk_clist_get_text(clist,row,column, &text);
			old_size=size=atoi(text);
		
			for(row=0; row < total_rows; row++)
			{ /* loop every row */
				gtk_clist_get_text(clist,row,column, &text);
				size=atoi(text); /* size = current row value */
				if(old_size != size)
				{ /* size has changed, so swap */
					num_color=(num_color+1)%3;
				}
				gtk_clist_set_background(clist,row,color_list[num_color]);
				old_size = size; /* remember old value */
			}
		}
	}
	else
	{
		gint row, total_rows;
		total_rows = clist->rows;
		for(row=0; row < total_rows; row++)
			gtk_clist_set_background(clist,row,&white);
	}
	
	gtk_clist_thaw(clist);
#else
	on_hub_favorite_clist_click_column(clist,column,user_data);
#endif
}

/************************************************************************/
/* this function add generate a "cmd user" from the given find_cl_entry */
/************************************************************************/
/* cmd is a GString "/GDLADD gdl_id|" and it must be restored to this */
/* at the end                                                         */
/**********************************************************************/
static void do_add_gdl_source_from_find_result(FIND_CL_ENTRY *fce, void *cmd)
{
	int ln;
	GString *dl=cmd;

	ln=dl->len;

	g_string_sprintfa(dl,"%s|%s|%lu\n",fce->nickname,fce->filename,fce->file_size);
	send_data_to_dctc(dl->str);

	g_string_truncate(dl,ln);		/* restore original string lenght */
}

static void add_source_to_gdl_from_find_result_clist(unsigned long int gdl_id)
{
	GString *dl;
	dl=g_string_new("");
	g_string_sprintf(dl,"/GDLADD %lu|",gdl_id);	/* it is the common part of the string */

	generic_selected_find_result_calls(do_add_gdl_source_from_find_result,dl);
	g_string_free(dl,TRUE);
}

/*****************************************************************************/
/* this function add generate a "cmd user" from the given user_file_cl_entry */
/*****************************************************************************/
/* cmd is a GString "/GDLADD gdl_id|" and it must be restored to this */
/* at the end                                                         */
/**********************************************************************/
static void do_add_gdl_source_from_user_file_list(GtkCTree *ctree,USER_FILE_CL_ENTRY *fce, void *cmd)
{
	int ln;
	GString *dl=cmd;
	USER_FILE_CL_ENTRY *nick_ent;

	if(fce->entry_type!=UFL_FILE_ENTRY)
		return;

	nick_ent=get_nick_entry_for_user_file_list_from_ufce(ctree,fce);
	if(nick_ent==NULL)
	{
		fprintf(stderr,"do_add_gdl_source_from_user_file_list: no USER_FILE_CL_ENTRY found\n");
		return;
	}

	ln=dl->len;

	g_string_sprintfa(dl,"%s|%s|%lu\n",nick_ent->c.nickname,fce->c.file.filename,fce->c.file.file_size);
	send_data_to_dctc(dl->str);

	g_string_truncate(dl,ln);		/* restore original string lenght */
}

static void add_source_to_gdl_from_user_file_list_clist(unsigned long int gdl_id)
{
	GString *dl;
	dl=g_string_new("");
	g_string_sprintf(dl,"/GDLADD %lu|",gdl_id);	/* it is the common part of the string */

	generic_selected_user_file_list_calls(do_add_gdl_source_from_user_file_list,dl);
	g_string_free(dl,TRUE);
}

/******************************************************************************************/
/* this function is called when the user clicks on a GDL entry of the start_dl_popup_menu */
/******************************************************************************************/
/* user_data is the GDL ID */
/***************************/
static void add_selected_entries_to_this_gdl(GtkMenuItem *menuitem, gpointer user_data)
{
	unsigned long gdl_id=(unsigned long)user_data;
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					add_source_to_gdl_from_find_result_clist(gdl_id);
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					add_source_to_gdl_from_user_file_list_clist(gdl_id);
					break;

		default:
					break;
	}
}


/***************************************************************************************/
/* create a new GDL from the given gdl_id, the remote filename and the remote filesize */
/***************************************************************************************/
static void	do_gdl_new_from_info(unsigned long int gdl_id, const char *remote_fname, unsigned long remote_fsize)
{
	GString *str;
	const char *lname;

	lname=strrchr(remote_fname,'\\');
	if(lname==NULL)
		lname=remote_fname;
	else
		lname++;

	str=g_string_new("");
	g_string_sprintf(str,"/GDLNEW %lu|%lu|%s\n",gdl_id,remote_fsize,lname);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}

static unsigned long int base_gdl_id=0;
/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
/* autoscan_pattern can be either NULL or a string with the format "filetype|pattern" */
/**************************************************************************************/
static void create_one_gdl_for_all_files_optionnal_autoscan(char *clist_name, int nick_col, int fname_col, int fsize_col, char *autoscan_pattern)
{
	GtkWidget *w;
	GString *dl;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;
	int max_row=-1;
	unsigned long max_size=0;

	if(base_gdl_id==0)
		base_gdl_id=time(NULL);

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);
	
	/* we must process in 2 steps: 1) find the biggest source file */
	/*                             2) add all sources to the newly created GDL */
	/* step 1 */
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *fsize;
	
			if(gtk_clist_get_text(clst,row,fsize_col,&fsize))
			{
				if(fsize!=NULL)
				{
					unsigned long temp_size;

					temp_size=strtoul(fsize,NULL,10);
					if(temp_size>=max_size)		/* >= because a 0 file_size would generate problem else */
					{
						max_size=temp_size;
						max_row=row;
					}
				}
			}
		}
	}
	
	if(max_row==-1)	/* nothing selected */
		return;

	/* create a new GDL, using information of the biggest file */
	{
		char *fname, *fsize;
	
		if( (gtk_clist_get_text(clst,max_row,fname_col,&fname)) &&
			 (gtk_clist_get_text(clst,max_row,fsize_col,&fsize)) )
		{
			if((fname!=NULL)&&(fsize!=NULL))
			{
				do_gdl_new_from_info(base_gdl_id, fname, max_size);
			}
			else
				return;
		}
		else
			return;
	}

	/* step 2) add all entries to the newly created GDL */
	dl=g_string_new("");
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick, *fname, *fsize;
	
			if( (gtk_clist_get_text(clst,row,nick_col,&nick)) &&
				 (gtk_clist_get_text(clst,row,fname_col,&fname)) &&
				 (gtk_clist_get_text(clst,row,fsize_col,&fsize)) )
			{
				if((nick!=NULL)&&(fname!=NULL)&&(fsize!=NULL))
				{
					g_string_sprintf(dl,"/GDLADD %lu|%s|%s|%s\n",base_gdl_id,nick,fname,fsize);
					send_data_to_dctc(dl->str);
				}
			}
		}
	}

	/* step 3) add the autoscan pattern if exist */
	if(autoscan_pattern!=NULL)
	{
		g_string_sprintf(dl,"/GDLAS+ %lu|%s\n",base_gdl_id,autoscan_pattern);
		send_data_to_dctc(dl->str);
	}
	g_string_free(dl,TRUE);
	base_gdl_id+=12345678;
}

/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
static void create_one_gdl_for_all_files(char *clist_name, int nick_col, int fname_col, int fsize_col)
{
	create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,NULL);
}

static const char *ftype_str[]={ "any", "audio", "compressed", "document", "exe", "picture", "video", "folder", NULL};

/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
static void create_one_gdl_for_all_files_with_autoscan(char *clist_name, int nick_col, int fname_col, int fsize_col)
{
	GtkWidget *w3;
	char *pattern;
	unsigned int ftype;
	GString *str;

	w3=get_widget_by_widget_name("find_history_combo");
	if(w3==NULL)
	{
		create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,NULL);
		return;
	}

	pattern=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w3)->entry));
	if(strlen(pattern)==0)
	{
		create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,NULL);
		return;
	}

	ftype=gtk_entry_to_number("filetype_entry",ftype_str);

	str=g_string_new("");
	g_string_sprintf(str,"%u|%s",ftype+1,pattern);
	create_one_gdl_for_all_files_optionnal_autoscan(clist_name,nick_col,fname_col,fsize_col,str->str);
	g_string_free(str,TRUE);
}

/*****************************************************************************************/
/* this function is called when the user wants to create one GDL for each selected files */
/*****************************************************************************************/
static void create_one_gdl_per_files(char *clist_name, int nick_col, int fname_col, int fsize_col)
{
	GtkWidget *w;
	GString *dl;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;
	unsigned long int increment=123456789;	/* this value is added to gdl_id each time */

	if(base_gdl_id==0)
		base_gdl_id=time(NULL);

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);
	
	dl=g_string_new("");
	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick, *fname, *fsize;
	
			if( (gtk_clist_get_text(clst,row,nick_col,&nick)) &&
				 (gtk_clist_get_text(clst,row,fname_col,&fname)) &&
				 (gtk_clist_get_text(clst,row,fsize_col,&fsize)) )
			{
				if((nick!=NULL)&&(fname!=NULL)&&(fsize!=NULL))
				{
					do_gdl_new_from_info(base_gdl_id,fname,strtoul(fsize,NULL,10));
					g_string_sprintf(dl,"/GDLADD %lu|%s|%s|%s\n",base_gdl_id,nick,fname,fsize);
					send_data_to_dctc(dl->str);
					base_gdl_id+=increment;		/* to limit the risk of having 2 GDL with the same number, should be safe enough */
				}
			}
		}
	}
	g_string_free(dl,TRUE);
}

/********************************************************************************************************/
/* this function is called when the user wants to create one GDL for each selected files (find version) */
/********************************************************************************************************/
static void do_create_one_gdl_per_files_from_find_result(FIND_CL_ENTRY *fce, void *data)
{
	GString *dl=data;
	unsigned long int increment=123456789;	/* this value is added to gdl_id each time */

	if(base_gdl_id==0)
		base_gdl_id=time(NULL);

	do_gdl_new_from_info(base_gdl_id,fce->filename,fce->file_size);
	g_string_sprintf(dl,"/GDLADD %lu|%s|%s|%lu\n",base_gdl_id,fce->nickname,fce->filename,fce->file_size);
	send_data_to_dctc(dl->str);
	base_gdl_id+=increment;		/* to limit the risk of having 2 GDL with the same number, should be safe enough */
	g_string_truncate(dl,0);
}

/******************************************************************************************************************/
/* this function is called when the user wants to create one GDL for each selected files (user file list version) */
/******************************************************************************************************************/
static void do_create_one_gdl_per_files_from_user_file_list(GtkCTree *ctree, USER_FILE_CL_ENTRY *fce, void *data)
{
	GString *dl=data;
	unsigned long int increment=123456789;	/* this value is added to gdl_id each time */
	USER_FILE_CL_ENTRY *nick_ent;

	if(fce->entry_type!=UFL_FILE_ENTRY)
		return;

	nick_ent=get_nick_entry_for_user_file_list_from_ufce(ctree,fce);
	if(nick_ent==NULL)
		return;

	if(base_gdl_id==0)
		base_gdl_id=time(NULL);

	do_gdl_new_from_info(base_gdl_id,fce->c.file.filename,fce->c.file.file_size);
	g_string_sprintf(dl,"/GDLADD %lu|%s|%s|%lu\n",base_gdl_id,nick_ent->c.nickname,fce->c.file.filename,fce->c.file.file_size);
	send_data_to_dctc(dl->str);
	base_gdl_id+=increment;		/* to limit the risk of having 2 GDL with the same number, should be safe enough */
	g_string_truncate(dl,0);
}

static void unselect_offspring(gpointer entry, gpointer ct)
{
	GtkCTree *ctree;

	if((ct==NULL)||(entry==NULL))
	{
		printf("unselect_offspring: %p %p\n",ct,entry);
		return;
	}

	ctree=GTK_CTREE(ct);
	if(GTK_CTREE_ROW(entry)->is_leaf)
	{	/* it is a leaf, just unselect it */
		gtk_ctree_unselect(ctree,entry);
	}
	else
	{	/* it is not a leaf, unselect it and its offsprings */
		gtk_ctree_unselect_recursive(ctree,entry);
		/* and reselect it */
		gtk_ctree_select(ctree,entry);
	}
}

/*****************************************************************/
/* search the start of the last directory of the given directory */
/*****************************************************************/
/* dir can be "", if not, dir always ends with a '/' */
/* output: pointer on the last directory name        */
/*****************************************************/
static char *find_start_of_last_level(char *dir)
{
	int ln;

	ln=strlen(dir);
	if(ln==0)
		return dir;

	ln-=2;		/* skip the last character which is always a '/' */
	while(ln>=0)
	{
		if(dir[ln]=='\\')
			return dir+ln+1;
		ln--;
	}
	return dir;
}

static void create_one_gdl_for_offspring(GtkCTree *ctree,GtkCTreeNode *node, gpointer param)
{
	if(GTK_CTREE_ROW(node)->is_leaf)
	{
		/* we create GDL only for leaf */
		USER_FILE_CL_ENTRY *nick_ent;
		USER_FILE_CL_ENTRY *base_ufce;
		USER_FILE_CL_ENTRY *node_ufce;
		char *t;
		int to_ignore;
		unsigned long int new_gid=rand();
		GString *end_base_name;
		GString *end_dir_name;
		GString *cmd;
		GtkCTreeNode *base_node=GTK_CTREE_NODE(param);

		nick_ent=get_nick_entry_for_user_file_list_from_ctnode(ctree,node);
		if(nick_ent==NULL)
		{
			fprintf(stderr,"create_one_gdl_for_offspring: no USER_FILE_CL_ENTRY found\n");
			return;
		}

		base_ufce=gtk_ctree_node_get_row_data(ctree,base_node);
		node_ufce=gtk_ctree_node_get_row_data(ctree,node);

		/* nick_ent->c.nickname=the nickname */
		/* base_ufce->c.dir_name=the base directory (the last level of this path must be kept */
		/* node_ufce->c.file.filename= the full file path */
		/* node_ufce->c.file.file_size= the file size */

		t=find_start_of_last_level(base_ufce->c.dir_name);
		if(t==NULL)
			to_ignore=0;
		else
			to_ignore=t-(base_ufce->c.dir_name);		/* part of the path to discard at the beginning of the file path */

		end_dir_name=g_string_new(node_ufce->c.file.filename+to_ignore);
		t=strrchr(end_dir_name->str,'\\');
		if(t==NULL)
		{
			end_base_name=g_string_new(end_dir_name->str);
			end_dir_name=g_string_truncate(end_dir_name,0);
		}
		else
		{
			int i;
			end_base_name=g_string_new(t+1);
			end_dir_name=g_string_truncate(end_dir_name,t-end_dir_name->str);
			for(i=0;i<end_dir_name->len;i++)
			{
				if(end_dir_name->str[i]=='\\')
					end_dir_name->str[i]='/';
			}
		}

		cmd=g_string_new("");
		g_string_sprintf(cmd,"/GDLNEW %lu|%lu|%s\n",new_gid,node_ufce->c.file.file_size,end_base_name->str);
		send_data_to_dctc(cmd->str);

		g_string_sprintf(cmd,"/GDLRENAME %lu|%s|%s\n",new_gid,end_base_name->str,end_dir_name->str);
		send_data_to_dctc(cmd->str);

		g_string_sprintf(cmd,"/GDLADD %lu|%s|%s|%lu\n",new_gid,nick_ent->c.nickname,node_ufce->c.file.filename,node_ufce->c.file.file_size);
		send_data_to_dctc(cmd->str);

		g_string_free(end_dir_name,TRUE);
		g_string_free(end_base_name,TRUE);
		g_string_free(cmd,TRUE);
	}
}

static void create_offspring_gdl(gpointer entry, gpointer ct)
{
	GtkCTree *ctree;

	if((ct==NULL)||(entry==NULL))
	{
		printf("create_offspring_gdl: %p %p\n",ct,entry);
		return;
	}

	ctree=GTK_CTREE(ct);

	gtk_ctree_post_recursive(ctree,entry,(void*)create_one_gdl_for_offspring,entry);
}

/*****************************************************************************************************************/
/* this function is called when the user wants to create one GDL for each selected files of a recursive download */
/*****************************************************************************************************************/
static void add_recursive_to_gdl_with_create(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *w;
	GtkCTree *ctree;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case USER_FILE_LIST_TAB:	/* user file list */
					w=get_widget_by_widget_name("user_file_list_clist");
					ctree=GTK_CTREE(w);
					/* FIXME: not done */
					/* 1) for each selected entry, check if it does not have a selected parent */
					/*    algo: for each selected entry, we unselect all offsprings and also all leafs */
					gtk_clist_freeze(GTK_CLIST(ctree));
					{
						GList *nw;

						nw=g_list_copy(GTK_CLIST(ctree)->selection);
						g_list_foreach(nw,unselect_offspring,ctree);
						g_list_free(nw);
					}
					gtk_clist_thaw(GTK_CLIST(ctree));
					/* 2) for each remaining selected entry (which is always a directory), we scan its leafs and build GDLs */
					g_list_foreach(GTK_CLIST(ctree)->selection,create_offspring_gdl,ctree);
					break;

		default:
					break;
	}
}

typedef struct 
{
	GString *dl;
	unsigned long gdl_id;
	unsigned long biggest_size;
	const char *biggest_name;		/* read only value, it is the value stored in the FIND_CL_ENTRY */
} CREATE_GDL_FOR_FILES_PARAM;

static void do_find_biggest_selected_from_find_result(FIND_CL_ENTRY *fce, void *data)
{
	CREATE_GDL_FOR_FILES_PARAM *cgf=data;

	if(fce->file_size>cgf->biggest_size)
	{
		cgf->biggest_name=fce->filename;
		cgf->biggest_size=fce->file_size;
	}
}

static void do_find_biggest_selected_from_user_file_list(GtkCTree *ctree, USER_FILE_CL_ENTRY *fce, void *data)
{
	CREATE_GDL_FOR_FILES_PARAM *cgf=data;

	if(fce->entry_type!=UFL_FILE_ENTRY)
		return;

	if(fce->c.file.file_size>cgf->biggest_size)
	{
		cgf->biggest_name=fce->c.file.filename;
		cgf->biggest_size=fce->c.file.file_size;
	}
}

/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
/* autoscan_pattern can be either NULL or a string with the format "filetype|pattern" */
/**************************************************************************************/
static void do_create_one_gdl_for_all_files_from_find_result(FIND_CL_ENTRY *fce, void *data)
{
	CREATE_GDL_FOR_FILES_PARAM *cgf=data;

	g_string_sprintf(cgf->dl,"/GDLADD %lu|%s|%s|%lu\n",cgf->gdl_id,fce->nickname,fce->filename,fce->file_size);
	send_data_to_dctc(cgf->dl->str);
}

/****************************************************************************************/
/* this function is called when the user wants to create one GDL for all selected files */
/****************************************************************************************/
static void do_create_one_gdl_for_all_files_from_user_file_list(GtkCTree *ctree,USER_FILE_CL_ENTRY *fce, void *data)
{
	CREATE_GDL_FOR_FILES_PARAM *cgf=data;
	USER_FILE_CL_ENTRY *nick_ent;

	if(fce->entry_type!=UFL_FILE_ENTRY)
		return;

	nick_ent=get_nick_entry_for_user_file_list_from_ufce(ctree,fce);
	if(nick_ent==NULL)
		return;
	
	g_string_sprintf(cgf->dl,"/GDLADD %lu|%s|%s|%lu\n",cgf->gdl_id,nick_ent->c.nickname,fce->c.file.filename,fce->c.file.file_size);
	send_data_to_dctc(cgf->dl->str);
}

/*********************************************************************************************/
/* this function is called when the user wants to create one GDL for each/all selected files */
/*********************************************************************************************/
static void add_to_gdl_with_create(GtkMenuItem *menuitem, gpointer user_data)
{
	GtkWidget *w;
	void (*fnc)(char *clist_name, int nick_col,int fname_col,int fsize_col)=user_data;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					if(fnc==create_one_gdl_per_files)
					{
						GString *dl;
						dl=g_string_new("");

						generic_selected_find_result_calls(do_create_one_gdl_per_files_from_find_result,dl);
						g_string_free(dl,TRUE);
					}
					else
					{
						CREATE_GDL_FOR_FILES_PARAM cgf;
						GString *autoscan=NULL;

						cgf.dl=g_string_new("");
						cgf.gdl_id=0;

						if(fnc==create_one_gdl_for_all_files_with_autoscan)
						{
							GtkWidget *w3;

							w3=get_widget_by_widget_name("find_history_combo");
							if(w3!=NULL)
							{
								char *pattern;

								pattern=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w3)->entry));
								if(strlen(pattern)!=0)
								{
									unsigned int ftype;
									ftype=gtk_entry_to_number("filetype_entry",ftype_str);
							
									autoscan=g_string_new("");
									g_string_sprintf(autoscan,"%u|%s",ftype+1,pattern);
								}
							}
						}
						cgf.biggest_size=0;
						cgf.biggest_name=NULL;

						/* search the entry having the biggest file size */
						generic_selected_find_result_calls(do_find_biggest_selected_from_find_result,&cgf);
						if(cgf.biggest_name!=NULL)
						{
							if(base_gdl_id==0)
								base_gdl_id=time(NULL);

							/* create a new GDL, using information of the biggest file */
							do_gdl_new_from_info(base_gdl_id, cgf.biggest_name, cgf.biggest_size);
							cgf.gdl_id=base_gdl_id;
							base_gdl_id+=12345678;

							generic_selected_find_result_calls(do_create_one_gdl_for_all_files_from_find_result,&cgf);

							/* add the autoscan pattern if exist */
							if(autoscan!=NULL)
							{
								g_string_sprintf(cgf.dl,"/GDLAS+ %lu|%s\n",cgf.gdl_id,autoscan->str);
								send_data_to_dctc(cgf.dl->str);
							}
						}

						g_string_free(cgf.dl,TRUE);
						if(autoscan)
							g_string_free(autoscan,TRUE);
					}
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					if(fnc==create_one_gdl_per_files)
					{
						GString *dl;
						dl=g_string_new("");

						generic_selected_user_file_list_calls(do_create_one_gdl_per_files_from_user_file_list,dl);
						g_string_free(dl,TRUE);
					}
					else
					{
						CREATE_GDL_FOR_FILES_PARAM cgf;

						cgf.dl=g_string_new("");
						cgf.gdl_id=0;
						cgf.biggest_size=0;
						cgf.biggest_name=NULL;

						/* search the entry having the biggest file size */
						generic_selected_user_file_list_calls(do_find_biggest_selected_from_user_file_list,&cgf);
						if(cgf.biggest_name!=NULL)
						{
							if(base_gdl_id==0)
								base_gdl_id=time(NULL);

							/* create a new GDL, using information of the biggest file */
							do_gdl_new_from_info(base_gdl_id, cgf.biggest_name, cgf.biggest_size);
							cgf.gdl_id=base_gdl_id;
							base_gdl_id+=12345678;

							generic_selected_user_file_list_calls(do_create_one_gdl_for_all_files_from_user_file_list,&cgf);
						}

						g_string_free(cgf.dl,TRUE);
					}
					break;

		default:
					break;
	}
}

/****************************************************/
/* used to store the name of unattached GDL entries */
/****************************************************/
static GStringChunk *gdl_popup_gsc=NULL;

/******************************************************************************************/
/* this function is called when the user clicks on a GDL entry of the start_dl_popup_menu */
/******************************************************************************************/
/* user_data is the name of the GDL */
/************************************/
static void active_add_unattached_gdl(GtkMenuItem *menuitem, gpointer user_data)
{
	GString *str;

	str=g_string_new("/GDLATTACH ");
	str=g_string_append(str,user_data);
	str=g_string_append_c(str,'\n');
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


static void try_to_add_to_gdl_popup(const char *dir1, const char *dir2)
{
	GString *str;
	int fd;

	str=g_string_new("");
	g_string_sprintf(str,"%s/%s/.lock",dir1,dir2);

	fd=open(str->str,O_RDWR);
	if(fd!=-1)
	{
		if(lockf(fd,F_TEST,1)==0)
		{
			/* .lock file exists and is lockable, so nobody uses this entry */
			GtkWidget *mitem;

			if(gdl_popup_gsc==NULL)
				gdl_popup_gsc=g_string_chunk_new(48);

			mitem=gtk_menu_item_new_with_label(dir2);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", 
							GTK_SIGNAL_FUNC(active_add_unattached_gdl),
								g_string_chunk_insert_const(gdl_popup_gsc,dir2));
			gtk_menu_append(GTK_MENU(gdl_popup),mitem);
			gtk_widget_show(mitem);
			
		}
		close(fd);
	}
	g_string_free(str,TRUE);
}

/**********************************************************/
/* rebuild a new gdl_popup_menu with currently unused GDL */
/**********************************************************/
static void build_gdl_popup(void)
{
	DIR *dir;
	struct dirent *obj;
	const char *t;
	GtkWidget *mitem;

	if(gdl_popup!=NULL)
	{
		widget_unlog(gdl_popup);
		gtk_widget_destroy(gdl_popup);
	}
	if(gdl_popup_gsc!=NULL)
	{
		g_string_chunk_free(gdl_popup_gsc);
		gdl_popup_gsc=NULL;
	}

	/* create the default gdl_popup_menu */
	gdl_popup=create_gdl_popup_menu();

	mitem=gtk_menu_item_new_with_label(_("-- unattached GDLs"));
	gtk_widget_set_sensitive(mitem,FALSE);
	gtk_menu_append(GTK_MENU(gdl_popup),mitem);
	gtk_widget_show(mitem);

	t=get_var("dl_path");
	if((t!=NULL)&&(strlen(t)))
	{
		GString *st1;

		st1=g_string_new(t);
		st1=g_string_append(st1,"/GDL");
		dir=opendir(st1->str);
		if(dir!=NULL)
		{
			while((obj=readdir(dir))!=NULL)
			{
				try_to_add_to_gdl_popup(st1->str,obj->d_name);
			}
			closedir(dir);
		}
		g_string_free(st1,TRUE);
	}
}

static void
on_expand_all_ctree             (GtkMenuItem     *menuitem,
                                 gpointer         user_data)
{
   GtkWidget *w;

   w=get_widget_by_widget_name((char*)user_data);
   if(w!=NULL)
   {
      GtkCTreeNode *work;
               
      work=GTK_CTREE_NODE (GTK_CLIST (w)->row_list);

      while(work!=NULL)
      {
         gtk_ctree_expand_recursive(GTK_CTREE(w),work);
         work = GTK_CTREE_ROW (work)->sibling;
      }
   }
}
      
static void
on_shrink_all_ctree             (GtkMenuItem     *menuitem,
                                 gpointer         user_data)
{
   GtkWidget *w;

   w=get_widget_by_widget_name((char*)user_data);
   if(w!=NULL)
   {
      GtkCTreeNode *work;
               
      work=GTK_CTREE_NODE (GTK_CLIST (w)->row_list);

      while(work!=NULL)
      {
         gtk_ctree_collapse_recursive(GTK_CTREE(w),work);
         work = GTK_CTREE_ROW (work)->sibling;
      }
   }
}
 
typedef struct
{
	int with_file_size;			/* if ==0, file_size is not set */
	unsigned long file_size;	/* else if ==1 file_size contains the searched size.  */
										/* else >1 there is more than one searched size */
	GtkWidget *bad_size;			/* this widget is the menu containing GDL having a size different of file_size */
	int nb_bad_size;				/* number of entry in bad_size menu */
} DL_POPUP_XTRA_PARAM;

/*********************************************************/
/* add the given cnode to the end of start_dl_popup_menu */
/*********************************************************/
static void add_gdl_entry_to_popup(GtkCTree *ctree, GtkCTreeNode *cnode, gpointer data)
{
	GDL_CT_ENTRY *gce;

	gce=gtk_ctree_node_get_row_data(ctree,cnode);
	if((gce!=NULL)&&(gce->ct_type==GDL_ROOT))
	{
		GtkWidget *mitem;
		GString *str;
		DL_POPUP_XTRA_PARAM *dpxp=data;

		str=g_string_new("");
#ifndef NO_PRINTF_LOCALE
		g_string_sprintf(str,"%s (%'lu)",gce->c.root.local_filename,gce->c.root.gdl_size);		/* NO_PRINTF_LOCAL support added */
#else
		g_string_sprintf(str,"%s (%lu)",gce->c.root.local_filename,gce->c.root.gdl_size);
#endif

		mitem=gtk_menu_item_new_with_label(str->str);
		gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_selected_entries_to_this_gdl),(void*)(gce->c.root.gdl_id));

		if(dpxp->with_file_size==0)
		{
			/* no size => no submenu => everything in the main menu */
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		}
		else
		{
			if(dpxp->file_size==gce->c.root.gdl_size)
			{	/* a matching size => in the main menu */
				gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			}
			else
			{	/* a not matching size => in the submenu */
				gtk_menu_append(GTK_MENU(dpxp->bad_size),mitem);
				dpxp->nb_bad_size++;
			}
		}
		gtk_widget_show(mitem);
		g_string_free(str,TRUE);
	}
}

/********************************************************************************/
/* fill DL_POPUP_XTRA_PARAM file_size according to selected rows of find_result */
/********************************************************************************/
static void check_find_size(FIND_CL_ENTRY *fce, void *param)
{
	DL_POPUP_XTRA_PARAM *dpxp=param;

	if(dpxp->with_file_size==0)
	{
		dpxp->with_file_size++;
		dpxp->file_size=fce->file_size;
	}
	else
	{
		if(dpxp->file_size!=fce->file_size)
			dpxp->with_file_size++;
	}
}

/*************************************************************************************/
/* fill DL_POPUP_XTRA_PARAM file_size according to selected rows of "user_file_list" */
/*************************************************************************************/
static void check_share_list_size(GtkCTree *ctree, USER_FILE_CL_ENTRY *ufce, void *param)
{
	DL_POPUP_XTRA_PARAM *dpxp=param;

	if(ufce==NULL)
		return;

	if(ufce->entry_type==UFL_FILE_ENTRY)
	{
		if(dpxp->with_file_size==0)
		{
			dpxp->with_file_size++;
			dpxp->file_size=ufce->c.file.file_size;
		}
		else
		{
			if(dpxp->file_size!=ufce->c.file.file_size)
				dpxp->with_file_size++;
		}
	}
}

/****************************************************************/
/* rebuild a new start_dl_popup_menu with currently running GDL */
/****************************************************************/
static void build_start_dl_popup(int from_panel)
{
	GtkWidget *w;
	DL_POPUP_XTRA_PARAM dpxp;

	if(start_dl_popup!=NULL)
	{
		widget_unlog(start_dl_popup);
		gtk_widget_destroy(start_dl_popup);
	}

	/* create the default start_dl_popup_menu */
	start_dl_popup=create_start_dl_popup_menu();

	/* and add it the list of GDL */
	w=get_widget_by_widget_name("gdl_ctree");
	if(w!=NULL)
	{
		GtkCTree *ctree;
		GtkWidget *mitem;

		if(from_panel==USER_FILE_LIST_TAB)
		{
			mitem=gtk_menu_item_new_with_label(_("Download Selected directories"));
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_recursive_to_gdl_with_create),NULL);
			gtk_widget_show(mitem);

			mitem=gtk_menu_item_new_with_label(_("Shrink all"));
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(on_shrink_all_ctree),"user_file_list_clist");
			gtk_widget_show(mitem);

			mitem=gtk_menu_item_new_with_label(_("Expand all"));
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(on_expand_all_ctree),"user_file_list_clist");
			gtk_widget_show(mitem);
		}

		mitem=gtk_menu_item_new_with_label(_("-- create GDLs"));
		gtk_widget_set_sensitive(mitem,FALSE);
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_widget_show(mitem);

		mitem=gtk_menu_item_new_with_label(_("Create a new GDL for each selected files"));
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_to_gdl_with_create),create_one_gdl_per_files);
		gtk_widget_show(mitem);

		mitem=gtk_menu_item_new_with_label(_("Create one new GDL for all selected files"));
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_to_gdl_with_create),create_one_gdl_for_all_files);
		gtk_widget_show(mitem);

		if(from_panel==FIND_TAB)
		{
			mitem=gtk_menu_item_new_with_label(_("Create one new GDL for all selected files + add autoscan"));
			gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
			gtk_signal_connect(GTK_OBJECT(mitem),"activate", GTK_SIGNAL_FUNC(add_to_gdl_with_create),create_one_gdl_for_all_files_with_autoscan);
			gtk_widget_show(mitem);
		}

		dpxp.with_file_size=0;
		dpxp.file_size=0;

		switch(from_panel)
		{
			case FIND_TAB:	generic_selected_find_result_calls(check_find_size,&dpxp);
								break;
			case USER_FILE_LIST_TAB:
								generic_selected_user_file_list_calls(check_share_list_size,&dpxp);
								break;
		}

		if(dpxp.with_file_size==1)
		{
			/* we have one size only */
			dpxp.bad_size=gtk_menu_new();
			dpxp.nb_bad_size=0;
		}
		else
		{
			dpxp.with_file_size=0;		/* file size is irrevelant */
			dpxp.bad_size=NULL;
			dpxp.nb_bad_size=0;
		}

		ctree=GTK_CTREE(w);

		if(dpxp.with_file_size==0)
			mitem=gtk_menu_item_new_with_label(_("-- active GDLs"));
		else
			mitem=gtk_menu_item_new_with_label(_("-- active GDLs with the same size"));
		gtk_widget_set_sensitive(mitem,FALSE);
		gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
		gtk_widget_show(mitem);

		gtk_ctree_post_recursive_to_depth(ctree,NULL,1,add_gdl_entry_to_popup,&dpxp);

		if(dpxp.with_file_size==1)
		{
			if(dpxp.nb_bad_size==0)
				gtk_widget_destroy(dpxp.bad_size);
			else
			{
				mitem=gtk_menu_item_new_with_label(_("-- active GDLs with a different size"));
				gtk_menu_append(GTK_MENU(start_dl_popup),mitem);
				gtk_widget_show(mitem);
				gtk_menu_item_set_submenu(GTK_MENU_ITEM(mitem),dpxp.bad_size);
			}
		}
	}
}

gboolean
on_find_result_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				FIND_CL_ENTRY *fce;
				fce=gtk_clist_get_row_data(GTK_CLIST(widget),row);
				if(fce!=NULL)
				{
					GString *dl;

					dl=g_string_new("/DL |"); 							/* adapted to new /DL */
					g_string_sprintfa(dl,"%s||%s|%lu\n",fce->nickname,fce->filename,fce->file_size);				/* let DCTC generate the filename itself */
					send_data_to_dctc(dl->str);
					g_string_free(dl,TRUE);
				}
			}
		}
		return TRUE;
	}
	else if(event->button==3)
	{	/* right-click */
		build_start_dl_popup(FIND_TAB);
		gtk_menu_popup(GTK_MENU(start_dl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
	
  return FALSE;
}

#define MAX_FIND_HISTORY_SIZE 10

/************************************************************************/
/* this function add a new search pattern to the find_history combo box */
/* the number of entry in the history is limited to 10 pattern. If the  */
/* given pattern already exists, it is moved to the first place in the  */
/* history.                                                             */
/************************************************************************/
static void add_pattern_to_find_history(char *pattern)
{
	GtkWidget *w;
	static GList *current_history=NULL;
	char *tmp_str;
	int i;

	w=get_widget_by_widget_name("find_history_combo");
	if(w==NULL)
		return;

	tmp_str=strdup(pattern);
	if(tmp_str==NULL)
	{
		fprintf(stderr,"Out of memory: history not updated.\n");
		return;
	}

	current_history=g_list_prepend(current_history,tmp_str);

	/* remove duplicate entry (if exists) */
	i=1;
	while(i<g_list_length(current_history))
	{
		gpointer str_to_test;

		str_to_test=g_list_nth_data(current_history,i);
		if(!strcasecmp(tmp_str,str_to_test))
		{
			free(str_to_test);
			current_history=g_list_remove(current_history,str_to_test);
		}
		else
			i++;
	}

	/* keep only the first Nth entry of the history */
	while(g_list_length(current_history)>MAX_FIND_HISTORY_SIZE)
	{
		gpointer str_to_delete;

		str_to_delete=g_list_nth_data(current_history,MAX_FIND_HISTORY_SIZE);
		current_history=g_list_remove(current_history,str_to_delete);
		free(str_to_delete);
	}

	gtk_combo_set_popdown_strings (GTK_COMBO (w), current_history);
}

void
on_find_entry_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
	char *param;
	unsigned int ftype1,ftype2;
	GString *req1,*req2;
	GString *req;				/* common part of the request */
	GtkWidget *w;
	GtkWidget *w3;

	w3=get_widget_by_widget_name("find_history_combo");
	if(w3==NULL)
		return;

	param=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(w3)->entry));
	if(strlen(param)<1)
		return;

	/* convert filetype_entry into a number */
	ftype1=gtk_entry_to_number("filetype_entry",ftype_str);
	req1=g_string_new("/SRCH ");
	g_string_sprintfa(req1,"|%s|%u",param,ftype1+1);

	/* same thing for fileentry_entry1 */
	ftype2=gtk_entry_to_number_wo_default("filetype_entry1",ftype_str);
	req2=g_string_new("/SRCH ");
	g_string_sprintfa(req2,"|%s|%u",param,ftype2+1);

	/* build the common part of the request */
	req=g_string_new("");

	w=get_widget_by_widget_name("size_checkbutton");
	if(w==NULL)
	{
		abrt:
		g_string_free(req,TRUE);
		return;
	}
	
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))==TRUE)
	{
		static const char *sizetype_str[3];
		static const char *scale_str[5];
		static int unset=1;
		double val;
		double scale;

		if(unset)
		{
			sizetype_str[0]=_("at least");
			sizetype_str[1]=_("at most");
			sizetype_str[2]=NULL;
			scale_str[0]=_("Bytes");
			scale_str[1]=_("KBytes");
			scale_str[2]=_("MBytes");
			scale_str[3]=_("GBytes");
			scale_str[4]=NULL;
			unset=0;
		}

		/* get the size type */
		switch(gtk_entry_to_number("sizetype_entry",sizetype_str))
		{
			case 0:
						req=g_string_append(req,"|L|");
						break;

			case 1:
						req=g_string_append(req,"|M|");
						break;
		}

		switch(gtk_entry_to_number("size_unit_entry",scale_str))
		{
			default:
			case 0:	scale=1.0;
						break;
			case 1:	scale=1024.0;
						break;
			case 2:	scale=1024.0*1024.0;
						break;
			case 3:	scale=1024.0*1024.0*1024.0;
						break;
		}

		w=get_widget_by_widget_name("size_entry");
		if(w==NULL)
			goto abrt;

		val=atof(gtk_entry_get_text(GTK_ENTRY(w)));

		g_string_sprintfa(req,"%f",scale*val);
	}

	w=get_widget_by_widget_name("find_result");
	if(w!=NULL)
	{
		gtk_clist_freeze(GTK_CLIST(w));
		gtk_clist_clear(GTK_CLIST(w));
		gtk_clist_thaw(GTK_CLIST(w));
	}

	req=g_string_append_c(req,'\n');

	/* send the first string */
	req1=g_string_append(req1,req->str);
	send_data_to_dctc(req1->str);

	if(last_search[0]!=NULL)
	{
		g_string_free(last_search[0],TRUE);
	}
	last_search[0]=req1;

	/* if the second search criteria exists, start a search */
	if((ftype2!=-1)&&(ftype2!=ftype1))
	{
		req2=g_string_append(req2,req->str);
		send_data_to_dctc(req2->str);

		if(last_search[1]!=NULL)
		{
			g_string_free(last_search[1],TRUE);
		}
		last_search[1]=req2;
	}
	else
	{
		if(last_search[1]!=NULL)
		{
			g_string_free(last_search[1],TRUE);
			last_search[1]=NULL;
		}
		g_string_free(req2,TRUE);
	}

	if(last_search_tag!=-1)
	{
		gtk_timeout_remove(last_search_tag);
		last_search_tag=-1;
	}

	if(last_search[0]!=NULL)
	{
		int i;

		i=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name("multihub_checkbutton")));
		if(i==TRUE)
		{
			last_search_tag=gtk_timeout_add(10*1000,start_msearch,NULL);		/* wait 10 seconds before doing a multi-hub search */
		}
	}

	g_string_free(req,TRUE);
#if 0
	g_string_free(req1,TRUE);
	g_string_free(req2,TRUE);
#endif

	/* keep a pre-sliced search pattern */
	if(last_started_search!=NULL)
	{
		g_strfreev(last_started_search);
		last_started_search=NULL;
	}

	last_started_search=g_strsplit(param,"$",0);

	/* we must add the new search pattern to the history at the end of the function */
	/* because when the popdown list is modified, it seems to alter the entry (not its value but its memory position) */
	add_pattern_to_find_history(param);
}

void
on_find_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("find_entry");
	if(w!=NULL)
	{
		on_find_entry_activate(GTK_EDITABLE(w),NULL);
	}
}

void
on_user_clist_click_column             (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_user_clist_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1 && event->type==GDK_2BUTTON_PRESS)
	{	/* double left-click on a row */
		foreach_selected_entry_send_cmd("/LS","user_clist",UCC_NICK_COL);
		return TRUE;
	}
		
	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(user_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

	return FALSE;
}


void
on_download_clist_click_column				 (GtkCList				*clist,
																				gint						 column,
																				gpointer				 user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_download_clist_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(dl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
  return FALSE;
}


void
on_upload_clist_click_column           (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_upload_clist_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(ul_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}


void
on_queue_clist_click_column            (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_queue_clist_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(q_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}


void
on_done_clist_click_column             (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_done_clist_button_press_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(done_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}
  return FALSE;
}




gboolean
on_app1_delete_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gui_full_save(widget,NULL);
	gtk_widget_destroy(widget);
	gtk_main_quit();
  return FALSE;
}



void
on_about2_clicked                      (GnomeDialog     *gnomedialog,
                                        gint             arg1,
                                        gpointer         user_data)
{

}


void
on_do_browse_dl_dir_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_dl_dir_fileselection();
	{
		GtkWidget *dl_dir_ent;

		dl_dir_ent=get_widget_by_widget_name("dl_dir_entry");
		if(dl_dir_ent!=NULL)
		{
			char *t;

			t=gtk_entry_get_text(GTK_ENTRY(dl_dir_ent));
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(w),t);
		}
	}
	gtk_widget_show(w);
	widget_log(w);			/* for an unknown reason, widget_log is not called for the widget containing widgets created by create_* functions */
								/* so we must manually register it */
}


gboolean
on_shared_dir_clist_key_press_event    (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_add_shared_dir_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_shared_dir_fileselection();
	{
		GtkWidget *dl_dir_ent;

		dl_dir_ent=get_widget_by_widget_name("dl_dir_entry");		/* start directory is the one use to download directory */
		if(dl_dir_ent!=NULL)
		{
			char *t;

			t=gtk_entry_get_text(GTK_ENTRY(dl_dir_ent));
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(w),t);
		}
	}
	gtk_widget_show(w);
	widget_log(w);			/* for an unknown reason, widget_log is not called for the widget containing widgets created by create_* functions */
								/* so we must manually register it */
}


void
on_remove_shared_dir_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;
	GString *str;
	int row;
	int i;

	w=get_widget_by_widget_name("shared_dir_clist");
	if(w==NULL)
		return;

	clist=GTK_CLIST(w);
	row=clist->rows-1;
	while(row>=0)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			gtk_clist_remove(clist,row);
		}
		row--;
	}

	/* refresh the hidden entry */
	str=g_string_new("");
	for(i=0;i<clist->rows;i++)
	{
		char *t=NULL;

		gtk_clist_get_text(clist,i,0,&t);
		if(t!=NULL)
		{
			if(str->len!=0)
				str=g_string_append_c(str,'|');
		
			str=g_string_append(str,t);
		}
	}

	w=get_widget_by_widget_name("hidden_shared_dir_entry");
	if(w!=NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(w),str->str);	
	}
	g_string_free(str,TRUE);
}

void
on_refresh_sitelist_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
	{
		case RUNNING_HUB_TAB:
					fill_running_hub_clist();
					break;

		case PUBLIC_HUB_TAB:	
					fill_pub_hub_clist(TRUE);
					break;

		case RECENT_HUB_TAB:
					fill_recent_hub_clist();
					break;

		case SEEN_PUBLIC_HUB_TAB:
					fill_seen_hub_clist(TRUE);
					break;
	}
}


void
on_connect_entry_activate              (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("connect_entry");
	if(w!=NULL)
	{
		char *name;
		name=gtk_entry_get_text(GTK_ENTRY(w));

		if(name&&(strlen(name)>3))
			start_a_new_dctc(name,0,NULL);
	}
}


void
on_do_connection_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("connect_entry");
	if(w!=NULL)
	{
		char *name;
		name=gtk_entry_get_text(GTK_ENTRY(w));

		if(name&&(strlen(name)>3))
			start_a_new_dctc(name,0,NULL);
	}
}

/********************************************************/
/* convert all \n in \r except the last one (last byte) */
/********************************************************/
static void translate_char(GString *str,int start_pos)
{
	int i;

	for(i=start_pos;i<(str->len-1);i++)
	{
		if(str->str[i]=='\n')
			str->str[i]='\r';
	}
}


void
on_chat_input_activate                 (GtkEditable     *editable,
                                        gpointer         user_data)
{
#if 0
	GString *req;
	char *param;

	param=gtk_entry_get_text(GTK_ENTRY(editable));
	if(strlen(param)<1)
		return;

	/* convert filetype_entry into a number */
	req=g_string_new("/CHAT ");
	g_string_sprintfa(req,"%s",param);

	req=g_string_append_c(req,'\n');
	send_data_to_dctc(req->str);
	g_string_free(req,TRUE);
	return;
#else
	char *msg;
	msg=gtk_editable_get_chars(GTK_EDITABLE(editable),0,-1);
	if(strlen(msg)>0)
	{
		GString *req;

		req=g_string_new("/CHAT ");
		g_string_sprintfa(req,"%s\n",msg);
		translate_char(req,6);
		send_data_to_dctc(req->str);
		g_string_free(req,TRUE);
	}
	g_free(msg);
	gtk_editable_set_position(GTK_EDITABLE(editable),0);
	gtk_editable_delete_text(GTK_EDITABLE(editable),0,-1);
#endif
}


void
on_nickname_entry_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_e_mail_entry_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_user_description_entry_changed      (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_connect_notebook_switch_page        (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	if(page_num==RUNNING_HUB_TAB)
	{
		/* we enter the page of running process */
		fill_running_hub_clist();
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_show(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_show(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
	else if(page_num==PUBLIC_HUB_TAB)
	{	
		/* we enter the public hub list */
		fill_pub_hub_clist(FALSE);
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
		blink_off("connect_public_label");
	}
	else if(page_num==RECENT_HUB_TAB)
	{
		/* we enter the recent hub list */
		fill_recent_hub_clist();
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
	else if(page_num==FAVORITE_HUB_TAB)
	{
		gtk_widget_hide(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
	else if(page_num==SEEN_PUBLIC_HUB_TAB)
	{
		fill_seen_hub_clist(FALSE);
		gtk_widget_show(get_widget_by_widget_name("bookmark_button"));
		gtk_widget_hide(get_widget_by_widget_name("delete_selected_bookmark_button"));
		gtk_widget_show(get_widget_by_widget_name("start_dctc_selected_hub_button"));
		gtk_widget_hide(get_widget_by_widget_name("terminate_selected_dctcs_button"));
		gtk_widget_hide(get_widget_by_widget_name("kill_selected_dctcs_button"));
	}
}


/*********************************************************************/
/* this function is called when the user clicks on running_hub_clist */
/*********************************************************************/
gboolean
on_running_hub_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,1,&col))
					connect_to_a_running_dctc(col);
			}
		}
		return TRUE;
	}
	return FALSE;
}



gboolean
on_download_clist_key_press_event      (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_entry("/KILL","download_clist");
						break;
	}

  return FALSE;
}


gboolean
on_upload_clist_key_press_event        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_entry("/KILL","upload_clist");
						break;
	}

  return FALSE;
}


gboolean
on_queue_clist_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_entry("/KILLKBN","queue_clist");
						break;
	}
  return FALSE;
}


void
on_cancel_dl_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_entry("/KILL","download_clist");
}


void
on_cancel_ul_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_entry("/KILL","upload_clist");
}


void
on_unqueue_xfer_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_entry("/KILLKBN","queue_clist");
}


void
on_view_file_list_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	foreach_selected_entry_send_cmd("/LS","user_clist",UCC_NICK_COL);
}

void open_a_private_chat_with_selected_user_in_list(char *list_name, int nick_column_num)
{
	GtkWidget *w;
	char *nick;
	GList *glst;
	int row;
	GtkWidget *chat_text;
	char *pchat_label;
	int pchat_num;

	/* get the nickname of the remote side of the private chat */
	w=get_widget_by_widget_name(list_name);
	glst=GTK_CLIST(w)->selection;
	if(glst==NULL)
		return;			/* no one is selected */

	row=(int)(glst->data);
	/* wrong column for nickname: bug fixed by Tero Aaltonen */
	gtk_clist_get_text(GTK_CLIST(w),row,nick_column_num,&nick);
	if(nick==NULL)
		return;

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),PRIVATE_CHAT_TAB);		/* switch to private chat panel */

	chat_text=get_pchat_text_widget_from_nick(nick,TRUE,&pchat_label,&pchat_num);
	if(chat_text==NULL)
	{
		GString *out;
	
		out=g_string_new("");
	
		g_string_sprintfa(out,_("WARNING: all private chats are busy, close unused one.\nUnable to create a private chat for %s.\n"),nick);

		gnome_app_error(GNOME_APP(main_window),out->str);
		g_string_free(out,TRUE);
	}
}

void
on_open_private_chat_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	open_a_private_chat_with_selected_user_in_list("user_clist",UCC_NICK_COL);
}

void
on_user_file_list_clist_click_column   (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_user_file_list_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				USER_FILE_CL_ENTRY *selected_ent;

				selected_ent=gtk_clist_get_row_data(GTK_CLIST(widget),ret);
				if((selected_ent!=NULL)&&(selected_ent->entry_type==UFL_FILE_ENTRY))
				{
					USER_FILE_CL_ENTRY *nick_ent;
					nick_ent=get_nick_entry_for_user_file_list_from_ufce(GTK_CTREE(widget),selected_ent);
					if(nick_ent!=NULL)
					{
						GString *cm;
						cm=g_string_new("/DL |");											/* adapted to new /DL */
						g_string_sprintfa(cm,"%s||%s|%lu\n",nick_ent->c.nickname,selected_ent->c.file.filename,selected_ent->c.file.file_size);

						send_data_to_dctc(cm->str);
						g_string_free(cm,TRUE);
					}
				}
			}
		}
		return TRUE;
	}
	else if(event->button==3)
	{	/* right-click */
		build_start_dl_popup(USER_FILE_LIST_TAB);
		gtk_menu_popup(GTK_MENU(start_dl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}

static void wipe_gtk_text(char *widget_name)
{
	GtkWidget *w;

	w=get_widget_by_widget_name(widget_name);
	if(w==NULL)
		return;

	gtk_editable_set_position(GTK_EDITABLE(w),0);
	gtk_editable_delete_text(GTK_EDITABLE(w),0,-1);
}


void
on_close_pchat_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	GtkWidget *w;

	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		GtkWidget *lbl;

		i=gtk_notebook_get_current_page(GTK_NOTEBOOK(w));

		lbl=get_widget_by_widget_name(lbl_chat[i]);
		if(lbl!=NULL)
			gtk_label_set(GTK_LABEL(lbl),_("empty"));

		wipe_gtk_text(chat_text[i]);
	}
}

void
on_close_all_pchat_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	int i;
	for(i=0;i<9;i++)		/* there is 9 private chats */
	{
		GtkWidget *lbl;

		lbl=get_widget_by_widget_name(lbl_chat[i]);
		if(lbl!=NULL)
			gtk_label_set(GTK_LABEL(lbl),_("empty"));

		wipe_gtk_text(chat_text[i]);
		blink_off(lbl_chat[i]);
	}
}

void
on_pchat_entry_activate                (GtkEditable     *editable,
                                        gpointer         user_data)
{
	int i;
	GtkWidget *w;

	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		GtkWidget *lbl;

		i=gtk_notebook_get_current_page(GTK_NOTEBOOK(w));

		lbl=get_widget_by_widget_name(lbl_chat[i]);
		if(lbl!=NULL)
		{
			char *nick;
			gtk_label_get(GTK_LABEL(lbl),&nick);
			
			lbl=get_widget_by_widget_name("pchat_entry");
			if(lbl!=NULL)
			{
				GString *out;
				char *msg;

				msg=gtk_editable_get_chars(GTK_EDITABLE(lbl),0,-1);

				out=g_string_new("/PRIV ");
				g_string_sprintfa(out,"|%s|%s\n",nick,msg);
				translate_char(out,strlen(nick)+2+6);	/* translate the message */
				send_data_to_dctc(out->str);
				g_string_free(out,TRUE);

				g_free(msg);

				gtk_editable_set_position(GTK_EDITABLE(lbl),0);
				gtk_editable_delete_text(GTK_EDITABLE(lbl),0,-1);
			}
		}
	}
}

/*************************************************/
/* check if the given string is inside the array */
/*************************************************/
/* output: 1=yes, 0=no */
/***********************/
static int in_array(char *str,GPtrArray *array)
{
	int i;

	if(array==NULL)
		return 0;
	for(i=0;i<array->len;i++)
	{
		char *t;
		t=g_ptr_array_index(array,i);
		if(!strcmp(str,t))
			return 1;
	}
	return 0;
}

void
on_apply_pref_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	const char *var_var;
	const char *text_var;

	struct
	{
		char *widget_name;
		char *var_name;
		char *cmd_name;
	} lnk[]={{"user_description_entry","user_desc","/DESC "},
				{"cnx_type_entry","cnx_type","/CNX "},
				{"e_mail_entry","email","/EMAIL "},
				{"incoming_port_number_entry","com_port","/PORT "},
				{"xfer_host_ip_entry","hostip","/IP "},
				{"dl_dir_entry","dl_path","/LPATH "},
				{"unodeport_entry","unode_port","/UNODEPORT "},
				{"min_gdl_wake_up_delay_entry","min_gdl_wake_up_delay","/DFLAG min_gdl_wake_up_delay "},
				{"vshare_dir_entry","vshare_dir","/VSHARE "},
				{NULL,NULL,NULL}};
	int i;
	GString *out;
	gfloat nflt;
	char *t;
	const char *ct;

	if(current_dctc==NULL)
		gnome_app_error(GNOME_APP(main_window),_("You are not connected to a running DCTC,\nit is not necessary to press this button."));

	var_var=get_var("nickname");
	text_var=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("nickname_entry")));
	
	if(var_var&&text_var&&(strcmp(var_var,text_var)))
	{
		gnome_app_error(GNOME_APP(main_window),_("Due to a direct connect limitation, it is not\npossible to change your nickname on a running client."));
		
	}

	out=g_string_new("");
	i=0;

	/* first, the strings, easy */
	while(lnk[i].widget_name!=NULL)
	{
		var_var=get_var(lnk[i].var_name);
		text_var=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(lnk[i].widget_name)));
	
		if( (var_var&&text_var&&(strcmp(var_var,text_var))) ||
			 ((var_var==NULL)&&(text_var!=NULL)) ||
			 ((var_var!=NULL)&&(text_var==NULL)) 
			)
		{
			g_string_sprintf(out,"%s%s\n",lnk[i].cmd_name,text_var);
			send_data_to_dctc(out->str);
		}
		i++;
	}

	/* the #download slot slider */
	var_var=get_var("dl_slot");
	nflt=gtk_range_get_adjustment(GTK_RANGE(get_widget_by_widget_name("sim_dl_hscale")))->value;
	if(var_var==NULL)
		var_var="0";
	if(strtod(var_var,NULL)!=nflt)
	{
		g_string_sprintf(out,"/SLOT %u\n",(unsigned)nflt);
		send_data_to_dctc(out->str);
	}

	/* the reconnection delay slider */
	var_var=get_var("recon_delay");
	nflt=gtk_range_get_adjustment(GTK_RANGE(get_widget_by_widget_name("reconnect_delay_scale")))->value;
	if(var_var==NULL)
		var_var="0";
	if(strtod(var_var,NULL)!=nflt)
	{
		g_string_sprintf(out,"/RECOND %u\n",(unsigned)nflt);
		send_data_to_dctc(out->str);
	}

	/* the rebuild database delay slider */
	var_var=get_var("auto_rebuild_delay");
	nflt=gtk_range_get_adjustment(GTK_RANGE(get_widget_by_widget_name("rebuild_delay_scale")))->value;
	if(var_var==NULL)
		var_var="0";
	if(strtod(var_var,NULL)!=nflt)
	{
		g_string_sprintf(out,"/REBUILD %u\n",60*(unsigned)nflt);
		send_data_to_dctc(out->str);
	}

	{
		int i;
		struct
		{
			const char *toggle_widget_name;
			char *cmd_if_true;
			char *cmd_if_false;
		} tbl_toggled_cmd[]={
									{"active_mode_radio_button",		"/ACTIVE\n",		"/PASSIVE\n"}, 		/* the firewall flag */
									{"enable_upload_checkbutton",		"/DLON\n",			"/DLOFF\n"}, 			/* the dl flag */
									{"ddl_checkbutton",					"/DDL\n",			"/NODDL\n"},			/* the DDL flag */
									{"dctclink_checkbutton",			"/LINK\n",			"/NOLINK\n"},			/* the DCTCLINK flag */
									{"grabip_checkbutton",				"/GBANIP\n",		"/NOGBANIP\n"},		/* the GRABIP flag */
									{"use_done_dir_checkbutton",		"/DONE\n",			"/UNDONE\n"},			/* the when_done flag */
									{"follow_forcemove_checkbutton",	"/FOLLOWFORCE\n",	"/UNFOLLOWFORCE\n"},	/* the followforcemove flag */
									{"force_dl_checkbutton",			"/DLFORCE\n",		"/NODLFORCE\n"},		/* the force download flag */
									{"hide_abscheckbutton",				"/HIDE_ABS\n",		"/SHOW_ABS\n"},		/* the hide abs flag */
									{"abort_upload_checkbutton",		"/ABORTLEAVED\n",	"/NOABORTLEAVED\n"},	/* the abort upload flag */
									{"hide_kick_checkbutton",			"/HIDE_KICK\n",	"/SHOW_KICK\n"},		/* the hide kick message flag */
									{"lazykc_checkbutton",				"/LAZYKC\n",		"/NOLAZYKC\n"},		/* the lazy key check flag */
									{"incoming_wake_up_checkbutton",	"/DFLAG with_incoming_wake_up 1\n",		"/DFLAG with_incoming_wake_up 0\n"},/* the incoming wake up flag */
									{"sr_wake_up_checkbutton",			"/DFLAG with_sr_wake_up 1\n",				"/DFLAG with_sr_wake_up 0\n"},		/* the incoming wake up flag */
									{"dynipcheckbutton",					"/DFLAG dynamic_ip 1\n",					"/DFLAG dynamic_ip 0\n"},				/* the dynamic ip flag */
									{NULL,NULL,NULL}
									};

		i=0;
		while(tbl_toggled_cmd[i].toggle_widget_name!=NULL)
		{
			if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(tbl_toggled_cmd[i].toggle_widget_name)))==TRUE)
				send_data_to_dctc(tbl_toggled_cmd[i].cmd_if_true);
			else
				send_data_to_dctc(tbl_toggled_cmd[i].cmd_if_false);
			i++;
		}
	}

	/* set xbl values */
	{
		char buf[512];
		struct
		{
			char *cmd_name;
			char *check_widget;
			char *val_widget;
		} sema_bl[]={	{"/UBL","ubl_checkbutton","ubl_entry"},
							{"/DBL","dbl_checkbutton","dbl_entry"},
							{"/GBL","gbl_checkbutton","gbl_entry"},
							{NULL,NULL,NULL}};

		i=0;
		while(sema_bl[i].cmd_name!=NULL)
		{
			if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name(sema_bl[i].check_widget)))==FALSE)
			{
				sprintf(buf,"%s %d\n",sema_bl[i].cmd_name,SEMVMX);
			}
			else
			{
				sprintf(buf,"%s %s\n",sema_bl[i].cmd_name,gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name(sema_bl[i].val_widget))));
			}
			send_data_to_dctc(buf);

			i++;
		}
	}

	{
		char buf[512];
		sprintf(buf,"/MAXRUNGDLSRC %u\n",(unsigned int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("maxrunspinbutton"))));
		send_data_to_dctc(buf);
		sprintf(buf,"/GDLASOFFAFT %u\n",(unsigned int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("maxasoffspinbutton"))));
		send_data_to_dctc(buf);
		sprintf(buf,"/MAXUDL %u\n",(unsigned int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("maxudl_spinbutton"))));
		send_data_to_dctc(buf);
		sprintf(buf,"/DFLAG min_delay_between_search %u\n",(unsigned int)gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("min_delay_between_search_spinbutton"))));
		send_data_to_dctc(buf);
	}


	/* the shared files list. the harder. We must remove no more shared directories and add newly shared ones */
	{
		GStringChunk *sc;
		GPtrArray *local,*remote,*to_add,*to_remove;

		sc=g_string_chunk_new(128);
		local=g_ptr_array_new();
		remote=g_ptr_array_new();
		to_add=g_ptr_array_new();
		to_remove=g_ptr_array_new();

		/* fill the local array using shared_dir_clist */
		{
			GtkWidget *w;
			w=get_widget_by_widget_name("shared_dir_clist");
			if(w!=NULL)
			{
				GtkCList *clst;

				clst=GTK_CLIST(w);
				for(i=0;i<clst->rows;i++)
				{
					gtk_clist_get_text(clst,i,0,&t);
					if(t!=NULL)
					{
						g_ptr_array_add(local,g_string_chunk_insert(sc,t));
					}
				}
			}
		}

		/* fill the remote array using ul_path var */
		ct=get_var("ul_path");
		if(ct!=NULL)
		{
			char *dpl;
	
			dpl=strdup(ct);
			if(dpl)
			{
				char *cur;
				char *nxt;

				cur=strtok_r(dpl,"|",&nxt);
				while(cur!=NULL)
				{
					g_ptr_array_add(remote,g_string_chunk_insert(sc,cur));
					cur=strtok_r(NULL,"|",&nxt);
				}
				free(dpl);
			}
		}

		/* now, all strings of local which do not exist in remote are put into to_add */
		for(i=0;i<local->len;i++)
		{
			t=g_ptr_array_index(local,i);
			if(!in_array(t,remote))
			{
				g_ptr_array_add(to_add,t);
			}
		}

		/* and, all strings of remote which do not exist in all are put into to_remove */
		for(i=0;i<remote->len;i++)
		{
			t=g_ptr_array_index(remote,i);
			if(!in_array(t,local))
			{
				g_ptr_array_add(to_remove,t);
			}
		}

		/* send command to add new shared dir */
		for(i=0;i<to_add->len;i++)
		{
			t=g_ptr_array_index(to_add,i);
			g_string_sprintf(out,"/SHARE %s\n",t);
			send_data_to_dctc(out->str);
		}
		
		/* send command to remove shared dir */
		for(i=0;i<to_remove->len;i++)
		{
			t=g_ptr_array_index(to_remove,i);
			g_string_sprintf(out,"/UNSHARE %s\n",t);
			send_data_to_dctc(out->str);
		}
		
		/* it is not necessary to free string of to_add and to_remove because they are the same string */
		/* as in local and remote (same ptr) */
		g_ptr_array_free(local,TRUE);
		g_ptr_array_free(remote,TRUE);
		g_ptr_array_free(to_add,TRUE);
		g_ptr_array_free(to_remove,TRUE);
		g_string_chunk_free(sc);
	}

	/* and now, the offset */
	ct=get_var("offset");
	if(ct==NULL)
		ct="0";

	{
		double val;
		double scale[4]={1.0,1024.0, 1024.0*1024.0, 1024.0*1024.0*1024.0};
		char *unit_name[4]={_("Bytes"), _("KBytes"), _("MBytes"), _("GBytes")};
		int i=0;
		char buf[512];
		char *u;
		char *v;

		val=strtod(ct,NULL);

		while(i<3)
		{
			double res,ent;

			res=modf(val/scale[i+1],&ent);
			if(res!=0.0)
				break;
			i++;
		}
		sprintf(buf,"%.0f",val/scale[i]);

		u=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("size_offset_unit_entry")));
		v=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("size_offset_entry")));
		if((strcmp(u,unit_name[i]))||(strcmp(v,buf)))
		{
			for(i=0;i<4;i++)
			{
				if(!strcmp(u,unit_name[i]))
					break;
			}
			if(i==4)
				i=0;
			g_string_sprintf(out,"/OFFSET %f\n",strtod(v,NULL)*scale[i]);
			send_data_to_dctc(out->str);
		}
	}

	{
		g_string_sprintf(out,"/TOS %u,%u,%u,%u\n",
				tos_string_to_num(gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("hub_tos_entry")))),
				tos_string_to_num(gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("udp_tos_entry")))),
				tos_string_to_num(gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("dl_tos_entry")))),
				tos_string_to_num(gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("ul_tos_entry")))));

		send_data_to_dctc(out->str);
	}

	g_string_free(out,TRUE);

	send_data_to_dctc("/VARS\n");

	/* update periodic task rate */
	set_periodic_function_call_rate(&running_client_list_refresh_rate,&running_client_list_refresh_rate_gta,
												running_client_list_periodic_refresh,NULL,
												1000*gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("running_client_list_refresh_rate_spinbutton"))) );
	set_periodic_function_call_rate(&favorite_client_autostart_check_rate,&favorite_client_autostart_check_rate_gta,
												favorite_client_periodic_autostart,NULL,
												1000*gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(get_widget_by_widget_name("favorite_client_autostart_check_rate_spinbutton"))) );
}


void
on_reload_pref_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	fix_pref_window();						/* if there is no client */
	send_data_to_dctc("/VARS\n");			/* and also if there is a client */
}


void
on_dl_dir_select_ok_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	gchar *selected_filename;

	w=get_widget_by_widget_name("dl_dir_fileselection");

	selected_filename=gtk_file_selection_get_filename(GTK_FILE_SELECTION(w));
	if(selected_filename!=NULL)
	{
		char *path;

		path=strdup(selected_filename);
		if(path!=NULL)
		{
			struct stat st;

			/* verify if the given name is a valid directory */
			if(stat(path,&st)==-1)
			{
				err:
				gnome_app_error(GNOME_APP(main_window),_("invalid dir name"));
			}
			else
			{
				if(!S_ISDIR(st.st_mode))
				{	/* it exists but it is not a directory, remove the filename and retry */
					char *t;
					t=strrchr(path,'/');
					if(t==path)
						goto err;
					t[1]='\0';		/* keep the trailing / */

					if(stat(path,&st)==-1)
						goto err;
					if(!S_ISDIR(st.st_mode))
						goto err;
				}
				printf("'%s'\n",path);
				
				{
					GtkWidget *dl_dir_ent;

					dl_dir_ent=get_widget_by_widget_name("dl_dir_entry");
					if(dl_dir_ent!=NULL)
					{
						gtk_entry_set_text(GTK_ENTRY(dl_dir_ent),path);
					}
				}
			}
			free(path);
		}
	}
	widget_unlog(w);
	gtk_widget_destroy(w);
}


void
on_dl_dir_cancel_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("dl_dir_fileselection");
	widget_unlog(w);
	gtk_widget_destroy(w);
}


void
on_shared_dir_fs_ok_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	gchar *selected_filename;

	w=get_widget_by_widget_name("shared_dir_fileselection");

	selected_filename=gtk_file_selection_get_filename(GTK_FILE_SELECTION(w));
	if(selected_filename!=NULL)
	{
		char *path;

		path=strdup(selected_filename);
		if(path!=NULL)
		{
			struct stat st;

			/* verify if the given name is a valid directory */
			if(stat(path,&st)==-1)
			{
				err:
				gnome_app_error(GNOME_APP(main_window),_("invalid dir name"));
			}
			else
			{
				GtkWidget *clst;

				if(!S_ISDIR(st.st_mode))
				{	/* it exists but it is not a directory, remove the filename and retry */
					char *t;
					t=strrchr(path,'/');
					if(t==path)
						goto err;
					t[1]='\0';		/* keep the trailing / */

					if(stat(path,&st)==-1)
						goto err;
					if(!S_ISDIR(st.st_mode))
						goto err;
				}
				
				clst=get_widget_by_widget_name("shared_dir_clist");
				if(clst!=NULL)
				{
					gtk_clist_append(GTK_CLIST(clst),&path);
				}
			}
			free(path);
		}
	}
}


void
on_shared_dir_fs_cancel_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GString *str;
	GtkCList *clst;
	int i;

	w=get_widget_by_widget_name("shared_dir_fileselection");
	widget_unlog(w);
	gtk_widget_destroy(w);

	str=g_string_new("");
	w=get_widget_by_widget_name("shared_dir_clist");
	clst=GTK_CLIST(w);
	for(i=0;i<clst->rows;i++)
	{
		char *t=NULL;

		gtk_clist_get_text(clst,i,0,&t);
		if(t!=NULL)
		{
			if(str->len!=0)
				str=g_string_append_c(str,'|');
		
			str=g_string_append(str,t);
		}
	}

	w=get_widget_by_widget_name("hidden_shared_dir_entry");
	if(w!=NULL)
	{
		gtk_entry_set_text(GTK_ENTRY(w),str->str);
	}
	g_string_free(str,TRUE);
}

/*****************************************************************************/
/* this function add generate a "cmd user" from the given user_file_cl_entry */
/*****************************************************************************/
/* cmd is a GString "" and it must be restored to this at the end */
/******************************************************************/
static void do_dl_from_user_file_list(GtkCTree *ctree,USER_FILE_CL_ENTRY *fce, void *cmd)
{
	int ln;
	GString *dl=cmd;
	USER_FILE_CL_ENTRY *nick_ent;

	if(fce->entry_type!=UFL_FILE_ENTRY)
		return;

	nick_ent=get_nick_entry_for_user_file_list_from_ufce(ctree,fce);
	if(nick_ent==NULL)
		return;
	
	ln=dl->len;

	g_string_sprintf(dl,"/DL |%s||%s|%lu\n",nick_ent->c.nickname,fce->c.file.filename,fce->c.file.file_size);
	send_data_to_dctc(dl->str);

	g_string_truncate(dl,ln);		/* restore original string lenght */
}

static void start_download_from_user_file_list_ctree(void)
{
	GString *dl;
	dl=g_string_new("");

	generic_selected_user_file_list_calls(do_dl_from_user_file_list,dl);
	g_string_free(dl,TRUE);
}


void
on_download_selected_files1_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					start_download_from_find_result_clist();
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					start_download_from_user_file_list_ctree();
					break;

		default:
					break;
	}
}


void
on_unselect_files1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					w=get_widget_by_widget_name("find_result");
					break;

		case USER_FILE_LIST_TAB:	/* user file list */
					w=get_widget_by_widget_name("user_file_list_clist");
					break;

		default:
					w=NULL;
					break;
	}

	if(w!=NULL)
		gtk_clist_unselect_all(GTK_CLIST(w));
}

/************************************************************************/
/* this function add generate a "cmd user" from the given find_cl_entry */
/************************************************************************/
/* cmd is a GString "" and it must be restored to this at the end */
/******************************************************************/
static void do_dl_from_find_result(FIND_CL_ENTRY *fce, void *cmd)
{
	int ln;
	GString *dl=cmd;

	ln=dl->len;

	g_string_sprintf(dl,"/DL |%s|%s|%s|%lu\n",fce->nickname,"",fce->filename,fce->file_size);
	send_data_to_dctc(dl->str);

	g_string_truncate(dl,ln);		/* restore original string lenght */
}

static void start_download_from_find_result_clist(void)
{
	GString *dl;
	dl=g_string_new("");

	generic_selected_find_result_calls(do_dl_from_find_result,dl);
	g_string_free(dl,TRUE);
}


gboolean
on_find_result_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						start_download_from_find_result_clist();
						break;
	}


  return FALSE;
}


gboolean
on_user_file_list_clist_key_press_event
                                        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	static char strbuf[256] = { 0 };
	static GString search_string;
	static time_t last_key = 0;
	gint cur_row, num_rows;
	gchar *keyname;
	
	if(event==NULL)
		return FALSE;

	search_string.str = strbuf;
	search_string.len = 0;

	switch(event->keyval)
	{
		case GDK_Return:
			start_download_from_user_file_list_ctree();
			break;

		case GDK_Left:
		case GDK_Right:
		case GDK_Up:
		case GDK_Down:
		case GDK_Escape:
			strbuf[0] = 0;
			search_string.len = 0;
			break;

		default:
			/* Reset search-string if we waited more than 3 seconds between keypresses. */
			if (time (NULL) - last_key > 3)
			{
				strbuf[0] = 0;
				search_string.len = 0;
			}

			last_key = time (NULL);

			keyname = gdk_keyval_name (gdk_keyval_to_lower (event->keyval));
			if (keyname && strlen (keyname) != 1)
				break;
			else
			{
				strncat (strbuf, keyname, 255);
				search_string.len = strlen (strbuf);
			}

			/* Where are we in the CList? */
			cur_row = GPOINTER_TO_INT (GTK_CLIST (widget)->selection->data);

			/* And how many rows are there? */
			num_rows = GTK_CLIST (widget)->rows;

			/* Find the filename. */
			while (cur_row < num_rows)
			{
				USER_FILE_CL_ENTRY *ufce;
				char *filename=NULL;

				ufce=gtk_clist_get_row_data(GTK_CLIST(widget), cur_row);
				switch(ufce->entry_type)
				{
					case UFL_NICK_ROOT_ENTRY:	filename=NULL;break;
					case UFL_DIR_ENTRY:			filename=ufce->c.dir_name;break;
					case UFL_FILE_ENTRY:			filename=ufce->c.file.filename;break;
				}
	/* initialize search_string GString */
				if (filename)
				{
					if (my_strcasestr (&search_string, filename))
					{
						gtk_clist_unselect_all (GTK_CLIST (widget));
						gtk_clist_moveto (GTK_CLIST (widget), cur_row, 0, 0.2, 0.0);
						gtk_clist_select_row (GTK_CLIST (widget), cur_row, 0);
						GTK_CLIST (widget)->focus_row = cur_row;
						break;
					}
				}

				cur_row++;
			}
			break;
	}

  return FALSE;
}


void
on_clear_global_list_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GString *str;

	str=g_string_new(dctc_dir->str);
	g_string_sprintfa(str,"/done+exited");
	unlink(str->str);										/* erase global list */

	str=g_string_assign(str,dctc_dir->str);
	if(strlen(last_known_running_dctc_name))
	{
		g_string_sprintfa(str,"/%s.done",last_known_running_dctc_name);
	}	/* if the last_kn... is empty, load_done_xfer will fail but it has cleared the list */
	load_done_xfer(str->str,1);
	g_string_free(str,TRUE);
}


void
on_clear_local_list_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GString *str;

	str=g_string_new(dctc_dir->str);

	if(strlen(last_known_running_dctc_name))
	{
		g_string_sprintfa(str,"/%s.done",last_known_running_dctc_name);
		unlink(str->str);										/* erase global list */
	}

	str=g_string_assign(str,dctc_dir->str);
	g_string_sprintfa(str,"/done+exited");
	load_done_xfer(str->str,1);
	g_string_free(str,TRUE);
}


void
on_clear_user_file_list_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("user_file_list_clist");
	if(w!=NULL)
	{
		gtk_clist_clear(GTK_CLIST(w));
	}
}


void
on_clear_recent_list_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GString *s;
	char *path;

	s=g_string_new(NULL);
	path=getenv("HOME");
	g_string_sprintf(s,"%s/.dctc/recent",(path!=NULL)?path:".");
	unlink(s->str);
	g_string_free(s,TRUE);
	fill_recent_hub_clist();
}


void
on_away_togglebutton_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("away_togglebutton");
	if(w!=NULL)
	{
		if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))==TRUE)
			send_data_to_dctc("/AWAY\n");
		else
			send_data_to_dctc("/HERE\n");
	}
}

/****************************************************************************************/
/* load the 'cached_user_list_clist' with the content of the directory ~/.dctc/ls_cache */
/******************************************************************************************/
/* input: if the flag is set to FALSE and the list already contains line, nothing is done */
/******************************************************************************************/
static void reload_ls_cache_clist(int even_when_not_empty)
{
	GtkWidget *w;
	GtkCList *clst;
	gchar *ls_path;
	DIR *dir;

	w=get_widget_by_widget_name("cached_user_list_clist");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

	if((even_when_not_empty==FALSE)&&(clst->rows!=0))
		return;

	gtk_clist_freeze(clst);
	gtk_clist_clear(clst);

	ls_path=g_strconcat(dctc_main_dir->str,"/ls_cache",NULL);
	dir=opendir(ls_path);
	if(dir!=NULL)
	{
		GString *full_path;
		struct dirent *obj;
		LS_CACHE_HEADER lsch;

		full_path=g_string_new("");
		while((obj=readdir(dir))!=NULL)
		{
			if(obj->d_name[0]=='.')
				continue;

			g_string_sprintf(full_path,"%s/%s",ls_path,obj->d_name);

			if(get_ls_file_header(full_path->str,&lsch)==0)
			{
				char *nw[3];
				char buf[128];
				char dl_time[256];
				int num_row;
				LS_CACHE_CL_ENTRY *lcce;

				strftime(dl_time,sizeof(dl_time)-1,"%c",localtime(&(lsch.retrieve_time)));
#ifndef NO_PRINTF_LOCALE
				sprintf(buf,"%'llu", lsch.share_size);		/* NO_PRINTF_LOCAL support added */
#else
				sprintf(buf,"%llu", lsch.share_size);
#endif
				
				nw[0]=obj->d_name;
				nw[1]=buf;
				nw[2]=dl_time;
	
				lcce=new_ls_cache_cl_entry(obj->d_name,lsch.share_size,lsch.retrieve_time);
				num_row=gtk_clist_append(clst,nw);
				gtk_clist_set_row_data_full(clst,num_row,lcce,(void*)free_ls_cache_cl_entry);
			}
		}
		g_string_free(full_path,TRUE);
		closedir(dir);
	}
	g_free(ls_path);
	
	gtk_clist_sort(clst);
	gtk_clist_thaw(clst);
}

void
on_main_notebook_switch_page           (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	switch(page_num)
	{
		case CONNECT_TAB:
					blink_off("connect_page");
					break;

		case PRIVATE_CHAT_TAB:
					blink_off("private_chat_page");
					break;

		case USER_FILE_LIST_TAB:
					blink_off("user_file_list_page");
					reload_ls_cache_clist(FALSE);
					break;

		case FLAGGED_USER_TAB:
					reload_flagged_user_clist(1);
					break;

		case UADDR_TAB:
					reload_unode_clist(1);
					break;
	}
}


void
on_kick_user_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_enter_a_password_menu_entry_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if(current_dctc!=NULL)
	{	/* connected to something */
		enter_passwd_fnc(NULL);
	}
}

/*********************************************************************/
/* this function generates a "cmd user" from the given find_cl_entry */
/*********************************************************************/
static void do_user_command_from_find_result(FIND_CL_ENTRY *fce, void *cmd)
{
	char buf[512];

	if(fce->nickname)
	{
		sprintf(buf,"%s %s\n",(char*)cmd,fce->nickname);
		send_data_to_dctc(buf);
	}
}

void
on_get_file_list_of_selected_users1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	int nick_column;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					generic_selected_find_result_calls(do_user_command_from_find_result,"/LS");
					return;

#if 0
		/* unuseful */
		case USER_FILE_LIST_TAB:	/* user file list */
					generic_selected_user_file_list_calls(do_user_command_from_user_file_list,"/LS");
					return;
#endif

		default:
					w=NULL;
					nick_column=-1;
					break;
	}

	if(w!=NULL)
	{
		/* foreach selected row, a /LS nickname is sent */
		GtkCList *clist;
		GtkCListRow *clist_row;
		int row;

		clist=GTK_CLIST(w);

		for(row=0;row<clist->rows;row++)
		{
			clist_row=g_list_nth(clist->row_list,row)->data;

			if(clist_row->state==GTK_STATE_SELECTED)
			{
				char *t;
				char buf[512];

				gtk_clist_get_text(clist,row,nick_column,&t);

				sprintf(buf,"/LS %s\n",t);
				send_data_to_dctc(buf);
			}
		}
	}
}


void
on_contact_selected_running_client1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_kill_selected_unning_clients1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

/*******************************************************************/
/* check if the given string contains only alphanumeric characters */
/*******************************************************************/
/* output: 1=yes, 0=no */
/***********************/
static int is_all_alnum(const char *str)
{
	if(str==NULL)
		return 0;

	while(*str!='\0')
	{
		if(!isalnum(*str))
			return 0;
		str++;
	}
	return 1;
}

void
on_save_default_profile_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	char *profile_name;

	w=get_widget_by_widget_name("profile_name_combo_entry");
	if(w==NULL)
		return;

	profile_name=gtk_editable_get_chars(GTK_EDITABLE(w),0,-1);
	if((profile_name==NULL)||(strlen(profile_name)==0))
	{
		gnome_app_error(GNOME_APP(main_window),"You must give profile name first");
	}
	else
	{
		if(is_all_alnum(profile_name))
		{
			gchar *pname;

			pname=g_strconcat("Profile.",profile_name,".",NULL);
			gui_full_save(get_widget_by_widget_name("user_pref_notebook"),pname);
			g_free(pname);

			pname=g_strconcat("/" PROGNAME "/ProfileNames/",profile_name,NULL);
			gnome_config_set_string(pname,"User Profile");
			g_free(pname);

			gnome_config_sync();
	
			load_profile_name_combo();
		}
		else
		{
			gnome_app_error(GNOME_APP(main_window),"Invalid profile name, only alphanumeric characters allowed");
		}
	}
}

static void refresh_share_clist_from_hidden_share_entry(void)
{
	GtkWidget *w;
	char *shared;

	w=get_widget_by_widget_name("hidden_shared_dir_entry");
	if(w!=NULL)
	{
		shared=gtk_entry_get_text(GTK_ENTRY(w));
		w=get_widget_by_widget_name("shared_dir_clist");
		if(w!=NULL)
		{
			GtkCList *clst;
			gchar **val;
			int i;

			clst=GTK_CLIST(w);
			gtk_clist_freeze(clst);
			gtk_clist_clear(clst);
			val=g_strsplit(shared,"|",0);
			if(val!=NULL)
			{
				i=0;
				while(val[i]!=NULL)
				{
					gtk_clist_append(clst,&val[i]);
					i++;
				}
				g_strfreev(val);
			}
			gtk_clist_sort(clst);
			gtk_clist_thaw(clst);
		}
	}
}

void
on_load_default_profil_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	char *profile_name;

	w=get_widget_by_widget_name("profile_name_combo_entry");
	if(w==NULL)
		return;

	profile_name=gtk_editable_get_chars(GTK_EDITABLE(w),0,-1);
	if((profile_name==NULL)||(strlen(profile_name)==0))
	{
		gnome_app_error(GNOME_APP(main_window),"You must give profile name first");
	}
	else
	{
		if(is_all_alnum(profile_name))
		{
			gchar *pname;
			char *pval;

			pname=g_strconcat("/" PROGNAME "/ProfileNames/",profile_name,NULL);
			pval=gnome_config_get_string(pname);
			g_free(pname);

			if(pval==NULL)
			{
				gnome_app_error(GNOME_APP(main_window),"No profile has this name, give another one");
			}
			else
			{
				pname=g_strconcat("Profile.",profile_name,".",NULL);
				gui_full_restore(get_widget_by_widget_name("user_pref_notebook"),pname);
				g_free(pname);
				refresh_share_clist_from_hidden_share_entry();
			}
		}
		else
		{
			gnome_app_error(GNOME_APP(main_window),"Invalid profile name, only alphanumeric characters allowed");
		}
	}
}


void
on_gdl_ctree_click_column              (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	/* code from ctree_click_column of testgtk.c */
	if (column == clist->sort_column)
	{
		if (clist->sort_type == GTK_SORT_ASCENDING)
			clist->sort_type = GTK_SORT_DESCENDING;
		else
			clist->sort_type = GTK_SORT_ASCENDING;
	}
	else
		gtk_clist_set_sort_column (clist, column);

	gtk_ctree_sort_recursive (GTK_CTREE(clist), NULL);
}


gboolean
on_gdl_ctree_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		build_gdl_popup();
		gtk_menu_popup(GTK_MENU(gdl_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
}


gboolean
on_gdl_ctree_key_press_event           (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_d:	/* 'd' pressed */
		case GDK_D:
						kill_selected_gdl_entry();
						break;
	}

	return FALSE;
}


void
on_cancel_gdl_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	kill_selected_gdl_entry();
}


void
on_do_reconnect_now_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	send_data_to_dctc("/RECON\n");
}


static void go_to_another_hub_clist_selected(char *clist_name, int address_column)
{
	GtkWidget *w;

	w=get_widget_by_widget_name(clist_name);
	if(w!=NULL)
	{
		GtkCList *clist;
		
		clist=GTK_CLIST(w);
		if(clist->selection)
		{
			gint row;
			gchar *name;

			row=GPOINTER_TO_INT (clist->selection->data);

			if(gtk_clist_get_text(clist,row,address_column,&name))
			{
				if(name&&(strlen(name)>3))		/* if a valid name exist, use it */
					go_to_another_hub(name);
			}
		}
	}
}

void
on_do_goto_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("connect_entry");
	if(w!=NULL)
	{
		char *name;
		name=gtk_entry_get_text(GTK_ENTRY(w));

		if(name&&(strlen(name)>3))		/* if a valid name exist, use it */
			go_to_another_hub(name);
		else
		{
			/* else use the selected site in the currently visible hub list */
			switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
			{
				case RUNNING_HUB_TAB:
							go_to_another_hub_clist_selected("running_hub_clist",0);
							break;
		
				case PUBLIC_HUB_TAB:	
							go_to_another_hub_clist_selected("hub_public_clist",3);
							break;

				case RECENT_HUB_TAB:
							go_to_another_hub_clist_selected("hub_recent_clist",3);
							break;

				case SEEN_PUBLIC_HUB_TAB:
							go_to_another_hub_clist_selected("seen_hub_clist",3);
							break;
			}
		}
	}
}


void
on_dctc_cmd_entry_activate             (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GString *str;
	char *param;

	param=gtk_entry_get_text(GTK_ENTRY(editable));
	if(strlen(param)<1)
		return;

	str=g_string_new(param);
	if(str->str[str->len-1]!='\n')
	{
		str=g_string_append_c(str,'\n');
	}

	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


void
on_stop_and_detach1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	detach_selected_gdl_entry();
}


void
on_attach_autoscan_pattern_to_selected_gdl1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	create_autoscan_window_for_selected_gdl_entry();
}


void
on_add_as_to_gdl_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2,*w3;
	gchar *gid;
	char *pattern;
	unsigned int ftype;
	GString *str;

	w1=get_widget_by_widget_name("as_gid_label");
	w2=get_widget_by_widget_name("as_fname_label");
	w3=get_widget_by_widget_name("gdl_as_pattern_entry");

	if((w1==NULL)||(w2==NULL)||(w3==NULL))
		return;

	gtk_label_get(GTK_LABEL(w1),&gid);
	if(strlen(gid)==0)
		return;

	pattern=gtk_entry_get_text(GTK_ENTRY(w3));
	if(strlen(pattern)==0)
		return;

	ftype=gtk_entry_to_number("gdl_as_filetype_entry",ftype_str);

	str=g_string_new("");
	g_string_sprintf(str,"/GDLAS+ %s|%u|%s\n",gid,ftype+1,pattern);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


void
on_add_new_uaddr_full_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	char *nick,*addr;
	GString *str;

	w1=get_widget_by_widget_name("uaddr_nick_entry");
	w2=get_widget_by_widget_name("uaddr_hostipport_entry");

	if((w1==NULL)||(w2==NULL))
		return;

	nick=gtk_entry_get_text(GTK_ENTRY(w1));
	if(strlen(nick)==0)
		return;

	addr=gtk_entry_get_text(GTK_ENTRY(w2));
	if(strlen(addr)==0)
		return;

	str=g_string_new("");
	if(strchr(addr,':')!=NULL)
		g_string_sprintf(str,"/UADDRUADD %s|%s\n",nick,addr);
	else
		g_string_sprintf(str,"/UADDRUADD %s|%s:412\n",nick,addr);

	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);

	send_data_to_dctc("/UADDRLST\n");
}


void
on_add_new_uaddr_host_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w2;
	char *addr;
	GString *str;

	w2=get_widget_by_widget_name("uaddr_hostipport_entry");

	if(w2==NULL)
		return;

	addr=gtk_entry_get_text(GTK_ENTRY(w2));
	if(strlen(addr)==0)
		return;

	str=g_string_new("");
	if(strchr(addr,':')!=NULL)
		g_string_sprintf(str,"/UADDRIPADD %s\n",addr);
	else
		g_string_sprintf(str,"/UADDRIPADD %s:412\n",addr);

	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);

	send_data_to_dctc("/UADDRLST\n");
}


void
on_uaddr_view_file_list_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;
	char buf[512];

	w=get_widget_by_widget_name("uaddr_clist");
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick;

			gtk_clist_get_text(clist,row,0,&nick);

			if((nick!=NULL)&&(strlen(nick)!=0))
			{
				sprintf(buf,"/LS %s\n",nick);
				send_data_to_dctc(buf);
			}
		}
	}
}


void
on_delete_uaddr_entries_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;
	char buf[512];

	w=get_widget_by_widget_name("uaddr_clist");
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *nick;
			char *ipport;

			gtk_clist_get_text(clist,row,0,&nick);
			gtk_clist_get_text(clist,row,1,&ipport);

			if((nick==NULL)||(strlen(nick)==0))
			{
				sprintf(buf,"/UADDRIPDEL %s\n",ipport);
			}
			else
			{
				sprintf(buf,"/UADDRUDEL %s\n",nick);
			}
			send_data_to_dctc(buf);
		}
	}

	send_data_to_dctc("/UADDRLST\n");
}


void
on_refresh_uaddr_list_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	send_data_to_dctc("/UADDRLST\n");
}


gboolean
on_uaddr_clist_button_press_event      (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

	if(event==NULL)
		return TRUE;

	if(event->window!=GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==3)
	{	/* right-click */
		gtk_menu_popup(GTK_MENU(uaddr_popup),NULL,NULL,NULL,NULL,event->button,event->time);
		return TRUE;
	}

  return FALSE;
  return FALSE;
}

/************************************************************************/
/* check if the given pattern exists inside filename (case insensitive) */
/************************************************************************/
/* output: address of the pattern or NULL */
/******************************************/
char *my_strcasestr(GString *pattern, char *filename)
{
	int max_pos;
	int i;

	max_pos=strlen(filename)-pattern->len;
	if(max_pos<0)				  /* filename length < pattern length ? */
		return NULL;				/* no match */

	for(i=0;i<=max_pos;i++)
	{
		if(!strncasecmp(pattern->str,filename+i,pattern->len))
			return filename+i;
	}

	return NULL;					/* no match */
}


void
on_find_uaddr_by_nick_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	char *nick;
	GtkCList *clst;
	int first_row=-1;
	int row;
	GString *nck;

	w1=get_widget_by_widget_name("uaddr_nick_entry");
	w2=get_widget_by_widget_name("uaddr_clist");

	if((w1==NULL)||(w2==NULL))
		return;

	nick=gtk_entry_get_text(GTK_ENTRY(w1));
	if(strlen(nick)==0)
		return;

	nck=g_string_new(nick);
	clst=GTK_CLIST(w2);
	gtk_clist_freeze(clst);
	gtk_clist_unselect_all(clst);

	/* select all rows matching the given nickname */
	for(row=0;row<clst->rows;row++)
	{
		char *t;

		gtk_clist_get_text(clst,row,0,&t);

		if((t!=NULL)&&(my_strcasestr(nck,t)!=NULL))
		{	/* we have found a row containing a similar nickname */
			gtk_clist_select_row(clst,row,0);
			if(first_row==-1)
				first_row=row;
		}
	}

	gtk_clist_thaw(clst);
	if(first_row!=-1)
	{
		gtk_clist_moveto(clst,first_row,0,0,0);
	}
	g_string_free(nck,TRUE);
}

void
on_find_uaddr_by_addr_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	char *ip;
	GtkCList *clst;
	int first_row=-1;
	int row;
	int len_ip;

	w1=get_widget_by_widget_name("uaddr_hostipport_entry");
	w2=get_widget_by_widget_name("uaddr_clist");

	if((w1==NULL)||(w2==NULL))
		return;

	ip=gtk_entry_get_text(GTK_ENTRY(w1));
	if((len_ip=strlen(ip))==0)
		return;

	clst=GTK_CLIST(w2);
	gtk_clist_freeze(clst);
	gtk_clist_unselect_all(clst);

	/* select all rows matching the given ip */
	for(row=0;row<clst->rows;row++)
	{
		char *t;

		gtk_clist_get_text(clst,row,1,&t);

		if((t!=NULL)&&(!strncmp(ip,t,len_ip)))
		{	/* we have found a row containing a similar ip */
			gtk_clist_select_row(clst,row,1);
			if(first_row==-1)
				first_row=row;
		}
	}

	gtk_clist_thaw(clst);
	if(first_row!=-1)
	{
		/* move the first selected row into the visible area */
		gtk_clist_moveto(clst,first_row,0,0,0);
	}
}


void
on_unselect_uaddr_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("uaddr_clist");
	if(w==NULL)
		return;
	gtk_clist_unselect_all(GTK_CLIST(w));
}



gboolean
on_hub_favorite_clist_key_press_event  (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

  return FALSE;
}

/***********************************************************************/
/* add the selected entries of the given clist to the bookmark address */
/***********************************************************************/
static void add_bm_entries(char *clist_name,int hubname_col,int description_col, int address_col)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			char *hubname;
			char *description;
			char *address;

			if(hubname_col!=-1)
			{
				gtk_clist_get_text(clst,row,hubname_col,&hubname);
				if((hubname==NULL)||(strlen(hubname)==0))
					hubname="No name";
			}
			else
				hubname="No name";

			if(description_col!=-1)
			{
				gtk_clist_get_text(clst,row,description_col,&description);
				if((description==NULL)||(strlen(description)==0))
					description="No description";
			}
			else
				description="No description";

			if(address_col!=-1)
			{
				gtk_clist_get_text(clst,row,address_col,&address);
				if((address==NULL)||(strlen(address)==0))
					address="No address";
			}
			else
				address="No address";

			add_entry_to_bookmark(-1,hubname,description,address,NULL,NULL,1);		/* add without reload */
		}
	}

	reload_bookmark();
}

void
on_bookmark_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
	{
		case RUNNING_HUB_TAB:
					add_bm_entries("running_hub_clist",2,-1,0);
					break;
		
		case PUBLIC_HUB_TAB:	
					add_bm_entries("hub_public_clist",0,2,3);
					break;

		case RECENT_HUB_TAB:
					add_bm_entries("hub_recent_clist",0,2,3);
					break;

		case SEEN_PUBLIC_HUB_TAB:	
					add_bm_entries("seen_hub_clist",0,2,3);
					break;
	}
}


void
on_delete_selected_bookmark_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name("hub_favorite_clist");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			gpointer data;

			data=gtk_clist_get_row_data(clst,row);

			delete_entry_from_bookmark_by_id(GPOINTER_TO_INT(data),1);		/* add without reload */
		}
	}

	reload_bookmark();
}


void
on_chat_notebook_switch_page           (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data)
{
	blink_off(lbl_chat[page_num]);
}


void
on_start_dctc_selected_hub_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	const char *clist_name;
	int col_num;
	int prof_num;
	int row;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
	{
		case FAVORITE_HUB_TAB:
					clist_name="hub_favorite_clist";
					col_num=2;
					prof_num=3;
					break;
		
		case PUBLIC_HUB_TAB:	
					clist_name="hub_public_clist";
					col_num=3;
					prof_num=-1;
					break;

		case RECENT_HUB_TAB:
					clist_name="hub_recent_clist";
					col_num=3;
					prof_num=-1;
					break;

		case SEEN_PUBLIC_HUB_TAB:	
					clist_name="seen_hub_clist";
					col_num=3;
					prof_num=-1;
					break;

		default:
					return;
	}

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			char *address;
			char *profile_name;

			gtk_clist_get_text(clst,row,col_num,&address);
			if(prof_num!=-1)
				gtk_clist_get_text(clst,row,prof_num,&profile_name);
			else
				profile_name=NULL;
			
			if((address!=NULL)&&(strlen(address)!=0))
			{
				if((profile_name==NULL)||(strlen(profile_name)==0))
					start_a_new_dctc(address,1,NULL);		/* start without waiting */
				else
					start_a_new_dctc(address,1,profile_name);	/* start without waiting */
			}
		}
	}
}


void
on_seen_hub_clist_click_column         (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_seen_hub_clist_button_press_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,3,&col))
					start_a_new_dctc(col,0,NULL);
			}
		}
		return TRUE;
	}

  return FALSE;
}


void
on_expand_all_gdl_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_expand_all_ctree(menuitem,"gdl_ctree");
}


void
on_shrink_all_gdl_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	on_shrink_all_ctree(menuitem,"gdl_ctree");
}

void
on_clear_globalchat_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	wipe_gtk_text("chat_output");
}

void
on_clear_private_chat_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		wipe_gtk_text(chat_text[gtk_notebook_get_current_page(GTK_NOTEBOOK(w))]);
	}
}


static struct
			{
				const char *widget_name;
				const char *option_name;
				const char *autoflag_widget_name;
			} opt_list[]={
								{"user_flag_ignore_pmsg_togglebutton","IGNORE_PMSG","autoflag_user_flag_ignore_pmsg_togglebutton"},
								{"user_flag_ignore_pubmsg_togglebutton","IGNORE_PUBMSG","autoflag_user_flag_ignore_pubmsg_togglebutton"},
								{"user_flag_ignore_srch_togglebutton","IGNORE_SRCH","autoflag_user_flag_ignore_srch_togglebutton"},
								{"user_flag_ignore_sr_togglebutton","IGNORE_SREP","autoflag_user_flag_ignore_sr_togglebutton"},
								{"user_flag_no_xfer_togglebutton","IGNORE_XFER","autoflag_user_flag_no_xfer_togglebutton"},
								{"user_flag_ignore_dl_limit_togglebutton","IGNORE_SLOT_LIMIT","autoflag_user_flag_ignore_dl_limit_togglebutton"},
								{NULL,NULL}};


/**************************************************************************/
/* update the given nickname in flagged user list (this includes removal) */
/**************************************************************************/
static void update_flag_user_list1(char *nickname)
{
	char *data_val=NULL;
	int data_len=0;
	int ret;
	int row;
	GtkWidget *w;
	char buf[8192];

	w=get_widget_by_widget_name("flagged_user_clist");
	if(w==NULL)
		return;
		
	ret=get_key_data(unwanted_user,nickname,strlen(nickname),(void*)&data_val,&data_len);

	/* find the row of this user */
	row=row_num(GTK_CLIST(w),0,nickname);

	if(ret!=0)
	{
		/* user not found, delete its row */
		gtk_clist_remove(GTK_CLIST(w),row);
	}
	else
	{	/* user found, add/update its row */
		strncpy_max(buf,data_val,MIN(data_len+1,sizeof(buf)));
		
		if(row!=-1)
			gtk_clist_set_text(GTK_CLIST(w),row,1,buf);
		else
		{
			char *nw[2];
			nw[0]=nickname;
			nw[1]=buf;
			gtk_clist_append(GTK_CLIST(w),nw);
			gtk_clist_sort(GTK_CLIST(w));
		}

		if(data_val!=NULL)
			free(data_val);
	}
}

/************************************************************/
/* check if the given flag list contains the following flag */
/************************************************************/
/* output: 1= yes, the flag is here */
/*         0= no                    */
/************************************/
int flag_in_flag_list(char *data_val,const char *flag)
{
	int data_len;
	int ret;
	char *pos;
	int flag_len;

	ret=0;
	data_len=strlen(data_val);
	flag_len=strlen(flag);
	pos=data_val;

	while(flag_len<data_len)
	{
		if(!strncmp(flag,pos,flag_len))
		{  /* the beginning of flag match */
			if(pos[flag_len]=='|')	  /* and the current flag immediatly ends with a pipe */
			{
				ret=1;
				break;
			}
		}
		pos++;
		data_len--;
	}

	/* check the last flag if not yet found, last chance */
	if((ret==0)&&(flag_len==data_len))
	{
		if(!strncmp(flag,pos,flag_len))
			ret=1;
	}

	return ret;
}

void
on_flagged_user_clist_select_row       (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_label");
	if(w)
	{
		char *t;

		gtk_clist_get_text(clist,row,0,&t);
		if((t!=NULL)&&(strlen(t)))
		{
			char *flag_list;
			int i=0;

			gtk_label_set(GTK_LABEL(w),t);

			gtk_clist_get_text(clist,row,1,&flag_list);

			while(opt_list[i].widget_name!=NULL)
			{
				w=get_widget_by_widget_name(opt_list[i].widget_name);
				if(w!=NULL)
				{
					if(flag_in_flag_list(flag_list,opt_list[i].option_name))
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),TRUE);
					else
						gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),FALSE);
				}
				i++;
			}
		}
	}
}


void
on_add_modify_flag_user_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_label");
	if(w)
	{
		gchar *lbl;

		gtk_label_get(GTK_LABEL(w),&lbl);

		if((lbl!=NULL)&&(strlen(lbl)))
		{
			GString *flags;
			int i;

			flags=g_string_new("");

			i=0;
			while(opt_list[i].widget_name!=NULL)
			{
				w=get_widget_by_widget_name(opt_list[i].widget_name);
				if(w!=NULL)
				{
					if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))==TRUE)
					{
						if(flags->len!=0)
							flags=g_string_append_c(flags,'|');
						flags=g_string_append(flags,opt_list[i].option_name);
					}
				}
				i++;
			}

			if(flags->len!=0)
				set_key_data(unwanted_user,lbl,strlen(lbl),flags->str,flags->len);
			else
				del_key_data(unwanted_user,lbl,strlen(lbl));
			g_string_free(flags,TRUE);

			update_flag_user_list1(lbl);
		}
	}
}


void
on_delete_flag_user_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_label");
	if(w)
	{
		gchar *lbl;

		gtk_label_get(GTK_LABEL(w),&lbl);

		if((lbl!=NULL)&&(strlen(lbl)))
		{
			del_key_data(unwanted_user,lbl,strlen(lbl));
			update_flag_user_list1(lbl);
		}
	}
}


static void reload_flagged_user_clist(int only_if_empty)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("flagged_user_clist");
	if(w)
	{
		GtkCList *clst;

		clst=GTK_CLIST(w);
		if( (only_if_empty==0) || ( (only_if_empty&&(clst->rows==0) ) ) )
		{
			DBC *cursor;
			int ret;
			gtk_clist_freeze(clst);
			gtk_clist_clear(clst);

			ret=unwanted_user->cursor(unwanted_user,NULL,&cursor,0);
			if(ret==0)
			{

				DBT key;
				DBT data;
				char buf1[8192];
				char buf2[8192];
				char *row[2];

				memset(&key,0,sizeof(key));
				memset(&data,0,sizeof(data));

				key.data=buf1;
				key.ulen=sizeof(buf1)-1;
				key.flags=DB_DBT_USERMEM;

				data.data=buf2;
				data.ulen=sizeof(buf2)-1;
				data.flags=DB_DBT_USERMEM;

				row[0]=buf1;
				row[1]=buf2;

				ret=cursor->c_get(cursor,&key,&data,DB_FIRST);
				while(ret==0)
				{
					buf1[key.size]='\0';
					buf2[data.size]='\0';
			
					gtk_clist_append(clst,row);

					ret=cursor->c_get(cursor,&key,&data,DB_NEXT);
				}

				/* end of scan, destroy the cursor */
				cursor->c_close(cursor);
			}

			gtk_clist_sort(clst);
			gtk_clist_thaw(clst);
		}
	}
}

void
on_reload_flagged_user_list_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	reload_flagged_user_clist(0);		/* force reload ... always */
}

/*****************************************************************************/
/* this function flag the given nickname and switch to the flagged users tab */
/*****************************************************************************/
static void do_user_flaging(char *nick)
{
	GtkWidget *w;
	int fl_row;
	GtkWidget *fl_w;

	fl_w=get_widget_by_widget_name("flagged_user_clist");
	if(fl_w==NULL)
		return;

	fl_row=row_num(GTK_CLIST(fl_w),0,nick);
	if(fl_row!=-1)
	{
		/* the user is already flagged */
		gtk_clist_select_row(GTK_CLIST(fl_w),fl_row,0);
	}
	else
	{
		int i;

		w=get_widget_by_widget_name("flagged_user_label");
		if(w)
		{
			gtk_label_set(GTK_LABEL(w),nick);

			i=0;
			while(opt_list[i].widget_name!=NULL)
			{
				w=get_widget_by_widget_name(opt_list[i].widget_name);
				if(w!=NULL)
				{
					gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w),TRUE);
				}
				i++;
			}

		}
	}

	w=get_widget_by_widget_name("main_notebook");
	gtk_notebook_set_page(GTK_NOTEBOOK(w),FLAGGED_USER_TAB);
}

static void flag_a_user(char *clist_name, int clist_column)
{
	GtkWidget *w;
	char *nick;
	GList *glst;
	int row;

	/* get the nickname of the remote side of the private chat */
	w=get_widget_by_widget_name(clist_name);
	glst=GTK_CLIST(w)->selection;
	if(glst==NULL)
		return;			/* no one is selected */

	row=(int)(glst->data);
	gtk_clist_get_text(GTK_CLIST(w),row,clist_column,&nick);
	if(nick==NULL)
		return;

	do_user_flaging(nick);
}

void
on_flag_user_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	flag_a_user("user_clist",1);
}


void
on_flag_user2_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	flag_a_user("download_clist",0);
}


static void flag_a_user_from_find_result(FIND_CL_ENTRY *fce, void *data)
{
	do_user_flaging(fce->nickname);
}

void
on_flag_user3_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	generic_selected_find_result_calls(flag_a_user_from_find_result,NULL);
}

void
on_flag_pchat_user_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("chat_notebook");
	if(w)
	{
		int i;

		i=gtk_notebook_get_current_page(GTK_NOTEBOOK(w));

		w=get_widget_by_widget_name(lbl_chat[i]);
		if(w!=NULL)
		{
			char *nick;

			gtk_label_get(GTK_LABEL(w),&nick);
			auto_flag_user(nick);
		}
	}
}

void do_nick_completion(GtkEditable *w)
{
	gchar *str;
	char *beg;

	int cur_pos=gtk_editable_get_position(w);

	if(cur_pos<2)		/* at least 2 characters to perform a completion */
		return;

	str=gtk_editable_get_chars(w,0,cur_pos);
	beg=strrchr(str,' ');
	if(beg==NULL)
		beg=str;
	else
		beg++;

	if(strlen(beg)>1)
	{
		/* now, beg is the beginning of a string which can be the beginning of a nickname */
		GtkWidget *cl;
		GtkCList *clst;
		int i;
		int ln;
		int fnd=-1;
		gchar *t;

		ln=strlen(beg);

		cl=get_widget_by_widget_name("user_clist");
		clst=GTK_CLIST(cl);
		
		for(i=0;i<clst->rows;i++)
		{
			gtk_clist_get_text(clst,i,1,&t);

			if(!strncmp(t,beg,ln))		/* pattern matched ? */
			{
				if(fnd==-1)
					fnd=i;
				else
				{
					fnd=-1;
					break;					/* more than one nickname matched, abort */
				}
			}
		}

		if(fnd!=-1)
		{
			int ln2;

			gtk_clist_get_text(clst,fnd,1,&t);
			ln2=strlen(t);

			if(ln2!=ln)
			{
				gtk_editable_insert_text(w,t+ln,ln2-ln,&cur_pos);
			}
			gtk_editable_insert_text(w," ",1,&cur_pos);
			gtk_editable_set_position(w,cur_pos);
		}
	}
	
	g_free(str);
}


gboolean
on_chat_input_key_press_event          (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_Tab:	/* tab pressed */
						do_nick_completion(GTK_EDITABLE(widget));
						return TRUE;
	}

	return TRUE;
}


gboolean
on_pchat_entry_key_press_event         (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return FALSE;

	switch(event->keyval)
	{
		case GDK_Tab:	/* tab pressed */
						do_nick_completion(GTK_EDITABLE(widget));
						return TRUE;
	}

	return TRUE;
}

static void try_to_attach_this_gdl(const char *dir1, const char *dir2)
{
	GString *str;
	int fd;

	str=g_string_new("");
	g_string_sprintf(str,"%s/%s/.lock",dir1,dir2);

	fd=open(str->str,O_RDWR);
	if(fd!=-1)
	{
		if(lockf(fd,F_TEST,1)==0)
		{
			/* .lock file exists and is lockable, so nobody uses this entry */

			/* create and send the GDL attachment query */
			g_string_sprintf(str,"/GDLATTACH %s\n",dir2);
			send_data_to_dctc(str->str);
		}
		close(fd);
	}
	g_string_free(str,TRUE);
}


void
on_attach_all_unattached_gdl_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	DIR *dir;
	struct dirent *obj;
	const char *t;

	t=get_var("dl_path");
	if((t!=NULL)&&(strlen(t)))
	{
		GString *st1;

		st1=g_string_new(t);
		st1=g_string_append(st1,"/GDL");
		dir=opendir(st1->str);
		if(dir!=NULL)
		{
			while((obj=readdir(dir))!=NULL)
			{
				try_to_attach_this_gdl(st1->str,obj->d_name);
			}
			closedir(dir);
		}
		g_string_free(st1,TRUE);
	}
}

/***************************************************************/
/* send a /QUIT\n to the DCTC having the given socket filename */
/***************************************************************/
static void send_quit_command_to_client(char *unx_sock_name)
{
	GString *cur_udp_path;
	struct sockaddr_un name;

	if(local_udp_socket==-1)
		return;

	cur_udp_path=g_string_new(dctc_dir->str);
	g_string_sprintfa(cur_udp_path,"/%s.udp",unx_sock_name);

	name.sun_family=AF_UNIX;
	strcpy(name.sun_path,cur_udp_path->str);
	if(sendto(local_udp_socket,"/FORCEQUIT\n",strlen("/FORCEQUIT\n"),MSG_NOSIGNAL|MSG_DONTWAIT,(void*)&name,sizeof(struct sockaddr_un))!=strlen("/FORCEQUIT\n"))
	{
		perror("send_quit_command_to_client");
	}
	
	g_string_free(cur_udp_path,TRUE);
}

/******************************************************/
/* terminate selected DCTC with more or less violence */
/******************************************************/
static void terminate_selected_dctc_entries(int kill_it)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;
	GArray *ga=NULL;
	int nb=0;

	w=get_widget_by_widget_name("running_hub_clist");
	if(w==NULL)
		return;

	if(kill_it)
		ga=g_array_new(FALSE,FALSE,sizeof(pid_t));

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			char *unx_sock_name;

			gtk_clist_get_text(clst,row,1,&unx_sock_name);
			if((unx_sock_name==NULL)||(strlen(unx_sock_name)==0))
				continue;

			send_quit_command_to_client(unx_sock_name);
			nb++;

			if(kill_it)
			{
				pid_t num;
				int num_int;

				sscanf(unx_sock_name+5,"%08X",&num_int);
				num=num_int;
				ga=g_array_append_val(ga,num);
			}
		}
	}

	if((kill_it)&&(ga->len!=0))
	{
		int i;
		sleep(3);		/* wait a little before killing everybody */
		for(i=0;i<ga->len;i++)
		{
			pid_t num;

			num=g_array_index(ga,pid_t,i);

			kill(num,SIGKILL);
		}
	}

	if(ga!=NULL)
		g_array_free(ga,TRUE);

	if(nb!=0)
	{
		if(kill_it)
		{
			sleep(1);
		}
		else
		{
			sleep(2);
		}
		on_refresh_sitelist_button_clicked(NULL,NULL);
	}
}

void
on_terminate_selected_dctcs_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	terminate_selected_dctc_entries(0);
}


void
on_kill_selected_dctcs_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	terminate_selected_dctc_entries(1);
}


void
on_flag_user_from_gdl_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_selected_gdl_user(flag_user_of_this_gdl_entry);
}


void
on_gdl_view_file_list_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	cmd_selected_gdl_user(view_user_file_list_of_this_gdl_entry);
}


void
on_unode_addr_entry_activate           (GtkEditable     *editable,
                                        gpointer         user_data)
{
	UNODE_DATA und;
	char *param;

	param=gtk_entry_get_text(GTK_ENTRY(editable));
	if(strlen(param)<1)
		return;

	memset(&und,0,sizeof(und));
	und.entry_enabled=1;
	und.dynamic_ip=1;
	strncpy_max(und.host_unresolved_addr,param,MIN(128,strlen(param)+1));

	/* add a new entry to the unode database */
	{
		G_LOCK(unode_lmp);
		if(!lmp_lock_and_map(unode_lmp))
		{
			int exact=-1;
			int free_entry=-1;
			int i;
			UNODE_DATA *ulm=unode_lmp->mapped_addr;

			for(i=1;i<unode_lmp->nb_records;i++)   /* skip the first record */
			{
				UNODE_DATA *udt=&(ulm[i]);

				if(udt->entry_enabled)
				{
					if(!strcmp(udt->host_unresolved_addr,und.host_unresolved_addr))
					{
						exact=i;
						break;
					}
				}
				else
				{
					if(free_entry==-1)
						free_entry=i;
				}
			}
			
			if((exact==-1)&&(free_entry!=-1))
				exact=free_entry;

			if(exact!=-1)
			{
				memcpy(&(ulm[exact]),&und,sizeof(UNODE_DATA));
			}
			else
			{
				lmp_append_record(unode_lmp,&und);
			}
			lmp_unmap_and_unlock(unode_lmp);
		}
		G_UNLOCK(unode_lmp);
	}
	reload_unode_clist(0);

	gtk_editable_set_position(GTK_EDITABLE(editable),0);
	gtk_editable_delete_text(GTK_EDITABLE(editable),0,-1);
}


void
on_addr_unode_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("unode_addr_entry");
	if(w!=NULL)
	{
		on_unode_addr_entry_activate(GTK_EDITABLE(w),NULL);
	}
}


void
on_del_selected_unode_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("unode_clist");
	if(w)
	{
		GtkCList *clst;
		GtkCListRow *clist_row;
		int row;
		int changed=0;

		clst=GTK_CLIST(w);
	
		for(row=0;row<clst->rows;row++)
		{
			clist_row=g_list_nth(clst->row_list,row)->data;
	
			if(clist_row->state==GTK_STATE_SELECTED)
			{
				char *unode;

				if(gtk_clist_get_text(clst,row,0,&unode))
				{
					if((unode!=NULL)&&(strlen(unode)))
					{
						G_LOCK(unode_lmp);
						if(!lmp_lock_and_map(unode_lmp))
						{
							int i;
							UNODE_DATA *ulm=unode_lmp->mapped_addr;

							for(i=1;i<unode_lmp->nb_records;i++)   /* skip the first record */
							{
								UNODE_DATA *udt=&(ulm[i]);
				
								if(udt->entry_enabled)
								{
									if(!strcmp(udt->host_unresolved_addr,unode))
									{
										udt->entry_enabled=0;
										break;
									}
								}
							}
							lmp_unmap_and_unlock(unode_lmp);
						}
						G_UNLOCK(unode_lmp);
						changed=1;
					}
				}
			}
		}
		if(changed)
			reload_unode_clist(0);
	}
}

static void reload_unode_clist(int only_if_empty)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("unode_clist");
	if(w)
	{
		GtkCList *clst;

		clst=GTK_CLIST(w);
		if( (only_if_empty==0) || ( (only_if_empty&&(clst->rows==0) ) ) )
		{
			gtk_clist_freeze(clst);
			gtk_clist_clear(clst);
			G_LOCK(unode_lmp);
			if(!lmp_lock_and_map(unode_lmp))
			{
				int i;
				UNODE_DATA *ulm=unode_lmp->mapped_addr;

				for(i=1;i<unode_lmp->nb_records;i++)   /* skip the first record */
				{
					UNODE_DATA *udt=&(ulm[i]);
				
					if(udt->entry_enabled)
					{
						char *row[1];

						row[0]=udt->host_unresolved_addr;
						gtk_clist_append(clst,row);
					}
				}
				lmp_unmap_and_unlock(unode_lmp);
			}
			G_UNLOCK(unode_lmp);

			gtk_clist_sort(clst);
			gtk_clist_thaw(clst);
		}
	}
}


void
on_reload_unode_address_list_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	reload_unode_clist(0);
}


void
on_save_share_list_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_load_share_list_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_locate_user_clist_click_column      (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{

}


gboolean
on_locate_user_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}


void
on_locate_user_entry_activate          (GtkEditable     *editable,
                                        gpointer         user_data)
{
	char *pattern;

	pattern=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("locate_user_entry")));
	if((pattern!=NULL)&&(strlen(pattern)))
	{
		GString *str;

		gtk_label_set_text(GTK_LABEL(get_widget_by_widget_name("currently_searched_user_label")),pattern);

		str=g_string_new("");
		g_string_sprintf(str,"/LOCATEUSER %s\n",pattern);
		send_data_to_dctc(str->str);
		g_string_free(str,TRUE);

		gtk_clist_clear(GTK_CLIST(get_widget_by_widget_name("locate_user_clist")));
	}
}

static void input_this_in_locate_user_entry(char *content)
{
	GtkWidget *w;
	w=get_widget_by_widget_name("locate_user_entry");
	if(w==NULL)
		return;

	gtk_entry_set_text(GTK_ENTRY(w),content);
	gtk_button_clicked(GTK_BUTTON(get_widget_by_widget_name("search_user_button")));

	/* and switch to the find page */
	on_show_search_user_side_button_clicked(NULL,NULL);
	gtk_notebook_set_page(GTK_NOTEBOOK(get_widget_by_widget_name("main_notebook")),FIND_TAB);
}

static void search_for_selected_user_in_clist(char *clist_name, int column)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *t;

			gtk_clist_get_text(clist,row,column,&t);
			input_this_in_locate_user_entry(t);
			break;
		}
	}
}


void
on_search_user_of_dl_clist_activate	 (GtkMenuItem	  *menuitem,
                                        gpointer         user_data)
{
	search_for_selected_user_in_clist("user_clist",0);
}


void
on_search_user_of_user_clist_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	search_for_selected_user_in_clist("user_clist",1);
}

static void search_for_selected_user_in_ctree(char *clist_name, int column)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;

	w=get_widget_by_widget_name(clist_name);
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			GDL_CT_ENTRY *gce;

			gce=gtk_clist_get_row_data(clist,row);
			if((gce!=NULL)&&(gce->ct_type==GDL_ACTIVE_SEGMENT))
			{
				input_this_in_locate_user_entry(gce->c.active_segment.nickname);
			}
		}
	}
}

void
on_search_user_of_gdl_clist_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	search_for_selected_user_in_ctree("user_ctree",0);
}


void
on_search_user_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	on_locate_user_entry_activate(NULL,NULL);
}


void
on_show_search_user_side_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_show(get_widget_by_widget_name("user_search_vbox"));
	gtk_widget_show(get_widget_by_widget_name("hide_search_user_button"));
	gtk_widget_hide(get_widget_by_widget_name("show_search_user_side_button"));
}


void
on_hide_search_user_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_hide(get_widget_by_widget_name("user_search_vbox"));
	gtk_widget_hide(get_widget_by_widget_name("hide_search_user_button"));
	gtk_widget_show(get_widget_by_widget_name("show_search_user_side_button"));
}


void
on_do_browse_vshare_dir_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=create_vshare_dir_fileselection();
	{
		GtkWidget *dl_dir_ent;

		dl_dir_ent=get_widget_by_widget_name("vshare_dir_entry");
		if(dl_dir_ent!=NULL)
		{
			char *t;

			t=gtk_entry_get_text(GTK_ENTRY(dl_dir_ent));
			gtk_file_selection_set_filename(GTK_FILE_SELECTION(w),t);
		}
	}
	gtk_widget_show(w);
	widget_log(w);			/* for an unknown reason, widget_log is not called for the widget containing widgets created by create_* functions */
								/* so we must manually register it */
}


void
on_vshare_dir_select_ok_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	gchar *selected_filename;

	w=get_widget_by_widget_name("vshare_dir_fileselection");

	selected_filename=gtk_file_selection_get_filename(GTK_FILE_SELECTION(w));
	if(selected_filename!=NULL)
	{
		char *path;

		path=strdup(selected_filename);
		if(path!=NULL)
		{
			struct stat st;

			/* verify if the given name is a valid directory */
			if(stat(path,&st)==-1)
			{
				err:
				gnome_app_error(GNOME_APP(main_window),_("invalid dir name"));
			}
			else
			{
				if(!S_ISDIR(st.st_mode))
				{	/* it exists but it is not a directory, remove the filename and retry */
					char *t;
					t=strrchr(path,'/');
					if(t==path)
						goto err;
					t[1]='\0';		/* keep the trailing / */

					if(stat(path,&st)==-1)
						goto err;
					if(!S_ISDIR(st.st_mode))
						goto err;
				}
				printf("'%s'\n",path);
				
				{
					GtkWidget *dl_dir_ent;

					dl_dir_ent=get_widget_by_widget_name("vshare_dir_entry");
					if(dl_dir_ent!=NULL)
					{
						gtk_entry_set_text(GTK_ENTRY(dl_dir_ent),path);
					}
				}
			}
			free(path);
		}
	}
	widget_unlog(w);
	gtk_widget_destroy(w);

}


void
on_vshare_dir_cancel_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("vshare_dir_fileselection");
	widget_unlog(w);
	gtk_widget_destroy(w);
}


void
on_running_hub_clist_click_column      (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


void
on_wake_this_user_gdl_source_on_user_clist_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	foreach_selected_entry_send_cmd("/WAKEUGDL","user_clist",UCC_NICK_COL);
}

void
on_wake_this_user_gdl_source_of_start_dl_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("main_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case FIND_TAB:		/* find */
					generic_selected_find_result_calls(do_user_command_from_find_result,"/WAKEUGDL");
					break;

		default:
					break;
	}
}


void
on_wake_this_user_gdl_source_on_gdl_clist_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	foreach_selected_user_entry_of_gdl_ctree_send_cmd("/WAKEUGDL","gdl_ctree");
}


void
on_reload_done_list_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	GString *str;

	/* load current hub done list */
	str=g_string_new(dctc_dir->str);
	if(strlen(last_known_running_dctc_name))
	{
		g_string_sprintfa(str,"/%s.done",last_known_running_dctc_name);
	}	/* if the last_kn... is empty, load_done_xfer will fail but it has cleared the list */
	load_done_xfer(str->str,1);		/* with clear */

	/* and the global done list */
	str=g_string_assign(str,dctc_dir->str);
	str=g_string_append(str,"/done+exited");
	load_done_xfer(str->str,0);		/* without clear */
	g_string_free(str,TRUE);

}

/************************************************************************/
/* return the row number of the first selected row, -1 if none selected */
/************************************************************************/
static int get_first_selected_row_of_clist(GtkWidget *wlist)
{
	GtkCList *clst;

	clst=GTK_CLIST(wlist);

	if(clst->selection==NULL)
		return -1;

	return GPOINTER_TO_INT (clst->selection->data);
}

/**************************************************************************/
/* check if the given row/column of the clist contains the wanted pattern */
/**************************************************************************/
/* output: 0=no, 1=yes */
/***********************/
static int row_contains_pattern(GtkCList *clst,int row,int column, GString *pattern)
{
	char *txt;

	gtk_clist_get_text(clst,row,column,&txt);

	if(txt==NULL)
		return 0;

	if(my_strcasestr(pattern,txt)!=NULL)
		return 1;
	return 0;
}

/***************************************************************************/
/* select a hub matching the given pattern in the currently displayed list */
/****************************************************************************/
/* input: start_position: 0= top of the list, -1= current position          */
/*        direction: 1=to the bottom of the list, -1=to the top of the list */
/****************************************************************************/
static void find_hub_in_list_fnc(int start_position, int direction)
{
	GtkWidget *w;
	char *pattern;
	int hub_addr=-1,hub_name=-1,hub_desc=-1;
	GtkWidget *wlist;
	GtkCList *clst;
	GString *gstr_pattern;

	if((direction!=-1)&&(direction!=1))
	{
		fprintf(stderr,"find_hub_in_list_fnc: invalid direction, only -1 and 1 allowed\n");
		return;
	}

	w=get_widget_by_widget_name("hubs_to_select_entry");
	if(w==NULL)
	{
		fprintf(stderr,"no widget: hubs_to_select_entry\n");
		return;
	}

	pattern=gtk_entry_get_text(GTK_ENTRY(w));
	if(strlen(pattern)<=0)
	{
		return;		/* nothing to search */
	}

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(get_widget_by_widget_name("connect_notebook"))))
	{
		case RUNNING_HUB_TAB:
					wlist=get_widget_by_widget_name("running_hub_clist");
					hub_addr=0;
					hub_name=2;
					hub_desc=-1;
					break;

		case FAVORITE_HUB_TAB:
					wlist=get_widget_by_widget_name("hub_favorite_clist");
					hub_addr=2;
					hub_name=0;
					hub_desc=1;
					break;
				
		case PUBLIC_HUB_TAB:	
					wlist=get_widget_by_widget_name("hub_public_clist");
					hub_addr=3;
					hub_name=0;
					hub_desc=2;
					break;

		case RECENT_HUB_TAB:
					wlist=get_widget_by_widget_name("hub_recent_clist");
					hub_addr=3;
					hub_name=0;
					hub_desc=2;
					break;

		case SEEN_PUBLIC_HUB_TAB:
					wlist=get_widget_by_widget_name("seen_hub_clist");
					hub_addr=3;
					hub_name=0;
					hub_desc=2;
					break;

		default:
					return;
	}
	
	if(start_position==-1)
	{
		start_position=get_first_selected_row_of_clist(wlist)+direction;	/* we start at the next position */
	}

	clst=GTK_CLIST(wlist);
	gtk_clist_unselect_all(clst);

	gstr_pattern=g_string_new(pattern);
	/* we will scan the list and try to find a row containing the wanted pattern */
	if(direction>0)
	{
		while(start_position<clst->rows)
		{
			if(  ((hub_addr!=-1)&&(row_contains_pattern(clst,start_position,hub_addr,gstr_pattern))) ||
				  ((hub_name!=-1)&&(row_contains_pattern(clst,start_position,hub_name,gstr_pattern))) ||
				  ((hub_desc!=-1)&&(row_contains_pattern(clst,start_position,hub_desc,gstr_pattern))) )
			{
				gtk_clist_moveto (clst, start_position, 0, 0.2, 0.0);
				gtk_clist_select_row(clst,start_position,0);
				clst->focus_row = start_position;
				break;
			}
			start_position++;
		}
	}
	else
	{
		while(start_position>=0)
		{
			if(  ((hub_addr!=-1)&&(row_contains_pattern(clst,start_position,hub_addr,gstr_pattern))) ||
				  ((hub_name!=-1)&&(row_contains_pattern(clst,start_position,hub_name,gstr_pattern))) ||
				  ((hub_desc!=-1)&&(row_contains_pattern(clst,start_position,hub_desc,gstr_pattern))) )
			{
				gtk_clist_moveto (clst, start_position, 0, 0.2, 0.0);
				gtk_clist_select_row(clst,start_position,0);
				clst->focus_row = start_position;
				break;
			}
			start_position--;
		}
	}
	g_string_free(gstr_pattern,TRUE);
}

void
on_hubs_to_select_entry_activate       (GtkEditable     *editable,
                                        gpointer         user_data)
{
	find_hub_in_list_fnc(0,1);		/* from top of the list to the bottom */
}


void
on_find_hub_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
	find_hub_in_list_fnc(0,1);		/* from top of the list to the bottom */
}


void
on_find_prev_hub_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	find_hub_in_list_fnc(-1,-1);		/* from current position to the top of the list */

}


void
on_find_next_hub_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	find_hub_in_list_fnc(-1,1);		/* from current position to the botton of the list */
}


void
on_clear_error_messages_button_clicked (GtkButton       *button,
                                        gpointer         user_data)
{
	wipe_gtk_text("error_messages_text");
}

void
on_cached_user_list_clist_click_column (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
	on_hub_favorite_clist_click_column(clist,column,user_data);
}


gboolean
on_cached_user_list_clist_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if(event==NULL)
		return TRUE;

	if(event->window != GTK_CLIST(widget)->clist_window)
		return FALSE;

	if(event->button==1)
	{	/* left click */
		gint ret;
		gint row,col;

		ret = gtk_clist_get_selection_info(GTK_CLIST(widget), (gint) event->x, (gint) event->y, &row, &col);
		if(ret && (row < GTK_CLIST(widget)->rows) )
		{
			if(event->type==GDK_2BUTTON_PRESS)
			{	/* double click on a row */
				char *col;

				if(gtk_clist_get_text(GTK_CLIST(widget),row,0,&col))
				{
					/* create a dummy string used to simulate the LSCCH incoming message */
					GString *str=g_string_new("LSCCH]\"\"");
					str=g_string_append(str,col);
					str=g_string_append_c(str,'|');
					user_share_full_list_fnc(str);
					g_string_free(str,TRUE);
				}
			}
		}
		return TRUE;
	}

  return FALSE;
}


void
on_reload_cached_user_list_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
	reload_ls_cache_clist(TRUE);
}


void
on_load_selected_share_lists_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;

	w=get_widget_by_widget_name("cached_user_list_clist");
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *col;

			if(gtk_clist_get_text(clist,row,0,&col))
			{
				/* create a dummy string used to simulate the LSCCH incoming message */
				GString *str=g_string_new("LSCCH]\"\"");
				str=g_string_append(str,col);
				str=g_string_append_c(str,'|');
				user_share_full_list_fnc(str);
				g_string_free(str,TRUE);
			}
		}
	}
}


void
on_delete_selected_share_lists_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clist;
	GtkCListRow *clist_row;

	int row;

	w=get_widget_by_widget_name("cached_user_list_clist");
	if(w==NULL)
		return;
	clist=GTK_CLIST(w);

	for(row=0;row<clist->rows;row++)
	{
		clist_row=g_list_nth(clist->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			char *col;

			if(gtk_clist_get_text(clist,row,0,&col))
			{
				/* create a dummy string used to simulate the LSCCH incoming message */
				GString *str=g_string_new(dctc_main_dir->str);
				str=g_string_append(str,"/ls_cache/");
				str=g_string_append(str,col);
				unlink(str->str);
				g_string_free(str,TRUE);
			}
		}
	}
	reload_ls_cache_clist(TRUE);
}


void
on_do_gdl_rename_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	gchar *gid,*fullname;
	GString *str;
	char *t;

	w1=get_widget_by_widget_name("gdl_rename_gid_label");
	w2=get_widget_by_widget_name("gdl_rename_filename_entry");

	if((w1==NULL)||(w2==NULL))
		return;

	gtk_label_get(GTK_LABEL(w1),&gid);
	if(strlen(gid)==0)
		return;

	fullname=gtk_entry_get_text(GTK_ENTRY(w2));
	if(strlen(fullname)==0)
		return;

	t=strrchr(fullname,'/');
	if(t==NULL)
		return;

	*t++='\0';

	str=g_string_new("");
	g_string_sprintf(str,"/GDLRENAME %s|%s|%s\n",gid,t,fullname);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


void
on_remove_current_gdl_rename_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1;
	gchar *gid;
	GString *str;

	w1=get_widget_by_widget_name("gdl_rename_gid_label");

	if(w1==NULL)
		return;

	gtk_label_get(GTK_LABEL(w1),&gid);
	if(strlen(gid)==0)
		return;

	str=g_string_new("");
	g_string_sprintf(str,"/GDLNORENAME %s\n",gid);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


void
on_rename_selected_gdl_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	create_rename_window_for_selected_gdl_entry();
}



void
on_dl_ul_done_view_file_list_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;

	w=get_widget_by_widget_name("xfer_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case XFER_DL_TAB:
						foreach_selected_entry_send_cmd("/LS","download_clist",DLC_NICK_COL);
						break;
		
		case XFER_UL_TAB:
						foreach_selected_entry_send_cmd("/LS","upload_clist",ULC_NICK_COL);
						break;
		
		case XFER_DONE_TAB:
						foreach_selected_entry_send_cmd("/LS","done_clist",DOC_NICK_COL);
						break;
	}
}


void
on_dl_ul_done_open_private_chat_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

	GtkWidget *w;

	w=get_widget_by_widget_name("xfer_notebook");
	if(w==NULL)
		return;

	switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(w)))
	{
		case XFER_DL_TAB:
						open_a_private_chat_with_selected_user_in_list("download_clist",DLC_NICK_COL);
						break;
		
		case XFER_UL_TAB:
						open_a_private_chat_with_selected_user_in_list("upload_clist",ULC_NICK_COL);
						break;
		
		case XFER_DONE_TAB:
						open_a_private_chat_with_selected_user_in_list("done_clist",DOC_NICK_COL);
						break;
	}
}


void
on_toggle_autostart_item_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name("hub_favorite_clist");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			gpointer data;

			data=gtk_clist_get_row_data(clst,row);

			toggle_entry_flag_from_bookmark_by_id(GPOINTER_TO_INT(data),AUTOSTART_FLAG,1);		/* toggle without reload */
		}
	}

	reload_bookmark();
}


void
on_start_dummy_client_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
	start_a_new_dctc("dummy_client",0,NULL);
}

void
on_case_insensitive_nick_sort_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	if(gtk_toggle_button_get_active(togglebutton)==TRUE)
		nickname_sort_function=strcasecmp;
	else
		nickname_sort_function=strcmp;
}

/************************************************************************/
/* return the row number of the first selected row, -1 if none selected */
/************************************************************************/
static int get_first_selected_row_of_ctree(GtkWidget *wlist)
{
	GtkCList *clst;
	int p;

	clst=GTK_CLIST(wlist);

#if 0
	void *p;
	if(clst->selection==NULL)
		return -1;

	p=clst->selection->data;
#endif
	for(p=0;p<clst->rows;p++)
	{
		GtkCListRow *clist_row;
		clist_row=g_list_nth(clst->row_list,p)->data;
		if(clist_row->state==GTK_STATE_SELECTED)
		{
			return p;
		}
	}
	return -1;
}


static void user_file_list_find(char *pattern,int has_dir, int has_file,int start_position,int direction)
{
	GtkWidget *wlist;
	GtkCList *clst;
	USER_FILE_CL_ENTRY *ufce;
	static GString search_string;

	if((direction!=-1)&&(direction!=1))
	{
		fprintf(stderr,"user_file_list_find: invalid direction, only -1 and 1 allowed\n");
		return;
	}

	wlist=get_widget_by_widget_name("user_file_list_clist");
	
	if(start_position==-1)
	{
		start_position=get_first_selected_row_of_ctree(wlist)+direction;	/* we start at the next position */
	}

	/* create a static GString */
	search_string.len=strlen(pattern);
	search_string.str=pattern;

	clst=GTK_CLIST(wlist);
	gtk_clist_unselect_all(clst);

	/* we will scan the list and try to find a row containing the wanted pattern */
	if(direction>0)
	{
		while(start_position<clst->rows)
		{
			ufce=gtk_clist_get_row_data(clst,start_position);
			if(ufce!=NULL)
			{
				if((has_dir)&&(ufce->entry_type==UFL_DIR_ENTRY))
				{
					if((ufce->c.dir_name!=NULL)&&(my_strcasestr(&search_string,ufce->c.dir_name)!=NULL))
					{
						gtk_clist_moveto (clst, start_position, 0, 0.2, 0.0);
						gtk_clist_select_row(clst,start_position,0);
						clst->focus_row = start_position;
						break;
					}
				}
				else
				{
					if((has_file)&&(ufce->entry_type==UFL_FILE_ENTRY))
					{
						if((ufce->c.file.filename!=NULL)&&(my_strcasestr(&search_string,ufce->c.file.filename)!=NULL))
						{
							gtk_clist_moveto (clst, start_position, 0, 0.2, 0.0);
							gtk_clist_select_row(clst,start_position,0);
							clst->focus_row = start_position;
							break;
						}
					}
				}
			}
			start_position++;
		}
	}
	else
	{
		while(start_position>=0)
		{
			ufce=gtk_clist_get_row_data(clst,start_position);
			if(ufce!=NULL)
			{
				if((has_dir)&&(ufce->entry_type==UFL_DIR_ENTRY))
				{
					if((ufce->c.dir_name!=NULL)&&(my_strcasestr(&search_string,ufce->c.dir_name)!=NULL))
					{
						gtk_clist_moveto (clst, start_position, 0, 0.2, 0.0);
						gtk_clist_select_row(clst,start_position,0);
						clst->focus_row = start_position;
						break;
					}
				}
				else
				{
					if((has_file)&&(ufce->entry_type==UFL_FILE_ENTRY))
					{
						if((ufce->c.file.filename!=NULL)&&(my_strcasestr(&search_string,ufce->c.file.filename)!=NULL))
						{
							gtk_clist_moveto (clst, start_position, 0, 0.2, 0.0);
							gtk_clist_select_row(clst,start_position,0);
							clst->focus_row = start_position;
							break;
						}
					}
				}
			}
			start_position--;
		}
	}
}


void do_user_file_list_search(int start_position, int direction)
{
	char *pattern;

	pattern=gtk_entry_get_text(GTK_ENTRY(get_widget_by_widget_name("user_file_list_search_entry")));
	if((pattern!=NULL)&&(strlen(pattern)))
	{
		int has_dir;
		int has_file;

		has_dir=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name("user_file_list_search_as_directory_checkbutton")));
		has_file=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(get_widget_by_widget_name("user_file_list_search_as_file_checkbutton")));

		user_file_list_find(pattern,has_dir,has_file,start_position,direction);
	}
}

void
on_user_file_list_search_entry_activate
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	do_user_file_list_search(0,1);	/* search from the first list and from top to bottom of the list */
}


void
on_user_file_list_search_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	do_user_file_list_search(0,1);	/* search from the first list and from top to bottom of the list */
}


void
on_user_file_list_find_previous_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	do_user_file_list_search(-1,-1);	/* search from the currently selected row and from bottom to top of the list */
}


void
on_user_file_list_find_next_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	do_user_file_list_search(-1,1);	/* search from the currently selected row and from top to bottom of the list */
}


static void generate_as_pattern_from_root_name(GtkCTree *ctree,GDL_CT_ENTRY *gce, void *data)
{
	GString *str;
	char *t;

	str=g_string_new(gce->c.root.local_filename);

	/* remove everything before the last '/' (and the '/' itself) */
	t=strrchr(str->str,'/');
	if(t!=NULL)
	{
		g_string_erase(str,0,(t+1)-str->str);
	}

	if(str->len>10)
	{
		int i;
		int nb=0;

		/* replace non alpha-num character by '$' */
		for(i=0;i<str->len;i++)
		{
			if(!isalnum(str->str[i]))
			{
				str->str[i]='$';
				nb++;
			}
		}

		/* replace multiple consecutive '$' by one '$' */
		i=0;
		while(i<(str->len-1))
		{
			if((str->str[i]=='$') && (str->str[i+1]=='$'))
			{
				g_string_erase(str,i,1);
				nb--;
			}
			else
				i++;
		}

		if((str->len/nb)>2)	/* the pattern should not at least look like "$$$$$$" */
		{
			GString *cmd;

			cmd=g_string_new("");
			g_string_sprintf(cmd,"/GDLAS+ %lu|%d|%s\n",gce->c.root.gdl_id,1,str->str);
			send_data_to_dctc(cmd->str);
			g_string_free(cmd,TRUE);
		}
	}
	g_string_free(str,TRUE);
}

void
on_generate_autoscan_pattern_for_selected_gdl1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	static void (*fnc[GDL_NUMBER_OF_GDL_CT_TYPE])={generate_as_pattern_from_root_name,NULL,NULL,NULL,NULL};

	generic_selected_gdl_entry_list_calls((void*)fnc,NULL);
}


void
on_do_gdl_script_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1,*w2;
	gchar *gid,*fullname;
	GString *str;

	w1=get_widget_by_widget_name("gdl_script_gid_label");
	w2=get_widget_by_widget_name("gdl_endname_filename_entry");

	if((w1==NULL)||(w2==NULL))
		return;

	gtk_label_get(GTK_LABEL(w1),&gid);
	if(strlen(gid)==0)
		return;

	fullname=gtk_entry_get_text(GTK_ENTRY(w2));
	if(strlen(fullname)==0)
		return;

	str=g_string_new("");
	g_string_sprintf(str,"/GDLSCRIPT %s|%s\n",gid,fullname);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);
}


void
on_remove_current_gdl_script_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w1;
	gchar *gid;
	GString *str;

	w1=get_widget_by_widget_name("gdl_script_gid_label");

	if(w1==NULL)
		return;

	gtk_label_get(GTK_LABEL(w1),&gid);
	if(strlen(gid)==0)
		return;

	str=g_string_new("");
	g_string_sprintf(str,"/GDLNOSCRIPT %s\n",gid);
	send_data_to_dctc(str->str);
	g_string_free(str,TRUE);

}


void
on_script_selected_gdl_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	create_script_window_for_selected_gdl_entry();
}




void
on_pubchat_flag_selected_user_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *w;
	int start_pos;
	int offset;
	gchar *str;
	int beginning;
	int has_beginning=FALSE;
	int start_of_nick=-1;
	int end_of_nick=-1;
	char buf[1024];		/* we extract at most 1024 characters and we discard at least 3 characters ("<" and "> ") */

	w=get_widget_by_widget_name("chat_output");
	if(w==NULL)
		return;

	start_pos=gtk_editable_get_position(GTK_EDITABLE(w));
	
	if(start_pos<512)
		offset=start_pos;
	else
		offset=512;

	start_pos-=offset;

	/* extract a 1024 characters (512 before and 512 after the cursor position) */
	str=gtk_editable_get_chars(GTK_EDITABLE(w),start_pos,offset+512);

	if(str==NULL)
	{
		/* it seems to be impossible to have as much characters, try to grab as many as possible */
		str=gtk_editable_get_chars(GTK_EDITABLE(w),start_pos,-1);
		if(str==NULL)
			return;
	}

	/* search the beginning of the row */
	beginning=offset;
	while(beginning>=0)
	{
		if(str[beginning]=='\n')
		{
			beginning++;
			has_beginning=TRUE;
			break;
		}
		beginning--;
	}

	if(has_beginning==TRUE)
	{
		int max_len=strlen(str);
		int i;

		/* search the first '<' of the row */
		for(i=beginning;i<max_len;i++)
		{
			if(str[i]=='<')
			{
				start_of_nick=i+1;
				break;
			}
		}

		if(start_of_nick!=-1)
		{
			/* and just after, the first "> " of the row */
			for(i=start_of_nick;i<(max_len-1);i++)
			{
				if((str[i]=='>')&&(str[i+1]==' '))
				{
					end_of_nick=i;
					break;
				}
			}

			if(end_of_nick!=-1)
			{
				strncpy_max(buf,str+start_of_nick,MIN(sizeof(buf),(end_of_nick-start_of_nick + 1)));	/* +1 because we must include the '\0' at the end */

				gtk_editable_select_region(GTK_EDITABLE(w),start_pos+start_of_nick,start_pos+end_of_nick);
				do_user_flaging(buf);
			}
		}
	}

	g_free(str);
}

