#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "misc_gtk.h"
#include "find_result_clist.h"

/*******************************************************/
/* free memory used by a FIND_CL_ENTRY and its content */
/*******************************************************/
void free_find_cl_entry(FIND_CL_ENTRY *fce)
{
	if(fce==NULL)
		return;

	if(fce->nickname)
		free(fce->nickname);
	if(fce->filename)
		free(fce->filename);
	if(fce->hubname)
		free(fce->hubname);
	if(fce->connection_speed)
		free(fce->connection_speed);
	free(fce);
}

/******************************/
/* create a new FIND_CL_ENTRY */
/******************************/
FIND_CL_ENTRY *new_cl_entry(char *nickname, char *filename, unsigned long file_size, int free_slot, int ttl_slot, char *hubname, char *connection_speed)
{
	FIND_CL_ENTRY *fce;

	fce=malloc(sizeof(FIND_CL_ENTRY));
	if(fce==NULL)
		return fce;

	fce->nickname=strdup(nickname);
	fce->filename=strdup(filename);
	fce->file_size=file_size;
	fce->free_slot=free_slot;
	fce->ttl_slot=ttl_slot;
	fce->hubname=strdup(hubname);
	fce->connection_speed=strdup(connection_speed);
	return fce;
}

/****************************************************************************************/
/* this function calls the given fnc for each selected entry of the "find_result" clist */
/****************************************************************************************/
void generic_selected_find_result_calls(void (*fnc)(FIND_CL_ENTRY *, void *), void *data)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name("find_result");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			(*fnc)((FIND_CL_ENTRY*)(clist_row->data),data);
		}
	}
}

