#ifndef __GDL_CTREE_H__
#define __GDL_CTREE_H__

typedef enum
{
	GDL_ROOT=0,
	GDL_SEARCH_PATTERN,
	GDL_ACTIVE_SEGMENT,
	GDL_STORED_SEGMENT,
	GDL_RENAME_AT_END,
	GDL_SCRIPT_AT_END,
	GDL_NUMBER_OF_GDL_CT_TYPE	/* last value of the enum */
} GDL_CT_TYPE;
typedef struct
{
	GDL_CT_TYPE ct_type;
	union
	{
		struct
		{
			unsigned long gdl_id;			/* GDL ID */
			char *local_filename;			/* local filename */
			unsigned long gdl_size;			/* size of the file */
			unsigned long byte_offset;		/* number of bytes already here when this GDL was attached */
			unsigned long received_bytes;	/* this value includes the previous one */
			time_t start_time;				/* from creation or attachment */
			unsigned long last_10sec_speed;	/* number of bytes received during the last 10 seconds */
		} root;
		struct
		{
			unsigned long autoscan_id;
			unsigned int autoscan_type;
			char *search_pattern;
		} search_pattern;
		struct
		{
			char *nickname;
			char *remote_filename;
			unsigned long remote_file_size;
			char *status;
		} active_segment;
		struct
		{
			char *stored_filename;
			char *stored_interval;
		} stored_segment;
		struct
		{
			char *final_directory;
			char *final_filename;
		} rename_at_end;
		struct
		{
			char *script_to_start;
		} script_at_end;
	} c;
} GDL_CT_ENTRY;

/******************************************************/
/* free memory used by a GDL_CT_ENTRY and its content */
/******************************************************/
void free_gdl_ct_entry(GDL_CT_ENTRY *gce);

GDL_CT_ENTRY *new_gdl_ct_entry_as_root( unsigned long gdl_id, char *local_filename, unsigned long gdl_size, unsigned long byte_offset, unsigned long received_bytes, time_t start_time, unsigned long last_10sec_speed);
GDL_CT_ENTRY *new_gdl_ct_entry_as_search_pattern( unsigned long autoscan_id, unsigned int autoscan_type, char *search_pattern);
GDL_CT_ENTRY *new_gdl_ct_entry_as_active_segment( char *nickname, char *remote_filename, unsigned long remote_file_size, char *status);
GDL_CT_ENTRY *new_gdl_ct_entry_as_stored_segment( char *stored_filename, char *stored_interval);
GDL_CT_ENTRY *new_gdl_ct_entry_as_rename_at_end( char *final_directory, char *final_filename);
GDL_CT_ENTRY *new_gdl_ct_entry_as_script_at_end( char *script_to_start);

/**************************************************************************************/
/* this function calls the given fnc for each selected entry of the "gdl_ctree" clist */
/**************************************************************************************/
/* fnc is an array of GDL_NUMBER_OF_GDL_CT_TYPE pointers, 1 pointer per GDL_CT_TYPE */
/* a NULL pointer means the entry is not processed                                  */
/************************************************************************************/
void generic_selected_gdl_entry_list_calls(void (*fnc[GDL_NUMBER_OF_GDL_CT_TYPE])(GtkCTree *ctree,GDL_CT_ENTRY *, void *), void *data);

#endif
