#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "misc_gtk.h"
#include "ls_cache_clist.h"

/***********************************************************/
/* free memory used by a LS_CACHE_CL_ENTRY and its content */
/***********************************************************/
void free_ls_cache_cl_entry(LS_CACHE_CL_ENTRY *lcce)
{
	if(lcce==NULL)
		return;

	if(lcce->nickname)
		free(lcce->nickname);
	free(lcce);
}

/**********************************/
/* create a new LS_CACHE_CL_ENTRY */
/**********************************/
LS_CACHE_CL_ENTRY *new_ls_cache_cl_entry(const char *nickname, unsigned long long file_size, time_t retrieve_date)
{
	LS_CACHE_CL_ENTRY *lcce;

	lcce=malloc(sizeof(LS_CACHE_CL_ENTRY));
	if(lcce==NULL)
		return lcce;

	lcce->nickname=strdup(nickname);
	lcce->shared_size=file_size;
	lcce->retrieve_date=retrieve_date;
	return lcce;
}

/***************************************************************************************************/
/* this function calls the given fnc for each selected entry of the "cached_user_list_clist" clist */
/***************************************************************************************************/
void generic_selected_ls_cache_list_calls(void (*fnc)(LS_CACHE_CL_ENTRY *, void *), void *data)
{
   GtkWidget *w;
   GtkCList *clst;
   GtkCListRow *clist_row;
   int row;

   w=get_widget_by_widget_name("cached_user_list_clist");
   if(w==NULL)
      return;

   clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
			(*fnc)((LS_CACHE_CL_ENTRY*)(clist_row->data),data);
      }
   }
}

