#ifndef __LS_CACHE_CLIST_H__
#define __LS_CACHE_CLIST_H__

typedef struct
{
	char *nickname;
	unsigned long long shared_size;
	time_t retrieve_date;
} LS_CACHE_CL_ENTRY;

/***********************************************************/
/* free memory used by a LS_CACHE_CL_ENTRY and its content */
/***********************************************************/
void free_ls_cache_cl_entry(LS_CACHE_CL_ENTRY *lcce);

LS_CACHE_CL_ENTRY *new_ls_cache_cl_entry(const char *nickname, unsigned long long file_size, time_t retrieve_date);

/***************************************************************************************************/
/* this function calls the given fnc for each selected entry of the "cached_user_list_clist" clist */
/***************************************************************************************************/
void generic_selected_ls_cache_list_calls(void (*fnc)(LS_CACHE_CL_ENTRY *, void *), void *data);

#endif
