#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "misc_gtk.h"
#include "user_clist.h"

/*******************************************************/
/* free memory used by a USER_CL_ENTRY and its content */
/*******************************************************/
void free_user_cl_entry(USER_CL_ENTRY *uce)
{
	if(uce==NULL)
		return;

	if(uce->nickname)
		free(uce->nickname);
	if(uce->email)
		free(uce->email);
	if(uce->description)
		free(uce->description);
	free(uce);
}

static const char *lst_cnx_type[]=
                           {
                              "56Kbps",
                              "33.6Kbps",
                              "28.8Kbps",
                              "Satellite",      /* according to DC, passive mode is required here */
                              "ISDN",
                              "DSL",
                              "Cable",
                              "LAN(T1)",
                              "LAN(T3)",
                              NULL
                           };

/**************************************************************/
/* return a pointer on a const string containing the cnx_type */
/**************************************************************/
const char *get_const_string_for_cnx_type(char *cnx_type)
{
	int i;

	i=0;
	while(lst_cnx_type[i]!=NULL)
	{
		if(!strcmp(cnx_type,lst_cnx_type[i]))
			return lst_cnx_type[i];
		i++;
	}
	return "";
}

/******************************/
/* create a new USER_CL_ENTRY */
/******************************/
USER_CL_ENTRY *new_user_cl_entry(char *cnx_type,char *nickname, unsigned long long share_size, char *email, char *description, unsigned int flag)
{
	USER_CL_ENTRY *uce;

	uce=malloc(sizeof(USER_CL_ENTRY));
	if(uce==NULL)
		return uce;

	uce->cnx_type=get_const_string_for_cnx_type(cnx_type);
	uce->nickname=strdup(nickname);
	uce->share_size=share_size;
	uce->email=strdup(email);
	uce->description=strdup(description);
	uce->flag=flag;
	uce->is_op=FALSE;
	return uce;
}

/***************************************************************************************/
/* this function calls the given fnc for each selected entry of the "user_clist" clist */
/***************************************************************************************/
void generic_selected_user_clist_calls(void (*fnc)(USER_CL_ENTRY *, void *), void *data)
{
	GtkWidget *w;
	GtkCList *clst;
	GtkCListRow *clist_row;
	int row;

	w=get_widget_by_widget_name("user_clist");
	if(w==NULL)
		return;

	clst=GTK_CLIST(w);

	for(row=0;row<clst->rows;row++)
	{
		clist_row=g_list_nth(clst->row_list,row)->data;

		if(clist_row->state==GTK_STATE_SELECTED)
		{
			(*fnc)((USER_CL_ENTRY*)(clist_row->data),data);
		}
	}
}

