#ifndef __USER_CLIST_H__
#define __USER_CLIST_H__

typedef struct
{
	const char *cnx_type;	/* must not be freed */
	char *nickname;
	unsigned long long share_size;
	char *email;
	char *description;
	unsigned int flag;
	int is_op;
} USER_CL_ENTRY;

/*******************************************************/
/* free memory used by a USER_CL_ENTRY and its content */
/*******************************************************/
void free_user_cl_entry(USER_CL_ENTRY *uce);

/******************************/
/* create a new USER_CL_ENTRY */
/******************************/
USER_CL_ENTRY *new_user_cl_entry(char *cnx_type, char *nickname, unsigned long long share_size, char *email, char *description, unsigned int flag);

/**************************************************************/
/* return a pointer on a const string containing the cnx_type */
/**************************************************************/
const char *get_const_string_for_cnx_type(char *cnx_type);

/***************************************************************************************/
/* this function calls the given fnc for each selected entry of the "user_clist" clist */
/***************************************************************************************/
void generic_selected_user_clist_calls(void (*fnc)(USER_CL_ENTRY *, void *), void *data);

#endif
