#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "misc_gtk.h"
#include "user_file_list_clist.h"

/************************************************************/
/* free memory used by a USER_FILE_CL_ENTRY and its content */
/************************************************************/
void free_user_file_cl_entry(USER_FILE_CL_ENTRY *ufce)
{
	if(ufce==NULL)
		return;

	switch(ufce->entry_type)
	{
		case UFL_NICK_ROOT_ENTRY:	free(ufce->c.nickname);
											break;
		case UFL_DIR_ENTRY:			free(ufce->c.dir_name);
											break;
		case UFL_FILE_ENTRY:			free(ufce->c.file.filename);
											break;
		default:
						fprintf(stderr,"free_user_file_cl_entry: unknown entry type: %d\n",ufce->entry_type);
						break;
	}
	free(ufce);
}

/************************************************/
/* create a new USER_FILE_CL_ENTRY as nick root */
/************************************************/
USER_FILE_CL_ENTRY *new_user_file_cl_entry_as_nick_root(const char *nickname)
{
	USER_FILE_CL_ENTRY *ufce;

	ufce=malloc(sizeof(USER_FILE_CL_ENTRY));
	if(ufce==NULL)
		return ufce;

	ufce->entry_type=UFL_NICK_ROOT_ENTRY;
	ufce->c.nickname=strdup(nickname);
	return ufce;
}

/************************************************/
/* create a new USER_FILE_CL_ENTRY as directory */
/************************************************/
USER_FILE_CL_ENTRY *new_user_file_cl_entry_as_dir(const char *dir_name)
{
	USER_FILE_CL_ENTRY *ufce;

	ufce=malloc(sizeof(USER_FILE_CL_ENTRY));
	if(ufce==NULL)
		return ufce;

	ufce->entry_type=UFL_DIR_ENTRY;
	ufce->c.dir_name=strdup(dir_name);
	return ufce;
}

/*******************************************/
/* create a new USER_FILE_CL_ENTRY as file */
/*******************************************/
USER_FILE_CL_ENTRY *new_user_file_cl_entry_as_file(const char *filename, unsigned long file_size)
{
	USER_FILE_CL_ENTRY *ufce;

	ufce=malloc(sizeof(USER_FILE_CL_ENTRY));
	if(ufce==NULL)
		return ufce;

	ufce->entry_type=UFL_FILE_ENTRY;
	ufce->c.file.filename=strdup(filename);
	ufce->c.file.file_size=file_size;
	return ufce;
}

/*******************************************************************************************/
/* this function calls the given fnc for each selected entry of the "user_file_list" clist */
/*******************************************************************************************/
void generic_selected_user_file_list_calls(void (*fnc)(GtkCTree *ctree,USER_FILE_CL_ENTRY *, void *), void *data)
{
   GtkWidget *w;
   GtkCList *clst;
   GtkCListRow *clist_row;
   int row;

   w=get_widget_by_widget_name("user_file_list_clist");
   if(w==NULL)
      return;

   clst=GTK_CLIST(w);

   for(row=0;row<clst->rows;row++)
   {
      clist_row=g_list_nth(clst->row_list,row)->data;

      if(clist_row->state==GTK_STATE_SELECTED)
      {
         (*fnc)(GTK_CTREE(w),(USER_FILE_CL_ENTRY*)(clist_row->data),data);
      }
   }
}

/******************************************************************/
/* find the UFL_NICK_ROOT_ENTRY of a given entry (DIR|FILE)_ENTRY */
/******************************************************************/
USER_FILE_CL_ENTRY *get_nick_entry_for_user_file_list_from_ufce(GtkCTree *ctree, USER_FILE_CL_ENTRY *fce)
{
	GtkCTreeNode *base;
	USER_FILE_CL_ENTRY *out_fce=NULL;

	/* 1) find the node having the current entry */
	base=gtk_ctree_find_by_row_data(ctree,NULL,fce);
	if(base==NULL)
		return NULL;

	while(1)
	{
		base=GTK_CTREE_ROW(base)->parent;
		if(base==NULL)
			return NULL;

		out_fce=gtk_ctree_node_get_row_data(ctree,base);
		if(out_fce!=NULL)
		{
			if(out_fce->entry_type==UFL_NICK_ROOT_ENTRY)
				return out_fce;
		}
	}
}

/********************************************************************************/
/* find the UFL_NICK_ROOT_ENTRY of a given ctreenode with type (DIR|FILE)_ENTRY */
/********************************************************************************/
USER_FILE_CL_ENTRY *get_nick_entry_for_user_file_list_from_ctnode(GtkCTree *ctree, GtkCTreeNode *base)
{
	USER_FILE_CL_ENTRY *out_fce=NULL;

	if(base==NULL)
		return NULL;

	while(1)
	{
		base=GTK_CTREE_ROW(base)->parent;
		if(base==NULL)
			return NULL;

		out_fce=gtk_ctree_node_get_row_data(ctree,base);
		if(out_fce!=NULL)
		{
			if(out_fce->entry_type==UFL_NICK_ROOT_ENTRY)
				return out_fce;
		}
	}
}

