#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "userinfo.h"
#include "lmp.h"
#include "misc.h"

/**********************************************/
/* find the array index of the given nickname */
/**********************************************/
/* output: idx or -1 if not found */
/**********************************/
static int uinfo_idx(LMP_ENTRY *lmp,char *nickname)
{
	int i;
	LMP_UINFO *lu=lmp->mapped_addr;

	for(i=1;i<lmp->nb_records;i++)
	{
		if(lu[i].entry_is_busy)
		{
			if(!strcmp(lu[i].nickname,nickname))
				return i;
		}
	}
	return -1;
}

/********************************************************/
/* retrieve the user information for the given nickname */
/********************************************************/
/* input: lmp=user_info_lmp to use     */
/*        nickname= nick to find       */
/*        uinfo= array filed on succes */
/********************************************************/
/* output: 0=ok, (*uinfo) contains the user information */
/*         1=not found or error.                        */
/********************************************************/
int get_user_info(LMP_ENTRY *lmp, char *nickname,LMP_UINFO *uinfo)
{
	int idx;
	int ret=1;

	if(lmp==NULL)
		return ret;	/* no lmp */

	if(lmp_lock_and_map(lmp))
		return ret;	/* fail to lock */

	idx=uinfo_idx(lmp,nickname);
	if(idx!=-1)
	{
		memcpy(uinfo,&(((LMP_UINFO *)(lmp->mapped_addr))[idx]),sizeof(LMP_UINFO));
		ret=0;
	}

	lmp_unmap_and_unlock(lmp);
	return ret;
}

