/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * keyboard.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KEYBOARD_H__
#define __KEYBOARD_H__

/*********************************************************/
/* update the IP of the client if dynamic IP flag is set */
/*********************************************************/
void update_client_ip(void);

/**********************************************************/
/* this function manages everything enter on the keyboard */
/*************************************************************************/
/* input: sck= network socket to use                                     */
/*        sim_input= if sim_input==NULL, the command is taken from stdin */
/*                   else, the given command is used                     */
/*************************************************************************/
void keyboard_input(int sck, char *sim_input);

/*****************************************************************************************************/
/* the following function must only be used when a "manual" process of the command line is necessary */
/*****************************************************************************************************/
/********************************************************************/
/* this function process a command line and return its wait_revcon. */
/* no transfer is started. Only /DL and /LS are recognized.         */
/********************************************************************/
/* output: *ptr==NULL on error or the wait_revcon on success */
/*************************************************************/
void indirect_call_process_kbd_com(char *input, WAIT_REVCON **ptr);

/*****************************************************/
/* this function is called for each --precmd command */
/*****************************************************/
void process_precmd_command(char *input);

#endif
