#ifndef __LMP_H__
#define __LMP_H__

typedef struct
{
	/* values to provide */
	int record_size;						/* size of a record in the base */

	/* values filled by lmp_* */
	int fd;									/* file descriptor */
	int is_locked;							/* 0=fd is not locked, 1= fd is locked */
	void *mapped_addr;					/* address where the file is mapped into memory */
												/* NOTE: the first record is reserved for LMP */
	unsigned long mapped_size;			/* number of bytes mapped into memory */
	int nb_records;						/* number of records (== (int)(mapped_size/record_size) ) */
} LMP_ENTRY;

/******************************************************/
/* create a new LMP entry (and the file if not exist) */
/******************************************************/
/* output: a newly allocated LMP entry or NULL */
/***********************************************/
LMP_ENTRY *lmp_new(char *filename, int record_size);

/***********************************/
/* lock and map a file into memory */
/***********************************/
/* output: 0=ok, 1=error */
/*************************/
int lmp_lock_and_map(LMP_ENTRY *);

/*********************************************/
/* unmap file from memory, it remains locked */
/*********************************************/
void lmp_unmap(LMP_ENTRY *);

/**************************************************************/
/* unlock a file. If file is not yet unmapped, it is unmapped */
/**************************************************************/
void lmp_unmap_and_unlock(LMP_ENTRY *);

/***************************************************************/
/* close file and destroy LMP entry (the file remains present) */
/***************************************************************/
void lmp_close(LMP_ENTRY *);

/********************************************************************/
/* append the given record to the given LMP. The LMP must be locked */
/* After the call, the LMP remains locked but becomes unmapped      */
/********************************************************************/
/* output: 0=ok, 1=error */
/*************************/
int lmp_append_record(LMP_ENTRY *, void *value);

#endif
