#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "userinfo.h"
#include "lmp.h"
#include "misc.h"

static LMP_ENTRY *local_dctc_user_info_lmp=NULL;       /* LMP for the user information file */
																		/* NOTE: the first record (idx=0) of the file is always its header */

/****************************************************************************************************************/
/* these functions handles management of user informations stored in the file $HOME/.dctc/running/xxxx-userinfo */
/****************************************************************************************************************/

/************************************/
/* create the userinfo LMP and file */
/************************************/
void uinfo_create(char *filename)
{
	local_dctc_user_info_lmp=lmp_new(filename,sizeof(LMP_UINFO));
}

/**************************/
/* close the userinfo LMP */
/**************************/
void uinfo_delete()
{
	if(local_dctc_user_info_lmp)
	{
		lmp_close(local_dctc_user_info_lmp);
		local_dctc_user_info_lmp=NULL;
	}
}

/**********************************************/
/* find the array index of the given nickname */
/**********************************************/
/* output: idx or -1 if not found */
/**********************************/
static int uinfo_idx(char *nickname)
{
	int i;
	LMP_UINFO *lu=local_dctc_user_info_lmp->mapped_addr;

	for(i=1;i<local_dctc_user_info_lmp->nb_records;i++)
	{
		if(lu[i].entry_is_busy)
		{
			if(!strcmp(lu[i].nickname,nickname))
				return i;
		}
	}
	return -1;
}

/**********************************/
/* find a free entry in the array */
/**********************************/
/* output: idx or -1 if not found */
/**********************************/
static int uinfo_free_idx()
{
	int i;
	LMP_UINFO *lu=local_dctc_user_info_lmp->mapped_addr;

	for(i=1;i<local_dctc_user_info_lmp->nb_records;i++)
	{
		if(lu[i].entry_is_busy==0)
		{
			return i;
		}
	}
	return -1;
}

/*******************************************************/
/* add or update the information of the given nickname */
/*******************************************************/
void uinfo_update_user_info(char *nickname, char *usize, char *utype, unsigned char uflag, char *uemail, char *udesc)
{
	int idx;

	if(local_dctc_user_info_lmp==NULL)
		return;

	if(lmp_lock_and_map(local_dctc_user_info_lmp))
		return;

	idx=uinfo_idx(nickname);
	if(idx==-1)
	{
		idx=uinfo_free_idx();
	}

	if(idx!=-1)
	{
		/* 1) the entry already exists, just update it */
		/* 2) the entry does not exist but there is free space to add it */
		LMP_UINFO *udp=&(((LMP_UINFO*)(local_dctc_user_info_lmp->mapped_addr))[idx]);
		udp->entry_is_busy=1;											/* we set it to 1 because it can be an add or an update */
		strncpy_max(udp->nickname,nickname,UINFO_NICK_SIZE);
		sscanf(usize,"%lld",&(udp->share_size));
		strncpy_max(udp->cnx_type,utype,UINFO_CNX_SIZE);
		udp->uflag=uflag;
		strncpy_max(udp->uemail,uemail,UINFO_UEMAIL_SIZE);
		strncpy_max(udp->udesc,udesc,UINFO_UDESC_SIZE);
	}
	else
	{
		/* there is no free space, we must append the new record to the file */
		LMP_UINFO upd;
		upd.entry_is_busy=1;
		strncpy_max(upd.nickname,nickname,UINFO_NICK_SIZE);
		sscanf(usize,"%lld",&(upd.share_size));
		strncpy_max(upd.cnx_type,utype,UINFO_CNX_SIZE);
		upd.uflag=uflag;
		strncpy_max(upd.uemail,uemail,UINFO_UEMAIL_SIZE);
		strncpy_max(upd.udesc,udesc,UINFO_UDESC_SIZE);

		lmp_append_record(local_dctc_user_info_lmp,&upd);
	}
	lmp_unmap_and_unlock(local_dctc_user_info_lmp);
}

/************************************************/
/* delete the information of the given nickname */
/************************************************/
void uinfo_delete_user_info(char *nickname)
{
	int idx;

	if(local_dctc_user_info_lmp==NULL)
		return;

	if(lmp_lock_and_map(local_dctc_user_info_lmp))
		return;

	idx=uinfo_idx(nickname);
	if(idx!=-1)			/* idx should never be == -1 here except if the userinfo file was deleted */
	{
		((LMP_UINFO *)(local_dctc_user_info_lmp->mapped_addr))[idx].entry_is_busy=0;
	}
	lmp_unmap_and_unlock(local_dctc_user_info_lmp);
}

