/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * dctc_cmd.c: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <glib.h>

/* beginning of the code */
int main(int argc,char **argv)
{
	struct sockaddr_un name;
	GString *cmd;
	int output=0;
	int local_udp_socket;

	if(argc!=3)
	{
		fprintf(stderr,"Usage: %s unix_udp_socket_path DCTC_command\n"
							"       NOTE: dctc-link must be enabled on the DCTC you want to reach\n"
							,argv[0]);
		exit(1);
	}

	name.sun_family=AF_UNIX;
	strcpy(name.sun_path,argv[1]);

	cmd=g_string_new(argv[2]);
	cmd=g_string_append_c(cmd,'\n');
	
	local_udp_socket=socket(AF_UNIX,SOCK_DGRAM,0);

	if(sendto(local_udp_socket,cmd->str,cmd->len,MSG_NOSIGNAL|MSG_DONTWAIT,(void*)&name,sizeof(struct sockaddr_un))!=cmd->len)
	{
		perror("sendto");
		output=1;
	}
	g_string_free(cmd,TRUE);
	close(local_udp_socket);
	exit(output);
}

