/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * ls_cache.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __LS_CACHE_H__
#define __LS_CACHE_H__

/* description of LS_cache file format is inside Documentation/LS_cache file */

#define LS_CACHE_MAGIC	0x4C536430

typedef struct
{
	guint32 ls_magic;
	guint32 packed_size;
	guint32 unpacked_size;
	guint32 pack_algorithm;
	time_t retrieve_time;
	guint64 share_size;
} LS_CACHE_HEADER;

/******************/
/* pack algorithm */
/******************/
#define LS_CACHE_PACK_NONE  0
#define LS_CACHE_PACK_BZIP  1

/*************************************/
/* save /LS result in the cache file */
/********************************************************************/
/* input: nickname= the nickname of the user having this share list */
/*        ls_content= the formatted result of /LS                   */
/*        ttl_size= size of the shared files.                       */
/********************************************************************/
/* output: 0=ok, 1=error */
/*************************/
int save_ls_file(char *nickname,GString *ls_content, guint64 ttl_size);

/***************************************/
/* load /LS result from the cache file */
/********************************************************************/
/* input: nickname= the nickname of the user having this share list */
/*        ttl_size= variable to set to the size of the shared files.*/
/************************************************************************/
/* output: the content (to free with free() when no more useful or NULL */
/************************************************************************/
char *load_ls_file(char *nickname, guint64 *ttl_size);

#endif
