/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * var.h: Copyright (C) Eric Prevoteau <www@ac2i.tzo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __VAR_H__
#define __VAR_H__

#include <glib.h>
#include "hl_locks.h"

/*****************************************************/
/* this mutex locks all pointers of user description */
/* if you don't lock pointers, you may encounter     */
/* random crash.                                     */
/*****************************************************/
/* nickname, user_desc, cnx_type, email, host_ip */
/*************************************************/
extern HL_MUTEX user_info;				/* (un)LOCK_READ and (un)LOCK_WRITE */

/*******************************/
/* user description for DC hub */
/*******************************/
extern char *nickname;           /* user nickname */
extern char *org_nickname;       /* user nickname (this is the one given on the command line. */
                                 /* it is used when following hub redirection and reconnection) */

extern char *user_desc;             /* user description (can be NULL) */
extern char *cnx_type;              /* connection type. (ex: DSL,Cable,...) */
extern char cnx_opt;                /* user status */
                                 /* bit 0 always set. */
                                 /* bit 1 ? ==0, user here, ==1, user away */
                                 /* bit 2 ? ==0, normal, ==1, is server */
                                 /*         according to DC doc, a server is a client online */
                                 /*         for more than 2 jours.                           */
                                 /* bit 3 ? ==0, normal, ==1, fast upload */
                                 /*         according to DC doc, a fast upload is a client */
                                 /*         having an upload speed greater than 100KB/s. */

extern char *email;                 /* user e-mail (can be NULL) */
extern double sizeof_data;          /* size of the data shared by this client */
extern double offset_sizeof_data;	/* when the client has to return the size of data it shares, this value */
												/* is added to the previous one */

#if 0
extern int free_dl_slot;         /* number of free download slot */
                                 /* NOTE: this number can be negative for 2 reasons: */
                                 /* 1) you have reduced the ttl_dl_slot value under the number of running uploads */
                                 /* 2) a user having the IGNORE_SLOT_LIMIT flag is downloading */

extern int ttl_dl_slot;             /* number of existing download slot */
#endif

extern int dl_on;                /* this flag enables or disables the upload capability */
                                 /* if ==1, other users can download from you */
                                 /* if ==0, other users cannot download from you */
                                 /* this flag doesn't affect free_dl_slot/ttl_dl_slot */
                                 /* you still return the original value. If someone want to download, */
                                 /* the client will just return a "no more slot" message. */

extern char *nick_passwd;			/* when the hub wants a password. We will use the one here */
											/* if ==NULL, the client waits one before resuming */

extern GString *dctc_rating_gs;	/* this value is not used by DCTC, it is only kept here */

/**************************************/
/* description of the connection type */
/**************************************/
/* (BHF means behind firewall) */
/*******************************/
extern int behind_fw;               /* !=0, host is behind firewall */
extern unsigned short com_port;     /* port available, to receive data if not behind fw */
                                    /* default value is 412 but it is not very good     */
                                    /* because port below 1024 are not allowed for      */
                                    /* non-privileged users under Un*x                  */
extern char *host_ip;               /* ip of this host */

extern int dynamic_ip_flag;      /* if ==0, once host_ip has been filled, it is never updated (static IP) */
                                 /* else ==1, the host_ip is recomputed each time before connecting the hub */

extern GString *org_hubip; /* strings received from the -g flag */
                           /* don't use it except you need the original -g parameter */
extern GString *hubip;       /* IP of the hub where we are connected */
extern unsigned int hub_port; /* port of the hub where we are connected (411 is the default port) */
extern GString *hubname;     /* Name of the hub where we are connected (filed when connected) */

extern unsigned int hub_tos; // TOS value to set on hub connections
extern unsigned int udp_tos; // TOS value to set on udp (search) pakets
extern unsigned int dl_tos; // TOS value to set on download connections
extern unsigned int ul_tos; // TOS value to set on upload connections

extern unsigned int unode_port;   /* default port number for UNODE */
extern unsigned int wanted_unode_port;  /* port number for UNODE. If you want to change UNODE port, change this value, not the one above */

extern int follow_force_move;   /* does the client accept $ForceMove and $OpForceMove */

extern unsigned int recon_delay;  /* number of seconds before the hub connection loss and the /RECON */
extern unsigned int auto_rebuild_delay; /* number of seconds between 2 rebuilds of the shared database */
														/* 0== auto-rebuild disabled */
unsigned int auto_scan_delay;	/* number of seconds between 2 GDL autoscan */

extern int main_sck;				/* it is the socket connected to the hub */
extern int cnx_in_progress;	/* this flag is set when main_sck is !=-1 but the connect stage is not yet done */

extern int in_sck;				/* it is the socket to use as com port (-1=no socket else socket descriptor) */
extern int srch_sck;				/* it is the UDP socket used to receive active search result (-1=no socket) */
              						/* it uses the same port number has in_sck */

extern int keyb_fd;        /* it is the keyboard fd */
                           /* must be ==0. If the client loses its term, goes to -1 */

extern int when_done;      /* when a download is done, ==0, do nothing */
                           /* ==1, move the file into the done/ directory */

extern int wanna_emode;		/* when the --mdc flag is used, this variable contains the flag value */
extern int having_emode;	/* depending of the connected hub, the current emode may differ from the */
                           /* wanted emode, 0 is the default DC mode */

extern int with_md5sum;		/* enable/disable md5sum for content search */

extern int with_ddl;			/* enable/disable dDL capability */
extern int with_dctclink;	/* enable/disable link between dctc clients */
extern int grab_ban_ip;		/* enable/disable IP grabbing of banned users */

extern int with_dl_force;	/* enable/disable download forcing when a twin download occurs */

extern int hide_absolute;	/* hide/show the / (\ seen on DC) at the beginning of the returned search result and file list */

extern int abort_upload_when_user_leaves;
                           /* abort the remote user upload when a user leaves the hub */

extern unsigned int max_running_source_per_gdl;
									/* limit the number of running sources per GDL */
extern unsigned int disable_gdl_as_when_enough_running;
									/* disable one GDL's autoscan if enough running sources are available */

extern int hide_kick;        /* hide/show the kick message displayed on the global chat when a user is kicked */

extern int with_lazy_key_check;  /* enable/disable lazy $Key check */

extern int with_incoming_wake_up;/* enable/disable wakeup of waiting GDL source when a user with a "wanted" nickname enters the hub */
extern int with_sr_wake_up;		/* enable/disable wakeup of waiting GDL source when a search result with a "wanted" nickname has free slot */

extern int min_gdl_wake_up_delay;  /* at least X seconds between waking up source of the same user */

extern int max_dl_per_user;    /* maximum number of downloads from each user (<=0 :unlimited) */

extern int gdl_as_port_range[2];     /* lower and upper value of GDL autoscan port range */

extern int min_delay_between_search;	/* delay to wait between 2 search queries */

/************************************************************/
/* debug mode. ==0, no debug. !=0, debug mode               */
/* if debug_mode is set, all debug messages will be printed */
/************************************************************/
extern int debug_mode;

extern int force_quit;	/* if ==1, when /QUIT is called, it doesn't wait end of xfers */

/*******************************************************************/
/* the following vars are used to manage the local AF_UNIX sockets */
/*******************************************************************/
extern GString *dctc_dir;									/* =$(HOME)/.dctc */
extern GString *local_dctc_sock_path;             /* local name = $(dctc_dir)/running/dctc-xxxxxxxx-yyyyyyyyyy */
extern int local_sck;                             /* main local socket (to accept connection) */
extern GString *local_dctc_udp_sock_path;
extern int local_sck_udp;

G_LOCK_EXTERN(local_client_socket);
extern GArray *local_client_socket;               /* array of all locally connected socket */

extern const char *dc_version;									/* version of DC to use */

extern GString *dctc_active_client_file;				/* file containing status of all dctc clients */

extern GString *dctc_ls_cache_dir;                /* == dctc_dir/ls_cache/ */


/*****************************************/
/* information to limit upload bandwidth */
/*****************************************/
extern int bl_semid;

G_LOCK_EXTERN(inet_ntoa);					/* inet_ntoa is not thread safe, this prevents error */

#endif
