#ifndef __HE3_H__
#define __HE3_H__

/**************************************************/
/* decompress data compressed using HE3 algorithm */ 
/**********************************************************/
/* input: a GByteArray containing HE3 compressed data     */
/* output: a GString containing uncompressed data or NULL */
/**********************************************************/
GString *decode_he3_data(GByteArray *data);

/*****************************************************************************************/
/* compress data compressed using an Huffman algorithm and store it in HE3 usable format */
/*****************************************************************************************/
/* input: a GString containing a string to compress        */
/* output: a GByteArray containing compressed data or NULL */
/***********************************************************/
GByteArray *encode_he3_data(GString *str);

#endif
