/******************************************************************************
 *
 * $Id: translator_jp.h,v 1.9 2001/03/19 19:27:42 root Exp $
 *
 * Copyright (C) 1997-2000 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#ifndef TRANSLATOR_JP_H
#define TRANSLATOR_JP_H

#include "translator_adapter.h"

class TranslatorJapanese : public TranslatorAdapter_1_2_5
{
  public:
    QCString idLanguage()
    { return "japanese"; }
    /*! returns the name of the package that is included by LaTeX */
    QCString latexBabelPackage()
    { return "english"; }
    QCString idLanguageCharset()
    { return "euc-jp"; }

    /*! used in the compound documentation before a list of related functions. */
    QCString trRelatedFunctions()
    { return "Ϣؿ"; }

    /*! subscript for the related functions. */
    QCString trRelatedSubscript()
    { return "ʤϥдؿǤʤȤա"; }

    /*! header that is put before the detailed description of files, classes and namespaces. */
    QCString trDetailedDescription()
    { return ""; }

    /*! header that is put before the list of typedefs. */
    QCString trMemberTypedefDocumentation()
    { return "зβ"; }
    
    /*! header that is put before the list of enumerations. */
    QCString trMemberEnumerationDocumentation()
    { return "󷿤β"; }
    
    /*! header that is put before the list of member functions. */
    QCString trMemberFunctionDocumentation()
    { return "дؿβ"; }
    
    /*! header that is put before the list of member attributes. */
    QCString trMemberDataDocumentation()
    { return "Хǡβ"; }

    /*! this is the text of a link put after brief descriptions. */
    QCString trMore()
    { return "ܤ..."; }

    /*! put in the class documentation */
    QCString trListOfAllMembers()
    { return "٤ƤΥХꥹ"; }

    /*! used as the title of the "list of all members" page of a class */
    QCString trMemberList()
    { return "Хꥹ"; }

    /*! this is the first part of a sentence that is followed by a class name */
    QCString trThisIsTheListOfAllMembers()
    { return "ХꥹȤǤ"; }

    /*! this is the remainder of the sentence after the class name */
    QCString trIncludingInheritedMembers()
    { return "ѾФ⤹٤ƴޤǤޤ"; }
    
    /*! this is put at the author sections at the bottom of man pages.
     *  parameter s is name of the project name.
     */
    QCString trGeneratedAutomatically(const char *s)
    { QCString result;
      if (s) result=(QCString)s+"";
      result+="ɤ Doxygen ưŪޤ";
      return result;
    }

    /*! put after an enum name in the list of all members */
    QCString trEnumName()
    { return "enum "; }
    
    /*! put after an enum value in the list of all members */
    QCString trEnumValue()
    { return "enum "; }
    
    /*! put after an undocumented member in the list of all members */
    QCString trDefinedIn()
    { return "ޤ"; }

    /*! put as in introduction in the verbatim header file of a class.
     *  parameter f is the name of the include file.
     */
    QCString trVerbatimText(const char *f)
    { return (QCString)"ϥ󥯥롼ɥե"+f+"ƤǤ"; }

    // quick reference sections

    /*! This is put above each page as a link to the list of all groups of 
     *  compounds or files (see the \group command).
     */
    QCString trModules()
    { return "⥸塼"; }
    
    /*! This is put above each page as a link to the class hierarchy */
    QCString trClassHierarchy()
    { return "饹"; }
    
    /*! This is put above each page as a link to the list of annotated classes */
    QCString trCompoundList()
    { return "ǡ¤ꥹ"; }
    
    /*! This is put above each page as a link to the list of documented files */
    QCString trFileList()
    { return "եꥹ"; }

    /*! This is put above each page as a link to the list of all verbatim headers */
    QCString trHeaderFiles()
    { return "إåե"; }

    /*! This is put above each page as a link to all members of compounds. */
    QCString trCompoundMembers()
    { return "ǡ¤"; }

    /*! This is put above each page as a link to all members of files. */
    QCString trFileMembers()
    { return "ե"; }

    /*! This is put above each page as a link to all related pages. */
    QCString trRelatedPages()
    { return "Ϣڡ"; }

    /*! This is put above each page as a link to all examples. */
    QCString trExamples()
    { return ""; }

    /*! This is put above each page as a link to the search engine. */
    QCString trSearch()
    { return ""; }

    /*! This is an introduction to the class hierarchy. */
    QCString trClassHierarchyDescription()
    { return "ηѾꥹȤϤޤˤϥȤƤޤ"
             "ե٥åȽǴ˥ȤƤϤޤ";
    }

    /*! This is an introduction to the list with all files. */
    QCString trFileListDescription(bool extractAll)
    {
      QCString result="ΥꥹȤϡ";
      if (!extractAll) result+="ɥȲ졢";
      result+="ʰĥե뤹٤ƤΥꥹȤǤ";
      return result;
    }

    /*! This is an introduction to the annotated compound list. */
    QCString trCompoundListDescription()
    { return "ϴʰġ饹¤ΡΤΥꥹȤǤ";}

    /*! This is an introduction to the page with all class members. */
    QCString trCompoundMembersDescription(bool extractAll)
    {
      QCString result="";
      if (!extractAll) result+="ɥȲ줿";
      result+="饹Ф٤ƤΥꥹȤǡ줾";
      if (extractAll) result+="°Ƥ륯饹";
      result+="βؤΥ󥯤ĥƤޤ";
      return result;
    }

    /*! This is an introduction to the page with all file members. */
    QCString trFileMembersDescription(bool extractAll)
    {
      QCString result="";
      if (!extractAll) result+="ɥȲ줿";
      result+="եФ٤ƤΥꥹȤǡ줾";
      if (extractAll) result+="°Ƥե";
      result+="βؤΥ󥯤ĥƤޤ";
      return result;
    }

    /*! This is an introduction to the page with the list of all header files. */
    QCString trHeaderFilesDescription()
    { return "APIإåեǤ"; }

    /*! This is an introduction to the page with the list of all examples */
    QCString trExamplesDescription()
    { return "٤ƤΥꥹȤǤ"; }

    /*! This is an introduction to the page with the list of related pages */
    QCString trRelatedPagesDescription()
    { return "Ϣɥȥڡ٤ƤΥꥹȤǤ"; }

    /*! This is an introduction to the page with the list of class/file groups */
    QCString trModulesDescription()
    { return "٤ƤΥ⥸塼ΥꥹȤǤ"; }

    /*! This sentences is used in the annotated class/file lists if no brief
     * description is given. 
     */
    QCString trNoDescriptionAvailable()
    { return "ɥȤҤƤޤ"; }
    
    // index titles (the project name is prepended for these) 


    /*! This is used in HTML as the title of index.html. */
    QCString trDocumentation()
    { return "ɥ"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * index of all groups.
     */
    QCString trModuleIndex()
    { return "⥸塼"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * class hierarchy.
     */
    QCString trHierarchicalIndex()
    { return "غ"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * annotated compound index.
     */
    QCString trCompoundIndex()
    { return "ǡ¤"; }

    /*! This is used in LaTeX as the title of the chapter with the
     * list of all files.
     */
    QCString trFileIndex() 
    { return "ե"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all groups.
     */
    QCString trModuleDocumentation()
    { return "⥸塼β"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all classes, structs and unions.
     */
    QCString trClassDocumentation()
    { return "饹β"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all files.
     */
    QCString trFileDocumentation()
    { return "եβ"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all examples.
     */
    QCString trExampleDocumentation()
    { return "β"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all related pages.
     */
    QCString trPageDocumentation()
    { return "ڡβ"; }

    /*! This is used in LaTeX as the title of the document */
    QCString trReferenceManual()
    { return "ե󥹥ޥ˥奢"; }
    
    /*! This is used in the documentation of a file as a header before the 
     *  list of defines
     */
    QCString trDefines()
    { return "ޥ"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of function prototypes
     */
    QCString trFuncProtos()
    { return "ؿץȥ"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of typedefs
     */
    QCString trTypedefs()
    { return ""; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of enumerations
     */
    QCString trEnumerations()
    { return ""; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) functions
     */
    QCString trFunctions()
    { return "ؿ"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    QCString trVariables()
    { return "ѿ"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    QCString trEnumerationValues()
    { return ""; }
    
    /*! This is used in man pages as the author section. */
    QCString trAuthor()
    { return ""; }

    /*! This is used in the documentation of a file before the list of
     *  documentation blocks for defines
     */
    QCString trDefineDocumentation()
    { return "ޥβ"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for function prototypes
     */
    QCString trFunctionPrototypeDocumentation()
    { return "ؿץȥפβ"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for typedefs
     */
    QCString trTypedefDocumentation()
    { return "β"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration types
     */
    QCString trEnumerationTypeDocumentation()
    { return "󷿤β"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration values
     */
    QCString trEnumerationValueDocumentation()
    { return "ͤβ"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for functions
     */
    QCString trFunctionDocumentation()
    { return "ؿβ"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for variables
     */
    QCString trVariableDocumentation()
    { return "ѿβ"; }

    /*! This is used in the documentation of a file/namespace/group before 
     *  the list of links to documented compounds
     */
    QCString trCompounds()
    { return "ǡ¤"; }

    /*! This is used in the documentation of a group before the list of 
     *  links to documented files
     */
    QCString trFiles()
    { return "ե"; }

    /*! This is used in the standard footer of each page and indicates when 
     *  the page was generated 
     */
    QCString trGeneratedAt(const char *date,const char *projName)
    { 
      QCString result;
      if (projName) result+=(QCString)projName+"Ф";
      result+=(QCString)date+"ޤ";
      return result;
    }
    /*! This is part of the sentence used in the standard footer of each page.
     */
    QCString trWrittenBy()
    {
      return "γȯ:";
    }

    /*! this text is put before a class diagram */
    QCString trClassDiagram(const char *clName)
    {
      return (QCString)clName+"Ф륯饹ؿ";
    }
    
    /*! this text is generated when the \\internal command is used. */
    QCString trForInternalUseOnly()
    { return "ѤΤߡ"; }

    /*! this text is generated when the \\reimp command is used. */
    QCString trReimplementedForInternalReasons()
    { return "ŪͳˤƼޤAPIˤϱƶޤ";
    }

    /*! this text is generated when the \\warning command is used. */
    QCString trWarning()
    { return "ٹ"; }

    /*! this text is generated when the \\bug command is used. */
    QCString trBugsAndLimitations()
    { return "Х"; }

    /*! this text is generated when the \\version command is used. */
    QCString trVersion()
    { return "С"; }

    /*! this text is generated when the \\date command is used. */
    QCString trDate()
    { return ""; }

    /*! this text is generated when the \\author command is used. */
    QCString trAuthors()
    { return ""; }

    /*! this text is generated when the \\return command is used. */
    QCString trReturns()
    { return ""; }

    /*! this text is generated when the \\sa command is used. */
    QCString trSeeAlso()
    { return ""; }

    /*! this text is generated when the \\param command is used. */
    QCString trParameters()
    { return ""; }

    /*! this text is generated when the \\exception command is used. */
    QCString trExceptions()
    { return "㳰"; }
    
    /*! this text is used in the title page of a LaTeX document. */
    QCString trGeneratedBy()
    { return ""; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990307
//////////////////////////////////////////////////////////////////////////
    
    /*! used as the title of page containing all the index of all namespaces. */
    QCString trNamespaceList()
    { return "֥̾ꥹ"; }

    /*! used as an introduction to the namespace list */
    QCString trNamespaceListDescription(bool extractAll)
    {
      QCString result="ΥꥹȤϡʰĤ٤Ƥ";
      if (!extractAll) result+="ɥȲ줿";
      result+="֤̾ΥꥹȤǤ";
      return result;
    }

    /*! used in the class documentation as a header before the list of all
     *  friends of a class
     */
    QCString trFriends()
    { return "ե"; }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990405
//////////////////////////////////////////////////////////////////////////
    
    /*! used in the class documentation as a header before the list of all
     * related classes 
     */
    virtual QCString trRelatedFunctionDocumentation()
    { return "եɤȴϢؿβ"; }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990425
//////////////////////////////////////////////////////////////////////////

    /*! used as the title of the HTML page of a class/struct/union */
    QCString trCompoundReference(const char *clName,
                                 ClassDef::CompoundType compType,
                                 bool /*isTemplate*/)
    {
      QCString result="";
      switch(compType)
      {
        case ClassDef::Class:      result+="饹 "; break;
        case ClassDef::Struct:     result+="¤ "; break;
        case ClassDef::Union:      result+=" "; break;
        case ClassDef::Interface:  result+="󥿥ե"; break;
        case ClassDef::Exception:  result+="Exception "; break; //TODO:fixme
      }
      result+=(QCString)clName+" β";
      return result;
    }

    /*! used as the title of the HTML page of a file */
    QCString trFileReference(const char *fileName)
    {
      QCString result="ե "+(QCString)fileName+" β"; 
      return result;
    }

    /*! used as the title of the HTML page of a namespace */
    QCString trNamespaceReference(const char *namespaceName)
    {
      QCString result="̾ "+(QCString)namespaceName+" β";
      return result;
    }
    
    /* these are for the member sections of a class, struct or union */
    QCString trPublicMembers()
    { return ""; }
    QCString trPublicSlots()
    { return "å"; }
    QCString trSignals()
    { return "ʥ"; }
    QCString trStaticPublicMembers()
    { return "Ū"; }
    QCString trProtectedMembers()
    { return "ݸ"; }
    QCString trProtectedSlots()
    { return "ݸå"; }
    QCString trStaticProtectedMembers()
    { return "Ūݸ"; }
    QCString trPrivateMembers()
    { return ""; }
    QCString trPrivateSlots()
    { return "å"; }
    QCString trStaticPrivateMembers()
    { return "Ū"; }
    
    /*! this function is used to produce a comma-separated list of items.
     *  use generateMarker(i) to indicate where item i should be put.
     */
    QCString trWriteList(int numEntries)
    {
      QCString result;
      int i;
      // the inherits list contain `numEntries' classes
      for (i=0;i<numEntries;i++) 
      {
        // use generateMarker to generate placeholders for the class links!
        result+=generateMarker(i); // generate marker for entry i in the list 
                                   // (order is left to right)
        
        if (i!=numEntries-1)  // not the last entry, so we need a separator
        {
          if (i<numEntries-2) // not the fore last entry 
            result+=", ";
          else                // the fore last entry
            result+=",  ";
        }
      }
      return result; 
    }
    
    /*! used in class documentation to produce a list of base classes,
     *  if class diagrams are disabled.
     */
    QCString trInheritsList(int numEntries)
    {
      return trWriteList(numEntries)+"ѾƤޤ";
    }

    /*! used in class documentation to produce a list of super classes,
     *  if class diagrams are disabled.
     */
    QCString trInheritedByList(int numEntries)
    {
      return trWriteList(numEntries)+"˷ѾƤޤ";
    }

    /*! used in member documentation blocks to produce a list of 
     *  members that are hidden by this one.
     */
    QCString trReimplementedFromList(int numEntries)
    {
      return trWriteList(numEntries)+"Ƥޤ";
    }

    /*! used in member documentation blocks to produce a list of
     *  all member that overwrite the implementation of this member.
     */
    QCString trReimplementedInList(int numEntries)
    {
      return trWriteList(numEntries)+"ǺƤޤ";
    }

    /*! This is put above each page as a link to all members of namespaces. */
    QCString trNamespaceMembers()
    { return "֥̾"; }

    /*! This is an introduction to the page with all namespace members */
    QCString trNamespaceMemberDescription(bool extractAll)
    { 
	QCString result="";
      if (!extractAll) result+="ɥȲ줿";
      result+="֤̾٤ƤΥꥹȤǡ줾";
      if (extractAll) 
	  result+="֤̾β";
      else 
	  result+="°Ƥ̾";
      result+="ؤΥ󥯤ĥƤޤ";
      return result;
    }
    /*! This is used in LaTeX as the title of the chapter with the 
     *  index of all namespaces.
     */
    QCString trNamespaceIndex()
    { return "ֺ̾"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all namespaces.
     */
    QCString trNamespaceDocumentation()
    { return "֤̾β"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990522
//////////////////////////////////////////////////////////////////////////

    /*! This is used in the documentation before the list of all
     *  namespaces in a file.
     */
    QCString trNamespaces()
    { return "̾"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990728
//////////////////////////////////////////////////////////////////////////

    /*! This is put at the bottom of a class documentation page and is
     *  followed by a list of files that were used to generate the page.
     */
    QCString trGeneratedFromFiles(ClassDef::CompoundType compType,
        bool)
    { // here s is one of " Class", " Struct" or " Union"
      // single is true implies a single file
      QCString result=(QCString)"";
      switch(compType)
      {
        case ClassDef::Class:      result+="饹"; break;
        case ClassDef::Struct:     result+="¤"; break;
        case ClassDef::Union:      result+=""; break;
        case ClassDef::Interface:  result+="󥿥ե"; break;
        case ClassDef::Exception:  result+="Exception"; break; //TODO:fixme
      }
      result+="βϼΥե뤫ޤ:";
      return result;
    }

    /*! This is in the (quick) index as a link to the alphabetical compound
     * list.
     */
    QCString trAlphabeticalList()
    { return "ե٥åȽꥹ"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990901
//////////////////////////////////////////////////////////////////////////

    /*! This is used as the heading text for the retval command. */
    QCString trReturnValues()
    { return ""; }

    /*! This is in the (quick) index as a link to the main page (index.html)
     */
    QCString trMainPage()
    { return "ᥤڡ"; }

    /*! This is used in references to page that are put in the LaTeX 
     *  documentation. It should be an abbreviation of the word page.
     */
    QCString trPageAbbreviation()
    { return "p."; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-991003
//////////////////////////////////////////////////////////////////////////

    QCString trSources()
    {
      return "";
    }
    QCString trDefinedAtLineInSourceFile()
    {
      return "ե @1  @0 ԤƤޤ";
    }
    QCString trDefinedInSourceFile()
    {
      return "ե @0 Ƥޤ";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.0.0
//////////////////////////////////////////////////////////////////////////

    QCString trDeprecated()
    {
      return "Deprecated";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.0
//////////////////////////////////////////////////////////////////////////

    /*! this text is put before a collaboration diagram */
    QCString trCollaborationDiagram(const char *clName)
    {
      return (QCString)clName+"Υܥ졼";
    }
    /*! this text is put before an include dependency graph */
    QCString trInclDepGraph(const char *fName)
    {
	return (QCString)fName+"Υ󥯥롼ɰ¸ط";
    }
    /*! header that is put before the list of constructor/destructors. */
    QCString trConstructorDocumentation()
    {
      return "󥹥ȥ饯ȥǥȥ饯β"; 
    }
    /*! Used in the file documentation to point to the corresponding sources. */
    QCString trGotoSourceCode()
    {
      return "ΥեΥɤ򸫤롣";
    }
    /*! Used in the file sources to point to the corresponding documentation. */
    QCString trGotoDocumentation()
    {
      return "Υեβ򸫤롣";
    }
    /*! Text for the \\pre command */
    QCString trPrecondition()
    {
      return "";
    }
    /*! Text for the \\post command */
    QCString trPostcondition()
    {
      return "";
    }
    /*! Text for the \\invariant command */
    QCString trInvariant()
    {
      return "Invariant";
    }
    /*! Text shown before a multi-line variable/enum initialization */
    QCString trInitialValue()
    {
      return ":";
    }
    /*! Text used the source code in the file index */
    QCString trCode()
    {
      return "";
    }
    QCString trGraphicalHierarchy()
    {
      return "饹ؿ";
    }
    QCString trGotoGraphicalHierarchy()
    {
      return "饹ؿޤ򸫤롣";
    }
    QCString trGotoTextualHierarchy()
    {
      return "饹ؿ(ƥ)򸫤롣";
    }
    QCString trPageIndex()
    {
      return "ڡ";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.0
//////////////////////////////////////////////////////////////////////////
    
    QCString trNote()
    {
      return "Ф";
    }
    QCString trPublicTypes()
    {
      return "";
    }
    QCString trPublicAttribs()
    {
      return "°";
    }
    QCString trStaticPublicAttribs()
    {
      return "Ū°";
    }
    QCString trProtectedTypes()
    {
      return "ݸ";
    }
    QCString trProtectedAttribs()
    {
      return "ݸ°";
    }
    QCString trStaticProtectedAttribs()
    {
      return "Ūݸ°";
    }
    QCString trPrivateTypes()
    {
      return "";
    }
    QCString trPrivateAttribs()
    {
      return "°";
    }
    QCString trStaticPrivateAttribs()
    {
      return "Ū°";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.3
//////////////////////////////////////////////////////////////////////////

    /*! Used as a marker that is put before a todo item */
    QCString trTodo()
    {
      return "TODO";
    }
    /*! Used as the header of the todo list */
    QCString trTodoList()
    {
      return "TODOꥹ";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.4
//////////////////////////////////////////////////////////////////////////

    QCString trReferencedBy()
    {
      return "ǻȤƤޤ";
    }
    QCString trRemarks()
    {
      return "ո";
    }
    QCString trAttention()
    {
      return "";
    }
    QCString trInclByDepGraph()
    {
	return "ΥդϡΥե뤬ɤΥե뤫ľܡŪ"
             "󥯥롼ɤƤ뤫򼨤Ƥޤ";
    }
    QCString trSince()
    {
      return "Since";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.1.5
//////////////////////////////////////////////////////////////////////////

    /*! title of the graph legend page */
    QCString trLegendTitle()
    {
      return "դ";
    }
    /*! page explaining how the dot graph's should be interpreted */
    QCString trLegendDocs()
    {
      return 
        "ΥڡǤϡdoxygen 줿դɤΤ褦ˤߤ褤"
        "ޤ<p>\n"
        "ͤƤߤޤ\n"
        "\\code\n"
        "/*! άƸʤ饹 */\n"
        "class Invisible { };\n\n"
        "/*! ά줿饹(ѾطϱƤ) */\n"
        "class Truncated : public Invisible { };\n\n"
        "/* doxygen ȤˤɥȤʤ饹 */\n"
        "class Undocumented { };\n\n"
        "/*! public ǷѾ줿饹 */\n"
        "class PublicBase : public Truncated { };\n\n"
        "/*! protected ǷѾ줿饹 */\n"
        "class ProtectedBase { };\n\n"
        "/*! private ǷѾ줿饹 */\n"
        "class PrivateBase { };\n\n"
        "/*! Ѿ줿饹ǻȤƤ륯饹 */\n"
        "class Used { };\n\n"
        "/*! ʣΥ饹ѾƤ̥饹 */\n"
        "class Inherited : public PublicBase,\n"
        "                  protected ProtectedBase,\n"
        "                  private PrivateBase,\n"
        "                  public Undocumented\n"
        "{\n"
        "  private:\n"
        "    Used *m_usedClass;\n"
        "};\n"
        "\\endcode\n"
        "եǡ \\c MAX_DOT_GRAPH_HEIGHT  200 ˥åȤ줿"
        "硢Τ褦ʥդȤʤޤ"
        "<p><center><img src=\"graph_legend.gif\"></center>\n"
        "<p>\n"
        "ΥΥܥåˤϼΤ褦ʰ̣ޤ\n"
        "<ul>\n"
        "<li>ɤĤ֤줿ܥåϡΥդб빽¤Τ䥯饹"
        "ɽޤ\n"
        "<li>ȤΥܥåϥɥȤ빽¤Τ䥯饹ɽޤ\n"
        "<li>ȤΥܥåϥɥȤʤ¤Τ䥯饹ɽޤ\n"
        "<li>ȤΥܥåϥɥȤ빽¤Τ䥯饹ɽޤ"
	  "ꤵ줿˼ޤʤ˷Ѿ޴ط򤹤٤ƿ޼"
	  "ȤǤʤäȤ򼨤ޤ"
        "</ul>\n"
        "ˤϼΤ褦ʰ̣ޤ\n"
        "<ul>\n"
        "<li>ĤĤΥ饹֤ public Ѿط򼨤ޤ\n"
        "<li>Ф protected Ѿط򼨤ޤ\n"
        "<li>֤ private Ѿط򼨤ޤ\n"
        "<li>ϡΥ饹¾Υ饹˴ޤޤƤꡢ"
	  "ѤƤ뤳Ȥ򼨤ޤޤؤƤ륯饹乽¤Τ"
	  "ɤѿǥǤ뤫Υ٥ȤƼƤޤ\n"
        "</ul>\n";
    }
    /*! text for the link to the legend page */
    QCString trLegend()
    {
      return "";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.2.0
//////////////////////////////////////////////////////////////////////////
    
    /*! Used as a marker that is put before a test item */
    QCString trTest()
    {
      return "ƥ";
    }
    /*! Used as the header of the test list */
    QCString trTestList()
    {
      return "ƥȥꥹ";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.1
//////////////////////////////////////////////////////////////////////////

    /*! Used as a section header for KDE-2 IDL methods */
    QCString trDCOPMethods()
    {
      return "DCOP᥽å";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.2.2
//////////////////////////////////////////////////////////////////////////

    /*! Used as a section header for IDL properties */
    QCString trProperties()
    {
      return "ץѥƥ";
    }
    /*! Used as a section header for IDL property documentation */
    QCString trPropertyDocumentation()
    {
      return "ץѥƥβ";
    }


//////////////////////////////////////////////////////////////////////////
// new since 1.2.4
//////////////////////////////////////////////////////////////////////////

    /*! Used for Java interfaces in the summary section of Java packages */
    virtual QCString trInterfaces()
    {
      return "󥿡ե";
    }
    /*! Used for Java classes in the summary section of Java packages */
    virtual QCString trClasses()
    {
      return "饹";
    }
    /*! Used as the title of a Java package */
    virtual QCString trPackage(const char *name)
    {
      return (QCString)"ѥå "+name;
    }
    /*! Title of the package index page */
    virtual QCString trPackageList()
    {
      return "ѥåꥹ";
    }
    /*! The description of the package index page */
    virtual QCString trPackageListDescription()
    {
      return "ʰĥѥåǤ";
    }
    /*! The link name in the Quick links header for each page */
    virtual QCString trPackages()
    {
      return "ѥå";
    }
    /*! Used as a chapter title for Latex & RTF output */
    virtual QCString trPackageDocumentation()
    {
      return "ѥåβ";
    }
    /*! Text shown before a multi-line define */
    virtual QCString trDefineValue()
    {
      return ":";
    }
};

#endif
