(require-library "function.ss")
(require-library "pretty.ss")

(define raw-hattori (call-with-input-file 
			(build-path (collection-path "games" "paint-by-numbers")
				    "raw-hattori.ss")
		      (lambda (x) (eval (read x)))))

(define (num-possibilities size col)
  (let* ([col-len (length col)]
	 [boxes (+ col-len 1)]
	 [balls (- size (+ (apply + col) col-len))])
    (if (< balls 0)
	0
	(f boxes balls))))

(define (f boxes balls)
  (/ (! (+ boxes balls -1))
     (* (! (- boxes 1)) (! balls))))

(define (! n)
  (cond
   [(zero? n) 1]
   [else (* n (! (- n 1)))]))

(define (badness rows cols)
  (let ([col-count (length rows)]
	[row-count (length cols)])
    (+ (apply + (map (lambda (x) (num-possibilities row-count x)) rows))
       (apply + (map (lambda (x) (num-possibilities col-count x)) cols)))))

(pretty-print
 (quicksort
  (let loop ([hattoris raw-hattori])
    (cond
     [(null? hattoris) empty]
     [else (let* ([hattori (car hattoris)]
		  [name (car hattori)]
		  [rows (cadr hattori)]
		  [cols (caddr hattori)])
	     (let ([badness (badness rows cols)])
	       (cons (list name badness)
		     (loop (cdr hattoris)))))]))
  (lambda (x y) (< (cadr x) (cadr y)))))

#|
;; result of previous expression
(("Hattori 81" 158)
  ("Hattori 1" 205)
  ("Hattori 3" 647)
  ("Hattori 82" 709)
  ("Hattori 4" 842)
  ("Hattori 124" 911)
  ("Hattori 126" 931)
  ("Hattori 116" 1242)
  ("Hattori 2" 1243)
  ("Hattori 9" 1260)
  ("Hattori 13" 1437)
  ("Hattori 6" 1490)
  ("Hattori 22" 1516)
  ("Hattori 7" 1671)
  ("Hattori 19" 1761)
  ("Hattori 11" 1774)
  ("Hattori 5" 1804)
  ("Hattori 98" 1844)
  ("Hattori 137" 1857)
  ("Hattori 99" 2089)
  ("Hattori 8" 2182)
  ("Hattori 44" 2452)
  ("Hattori 100" 2575)
  ("Hattori 38" 2635)
  ("Hattori 10" 2835)
  ("Hattori 92" 3010)
  ("Hattori 32" 3036)
  ("Hattori 131" 3080)
  ("Hattori 16" 3207)
  ("Hattori 56" 3732)
  ("Hattori 121" 3748)
  ("Hattori 48" 3867)
  ("Hattori 118" 3898)
  ("Hattori 61" 3989)
  ("Hattori 17" 4121)
  ("Hattori 28" 4177)
  ("Hattori 35" 4414)
  ("Hattori 58" 4449)
  ("Hattori 18" 4562)
  ("Hattori 46" 4620)
  ("Hattori 133" 4634)
  ("Hattori 84" 4666)
  ("Hattori 96" 4668)
  ("Hattori 12" 4709)
  ("Hattori 102" 5006)
  ("Hattori 86" 5031)
  ("Hattori 30" 5133)
  ("Hattori 87" 5133)
  ("Hattori 14" 5495)
  ("Hattori 130" 5502)
  ("Hattori 42" 5650)
  ("Hattori 45" 5763)
  ("Hattori 54" 5947)
  ("Hattori 43" 5991)
  ("Hattori 41" 6140)
  ("Hattori 23" 6169)
  ("Hattori 136" 6295)
  ("Hattori 26" 6510)
  ("Hattori 62" 6614)
  ("Hattori 53" 6675)
  ("Hattori 31" 6866)
  ("Hattori 63" 6876)
  ("Hattori 57" 7182)
  ("Hattori 29" 7318)
  ("Hattori 50" 7325)
  ("Hattori 135" 7595)
  ("Hattori 104" 7941)
  ("Hattori 20" 8126)
  ("Hattori 103" 8126)
  ("Hattori 34" 8324)
  ("Hattori 60" 8330)
  ("Hattori 55" 8375)
  ("Hattori 67" 8549)
  ("Hattori 27" 8637)
  ("Hattori 127" 8648)
  ("Hattori 15" 8674)
  ("Hattori 33" 8729)
  ("Hattori 95" 8732)
  ("Hattori 39" 8855)
  ("Hattori 24" 9051)
  ("Hattori 132" 9371)
  ("Hattori 51" 9450)
  ("Hattori 37" 9582)
  ("Hattori 125" 9648)
  ("Hattori 83" 9698)
  ("Hattori 70" 9937)
  ("Hattori 25" 9942)
  ("Hattori 120" 10033)
  ("Hattori 68" 10110)
  ("Hattori 85" 10517)
  ("Hattori 65" 10556)
  ("Hattori 74" 10901)
  ("Hattori 90" 10913)
  ("Hattori 21" 11220)
  ("Hattori 59" 11255)
  ("Hattori 64" 11317)
  ("Hattori 89" 11323)
  ("Hattori 112" 11355)
  ("Hattori 77" 11627)
  ("Hattori 73" 11705)
  ("Hattori 139" 11806)
  ("Hattori 75" 11989)
  ("Hattori 49" 12203)
  ("Hattori 101" 12500)
  ("Hattori 71" 12522)
  ("Hattori 47" 12626)
  ("Hattori 52" 12646)
  ("Hattori 66" 12762)
  ("Hattori 72" 12942)
  ("Hattori 88" 13166)
  ("Hattori 79" 13223)
  ("Hattori 107" 13368)
  ("Hattori 40" 13558)
  ("Hattori 94" 13567)
  ("Hattori 106" 15177)
  ("Hattori 80" 15306)
  ("Hattori 113" 15776)
  ("Hattori 93" 16352)
  ("Hattori 91" 17856)
  ("Hattori 69" 18918)
  ("Hattori 105" 19069)
  ("Hattori 78" 19968)
  ("Hattori 97" 20828)
  ("Hattori 117" 21432)
  ("Hattori 134" 22118)
  ("Hattori 76" 24896)
  ("Hattori 36" 25351)
  ("Hattori 129" 27863)
  ("Hattori 138" 36306)
  ("Hattori 114" 46788)
  ("Hattori 128" 60393)
  ("Hattori 119" 64012)
  ("Hattori 111" 106611)
  ("Hattori 123" 110847)
  ("Hattori 108" 288996)
  ("Hattori 115" 330042)
  ("Hattori 109" 469815)
  ("Hattori 110" 516937)
  ("Hattori 122" 5784954))
|#