(if (not (defined? 'SECTION))
    (load-relative "testing.ss"))

(define counter 0)
(define-macro counterM (lambda () (set! counter (add1 counter)) 88))

(let* ([test-counter
	(lambda (sexp)
	  (set! counter 0)
	  (eval sexp)
	  counter)])
  (test 1 test-counter '(begin0 1 (begin (counterM))))
  (test 1 test-counter '(begin0 (begin (counterM))))
  (test 1 test-counter '(lambda ()
			  (counterM)
			  1))
  (test 2 test-counter '(lambda ()
			  (counterM)
			  (counterM)
			  1))
  (test 2 test-counter '(lambda ()
			  (define x (counterM))
			  (define y (counterM))
			  1))
  (test 2 test-counter '(lambda ()
			  (lambda () (counterM))
			  (lambda () (counterM))
			  1))
  (test 1 test-counter '(lambda ()
			  (begin (counterM))
			  1))
  (test 2 test-counter '(lambda ()
			  (begin (counterM))
			  (begin (counterM))
			  1))
  (test 3 test-counter '(lambda ()
			  (begin (counterM))
			  (begin (counterM))
			  (begin (counterM))
			  1))
  (test 1 test-counter '(cond [1 (begin (counterM))]))
  (test 1 test-counter '(begin (cond [1 (counterM)])))
  (test 1 test-counter '(begin0 (cond [1 (counterM)]) 1))
  (test 1 test-counter '(let () (begin (counterM))))
  (test 1 test-counter '(begin (let () (counterM))))
  (test 1 test-counter '(begin0 (let () (counterM)) 1))
  
  (test 1 test-counter '(unit (import) (export) (counterM)))
  (test 2 test-counter '(unit (import) (export) (counterM) (counterM)))
  (test 1 test-counter '(unit (import) (export) (begin (counterM))))
  (test 2 test-counter '(unit (import) (export) (begin (counterM)) (begin (counterM))))
  (test 1 test-counter '(unit (import) (export) (begin0 (counterM))))
  (test 2 test-counter '(unit (import) (export) (begin0 (counterM)) (begin (counterM))))
  (test 1 test-counter '(unit (import) (export) (unit (import) (export) (counterM))))

  
  (test 1 test-counter '(begin (unit (import) (export) (counterM))))
  (test 2 test-counter '(begin (unit (import) (export) (counterM) (counterM))))
  (test 1 test-counter '(begin (unit (import) (export) (begin (counterM)))))
  (test 2 test-counter '(begin (unit (import) (export) (begin (counterM)) (begin (counterM)))))
  (test 1 test-counter '(begin (unit (import) (export) (begin0 (counterM)))))
  (test 2 test-counter '(begin (unit (import) (export) (begin0 (counterM)) (begin (counterM)))))
  (test 1 test-counter '(begin (unit (import) (export) (unit (import) (export) (counterM)))))

  (test 1 test-counter '(begin0 (unit (import) (export) (counterM))))
  (test 2 test-counter '(begin0 (unit (import) (export) (counterM) (counterM))))
  (test 1 test-counter '(begin0 (unit (import) (export) (begin (counterM)))))
  (test 2 test-counter '(begin0 (unit (import) (export) (begin (counterM)) (begin (counterM)))))
  (test 1 test-counter '(begin0 (unit (import) (export) (begin0 (counterM)))))
  (test 2 test-counter '(begin0 (unit (import) (export) (begin0 (counterM)) (begin (counterM)))))
  (test 1 test-counter '(begin0 (unit (import) (export) (unit (import) (export) (counterM)))))

  (test 1 test-counter '(begin0 1 (unit (import) (export) (counterM))))
  (test 2 test-counter '(begin0 1 (unit (import) (export) (counterM) (counterM))))
  (test 1 test-counter '(begin0 1 (unit (import) (export) (begin (counterM)))))
  (test 2 test-counter '(begin0 1 (unit (import) (export) (begin (counterM)) (begin (counterM)))))
  (test 1 test-counter '(begin0 1 (unit (import) (export) (begin0 (counterM)))))
  (test 2 test-counter '(begin0 1 (unit (import) (export) (begin0 (counterM)) (begin (counterM)))))
  (test 1 test-counter '(begin0 1 (unit (import) (export) (unit (import) (export) (counterM)))))
)
  
(report-errs)
