#
# Makefile.PL for egd, the entropy gathering daemon
#
# $Id: Makefile.PL,v 1.11 2000/05/14 01:56:00 warner Exp $
#

use ExtUtils::MakeMaker;

# This module is meant to function both by itself and as a part of GnuPG.

# By itself, just build with the usual 'perl Makefile.PL; make; make test;
#  sudo make install' sequence. This will install the daemon in your standard
#  perl script directory, frequently /usr/local/bin . As a daemon process that
#  may be run by the sysadmin at startup instead of by normal users, you might
#  want it in /usr/local/sbin instead. Set INSTALLBIN as an argument (see
#  below) to accomplish this.

# As a part of GPG, this Makefile.PL is run at configure time if EGD is needed
# for this system, probably because it doesn't have /dev/random, which
# generally means anything other than Linux. The top-level configure script
# should call us with two args:
#   FULLPERL=/path/to/perl   # this is the perl5 found by configure, and must
#                              be the same one as used to run this Makefile.PL
#   INSTALLBIN=/usr/local/sbin  # this is configure's $sbindir. 'egd' goes here

# We must test for the presence of the SHA module and arrange to build/install
# a local copy if it isn't already there.


# test for SHA
eval "use SHA;"; $SHA = $@ eq "";

if ($SHA) {
    print " SHA module found.. no need to install our own.\n";
} else {
    print " SHA module not found. We will install our own.\n";
}

# this is to turn the automake-style 'check' target into a MakeMaker-style
# 'test' target.
sub MY::postamble {
    "check :: test\n";
}

WriteMakefile(
	      NAME => "egd",
	      VERSION => "0.8",
	      EXE_FILES => [qw(egd.pl)],
# recent MakeMakers will fix up the shbang line in EXE_FILES. This will
# result in /usr/local/sbin/egd.pl being installed with whatever #! line is
# appropriate for this system.
	      DIR => $SHA ? [] : ['SHA-1.2'],
	      # DIR is the list of subdirs. If SHA is already installed, tell
	      # MakeMaker to pretend our copy isn't there.
	      PM => {}, # disable installation of egd.pl in library directory
	      'dist' => { COMPRESS => 'gzip', SUFFIX => 'gz' },
);
