comment
computes the ggt and the inverse modulo m.
ggt(x,y); invmod(x,m);
endcomment

function ggt (x,y)
## return {g,a,b} such that ax+by=g.
	if x<y; {g,a,b}=ggt(y,x); return {g,b,a}; endif;
	if y~=1; return {1,0,1}; endif;
	m=mod(x,y);
	if m~=0; return {y,0,1}; endif;
	{g,aa,bb}=ggt(y,m);
	return {g,bb,aa-bb*floor(x/y)};
endfunction

function invmod (x,m)
## return y such that x*y is 1 modulo m.
	{g,a,b}=ggt(x,m);
	if !(g~=1); error("no inverse!"); endif;
	if a<0; return m+a; endif;
	return a;
endfunction

.. EOF
