/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 17:36:51 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_twidsq -compact -variables 4 -reload-twiddle -dif -n 3 -name q1_3 -include q.h */

/*
 * This function contains 48 FP additions, 36 FP multiplications,
 * (or, 30 additions, 18 multiplications, 18 fused multiply/add),
 * 35 stack variables, and 36 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_twidsq.ml,v 1.14 2003/03/15 20:29:42 stevenj Exp $
 */

#include "q.h"

static const R *q1_3(R *rio, R *iio, const R *W, stride is, stride vs, int m, int dist)
{
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     int i;
     for (i = m; i > 0; i = i - 1, rio = rio + dist, iio = iio + dist, W = W + 4) {
	  E T1, T4, T6, Tc, Td, Te, T9, Tf, Tl, To, Tq, Tw, Tx, Ty, Tt;
	  E Tz, TR, TS, TN, TT, TF, TI, TK, TQ;
	  {
	       E T2, T3, Tr, Ts;
	       T1 = rio[0];
	       T2 = rio[WS(is, 1)];
	       T3 = rio[WS(is, 2)];
	       T4 = T2 + T3;
	       T6 = FNMS(KP500000000, T4, T1);
	       Tc = KP866025403 * (T3 - T2);
	       {
		    E T7, T8, Tm, Tn;
		    Td = iio[0];
		    T7 = iio[WS(is, 1)];
		    T8 = iio[WS(is, 2)];
		    Te = T7 + T8;
		    T9 = KP866025403 * (T7 - T8);
		    Tf = FNMS(KP500000000, Te, Td);
		    Tl = rio[WS(vs, 1)];
		    Tm = rio[WS(vs, 1) + WS(is, 1)];
		    Tn = rio[WS(vs, 1) + WS(is, 2)];
		    To = Tm + Tn;
		    Tq = FNMS(KP500000000, To, Tl);
		    Tw = KP866025403 * (Tn - Tm);
	       }
	       Tx = iio[WS(vs, 1)];
	       Tr = iio[WS(vs, 1) + WS(is, 1)];
	       Ts = iio[WS(vs, 1) + WS(is, 2)];
	       Ty = Tr + Ts;
	       Tt = KP866025403 * (Tr - Ts);
	       Tz = FNMS(KP500000000, Ty, Tx);
	       {
		    E TL, TM, TG, TH;
		    TR = iio[WS(vs, 2)];
		    TL = iio[WS(vs, 2) + WS(is, 1)];
		    TM = iio[WS(vs, 2) + WS(is, 2)];
		    TS = TL + TM;
		    TN = KP866025403 * (TL - TM);
		    TT = FNMS(KP500000000, TS, TR);
		    TF = rio[WS(vs, 2)];
		    TG = rio[WS(vs, 2) + WS(is, 1)];
		    TH = rio[WS(vs, 2) + WS(is, 2)];
		    TI = TG + TH;
		    TK = FNMS(KP500000000, TI, TF);
		    TQ = KP866025403 * (TH - TG);
	       }
	  }
	  rio[0] = T1 + T4;
	  iio[0] = Td + Te;
	  rio[WS(is, 1)] = Tl + To;
	  iio[WS(is, 1)] = Tx + Ty;
	  iio[WS(is, 2)] = TR + TS;
	  rio[WS(is, 2)] = TF + TI;
	  {
	       E Ta, Tg, T5, Tb;
	       Ta = T6 + T9;
	       Tg = Tc + Tf;
	       T5 = W[0];
	       Tb = W[1];
	       rio[WS(vs, 1)] = FMA(T5, Ta, Tb * Tg);
	       iio[WS(vs, 1)] = FNMS(Tb, Ta, T5 * Tg);
	  }
	  {
	       E TW, TY, TV, TX;
	       TW = TK - TN;
	       TY = TT - TQ;
	       TV = W[2];
	       TX = W[3];
	       rio[WS(vs, 2) + WS(is, 2)] = FMA(TV, TW, TX * TY);
	       iio[WS(vs, 2) + WS(is, 2)] = FNMS(TX, TW, TV * TY);
	  }
	  {
	       E TC, TE, TB, TD;
	       TC = Tq - Tt;
	       TE = Tz - Tw;
	       TB = W[2];
	       TD = W[3];
	       rio[WS(vs, 2) + WS(is, 1)] = FMA(TB, TC, TD * TE);
	       iio[WS(vs, 2) + WS(is, 1)] = FNMS(TD, TC, TB * TE);
	  }
	  {
	       E Tu, TA, Tp, Tv;
	       Tu = Tq + Tt;
	       TA = Tw + Tz;
	       Tp = W[0];
	       Tv = W[1];
	       rio[WS(vs, 1) + WS(is, 1)] = FMA(Tp, Tu, Tv * TA);
	       iio[WS(vs, 1) + WS(is, 1)] = FNMS(Tv, Tu, Tp * TA);
	  }
	  {
	       E TO, TU, TJ, TP;
	       TO = TK + TN;
	       TU = TQ + TT;
	       TJ = W[0];
	       TP = W[1];
	       rio[WS(vs, 1) + WS(is, 2)] = FMA(TJ, TO, TP * TU);
	       iio[WS(vs, 1) + WS(is, 2)] = FNMS(TP, TO, TJ * TU);
	  }
	  {
	       E Ti, Tk, Th, Tj;
	       Ti = T6 - T9;
	       Tk = Tf - Tc;
	       Th = W[2];
	       Tj = W[3];
	       rio[WS(vs, 2)] = FMA(Th, Ti, Tj * Tk);
	       iio[WS(vs, 2)] = FNMS(Tj, Ti, Th * Tk);
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 3},
     {TW_NEXT, 1, 0}
};

static const ct_desc desc = { 3, "q1_3", twinstr, {30, 18, 18, 0}, &GENUS, 0, 0, 0 };

void X(codelet_q1_3) (planner *p) {
     X(kdft_difsq_register) (p, q1_3, &desc);
}
