/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:41 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_noinline_c -simd -trivial-stores -compact -variables 4 -sign 1 -n 16 -name m1bv_16 -include n1b.h */

/*
 * This function contains 72 FP additions, 12 FP multiplications,
 * (or, 68 additions, 8 multiplications, 4 fused multiply/add),
 * 33 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_noinline_c.ml,v 1.1 2003/04/17 10:44:21 athena Exp $
 */

#include "n1b.h"

static void m1bv_16_0(const R *xi, R *xo, stride is, stride os, int ivs, int ovs)
{
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  V T12, T16, T1g, T1f, Tw, TH, Tq, TK, T1i, T1j, Tf, TI, Tz, TL, TZ;
	  V T17;
	  {
	       V Ti, T10, Tu, T14, Tl, T11, Tp, T15, Tv, Tm;
	       {
		    V Tg, Th, Ts, Tt;
		    Tg = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    Th = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    Ti = VSUB(Tg, Th);
		    T10 = VADD(Tg, Th);
		    Ts = LD(&(xi[0]), ivs, &(xi[0]));
		    Tt = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
		    Tu = VSUB(Ts, Tt);
		    T14 = VADD(Ts, Tt);
	       }
	       {
		    V Tj, Tk, Tn, To;
		    Tj = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
		    Tk = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Tl = VSUB(Tj, Tk);
		    T11 = VADD(Tj, Tk);
		    Tn = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    To = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
		    Tp = VSUB(Tn, To);
		    T15 = VADD(Tn, To);
	       }
	       T12 = VSUB(T10, T11);
	       T16 = VSUB(T14, T15);
	       T1g = VADD(T10, T11);
	       T1f = VADD(T14, T15);
	       Tv = VMUL(LDK(KP707106781), VADD(Ti, Tl));
	       Tw = VSUB(Tu, Tv);
	       TH = VADD(Tu, Tv);
	       Tm = VMUL(LDK(KP707106781), VSUB(Ti, Tl));
	       Tq = VSUB(Tm, Tp);
	       TK = VADD(Tp, Tm);
	  }
	  {
	       V T3, TT, Td, TX, T6, TU, Ta, TW, T7, Te;
	       {
		    V T1, T2, Tb, Tc;
		    T1 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T2 = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    TT = VADD(T1, T2);
		    Tb = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    Tc = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    Td = VSUB(Tb, Tc);
		    TX = VADD(Tb, Tc);
	       }
	       {
		    V T4, T5, T8, T9;
		    T4 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T5 = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    TU = VADD(T4, T5);
		    T8 = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
		    T9 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    Ta = VSUB(T8, T9);
		    TW = VADD(T8, T9);
	       }
	       T1i = VADD(TT, TU);
	       T1j = VADD(TW, TX);
	       T7 = VFNMS(LDK(KP382683432), T6, VMUL(LDK(KP923879532), T3));
	       Te = VFMA(LDK(KP923879532), Ta, VMUL(LDK(KP382683432), Td));
	       Tf = VSUB(T7, Te);
	       TI = VADD(T7, Te);
	       {
		    V Tx, Ty, TV, TY;
		    Tx = VFMA(LDK(KP382683432), T3, VMUL(LDK(KP923879532), T6));
		    Ty = VFNMS(LDK(KP382683432), Ta, VMUL(LDK(KP923879532), Td));
		    Tz = VSUB(Tx, Ty);
		    TL = VADD(Tx, Ty);
		    TV = VSUB(TT, TU);
		    TY = VSUB(TW, TX);
		    TZ = VMUL(LDK(KP707106781), VSUB(TV, TY));
		    T17 = VMUL(LDK(KP707106781), VADD(TV, TY));
	       }
	  }
	  {
	       V TB, TC, Tr, TA;
	       Tr = VBYI(VSUB(Tf, Tq));
	       TA = VSUB(Tw, Tz);
	       TB = VADD(Tr, TA);
	       TC = VSUB(TA, Tr);
	       ST(&(xo[WS(os, 5)]), TB, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 11)]), TC, ovs, &(xo[WS(os, 1)]));
	  }
	  {
	       V T1l, T1m, T1h, T1k;
	       T1h = VSUB(T1f, T1g);
	       T1k = VBYI(VSUB(T1i, T1j));
	       T1l = VSUB(T1h, T1k);
	       T1m = VADD(T1h, T1k);
	       ST(&(xo[WS(os, 12)]), T1l, ovs, &(xo[0]));
	       ST(&(xo[WS(os, 4)]), T1m, ovs, &(xo[0]));
	  }
	  {
	       V T1p, T1q, T1n, T1o;
	       T1n = VADD(T1f, T1g);
	       T1o = VADD(T1i, T1j);
	       T1p = VSUB(T1n, T1o);
	       T1q = VADD(T1n, T1o);
	       ST(&(xo[WS(os, 8)]), T1p, ovs, &(xo[0]));
	       ST(&(xo[0]), T1q, ovs, &(xo[0]));
	  }
	  {
	       V TF, TG, TD, TE;
	       TD = VBYI(VADD(Tq, Tf));
	       TE = VADD(Tw, Tz);
	       TF = VADD(TD, TE);
	       TG = VSUB(TE, TD);
	       ST(&(xo[WS(os, 3)]), TF, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 13)]), TG, ovs, &(xo[WS(os, 1)]));
	  }
	  {
	       V TN, TO, TJ, TM;
	       TJ = VADD(TH, TI);
	       TM = VBYI(VADD(TK, TL));
	       TN = VSUB(TJ, TM);
	       TO = VADD(TJ, TM);
	       ST(&(xo[WS(os, 15)]), TN, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 1)]), TO, ovs, &(xo[WS(os, 1)]));
	  }
	  {
	       V T19, T1a, T13, T18;
	       T13 = VBYI(VSUB(TZ, T12));
	       T18 = VSUB(T16, T17);
	       T19 = VADD(T13, T18);
	       T1a = VSUB(T18, T13);
	       ST(&(xo[WS(os, 6)]), T19, ovs, &(xo[0]));
	       ST(&(xo[WS(os, 10)]), T1a, ovs, &(xo[0]));
	  }
	  {
	       V T1d, T1e, T1b, T1c;
	       T1b = VBYI(VADD(T12, TZ));
	       T1c = VADD(T16, T17);
	       T1d = VADD(T1b, T1c);
	       T1e = VSUB(T1c, T1b);
	       ST(&(xo[WS(os, 2)]), T1d, ovs, &(xo[0]));
	       ST(&(xo[WS(os, 14)]), T1e, ovs, &(xo[0]));
	  }
	  {
	       V TR, TS, TP, TQ;
	       TP = VSUB(TH, TI);
	       TQ = VBYI(VSUB(TL, TK));
	       TR = VSUB(TP, TQ);
	       TS = VADD(TP, TQ);
	       ST(&(xo[WS(os, 9)]), TR, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 7)]), TS, ovs, &(xo[WS(os, 1)]));
	  }
     }
}

static void m1bv_16(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     int i;
     BEGIN_SIMD();
     for (i = 0; i < v; i += VL) {
	  m1bv_16_0(ii, io, is, os, ivs, ovs);
	  ii += VL * ivs;
	  io += VL * ovs;
     }
     END_SIMD();
}

static const kdft_desc desc = { 16, "m1bv_16", {68, 8, 4, 0}, &GENUS, 0, 0, 0, 0 };
void X(codelet_m1bv_16) (planner *p) {
     X(kdft_register) (p, m1bv_16, &desc);
}
