/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:02:43 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_noinline_c -simd -trivial-stores -compact -variables 4 -n 16 -name m2fv_16 -with-ostride 2 -include n2f.h */

/*
 * This function contains 72 FP additions, 12 FP multiplications,
 * (or, 68 additions, 8 multiplications, 4 fused multiply/add),
 * 33 stack variables, and 32 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_noinline_c.ml,v 1.1 2003/04/17 10:44:21 athena Exp $
 */

#include "n2f.h"

static void m2fv_16_0(const R *xi, R *xo, stride is, int ivs, int ovs)
{
     DVK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DVK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  V TV, T16, T1g, T1f, Tw, TH, Tq, TK, T1i, T1j, Tf, TI, Tz, TL, T12;
	  V T17;
	  {
	       V Ti, T14, Tu, TT, Tl, T15, Tp, TU, Tv, Tm;
	       {
		    V Tg, Th, Ts, Tt;
		    Tg = LD(&(xi[WS(is, 14)]), ivs, &(xi[0]));
		    Th = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    Ti = VSUB(Tg, Th);
		    T14 = VADD(Tg, Th);
		    Ts = LD(&(xi[0]), ivs, &(xi[0]));
		    Tt = LD(&(xi[WS(is, 8)]), ivs, &(xi[0]));
		    Tu = VSUB(Ts, Tt);
		    TT = VADD(Ts, Tt);
	       }
	       {
		    V Tj, Tk, Tn, To;
		    Tj = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    Tk = LD(&(xi[WS(is, 10)]), ivs, &(xi[0]));
		    Tl = VSUB(Tj, Tk);
		    T15 = VADD(Tj, Tk);
		    Tn = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    To = LD(&(xi[WS(is, 12)]), ivs, &(xi[0]));
		    Tp = VSUB(Tn, To);
		    TU = VADD(Tn, To);
	       }
	       TV = VSUB(TT, TU);
	       T16 = VSUB(T14, T15);
	       T1g = VADD(T15, T14);
	       T1f = VADD(TT, TU);
	       Tv = VMUL(LDK(KP707106781), VADD(Tl, Ti));
	       Tw = VADD(Tu, Tv);
	       TH = VSUB(Tu, Tv);
	       Tm = VMUL(LDK(KP707106781), VSUB(Ti, Tl));
	       Tq = VSUB(Tm, Tp);
	       TK = VADD(Tp, Tm);
	  }
	  {
	       V T3, TZ, Td, TX, T6, T10, Ta, TW, T7, Te;
	       {
		    V T1, T2, Tb, Tc;
		    T1 = LD(&(xi[WS(is, 15)]), ivs, &(xi[WS(is, 1)]));
		    T2 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    TZ = VADD(T1, T2);
		    Tb = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    Tc = LD(&(xi[WS(is, 13)]), ivs, &(xi[WS(is, 1)]));
		    Td = VSUB(Tb, Tc);
		    TX = VADD(Tb, Tc);
	       }
	       {
		    V T4, T5, T8, T9;
		    T4 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    T5 = LD(&(xi[WS(is, 11)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    T10 = VADD(T4, T5);
		    T8 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T9 = LD(&(xi[WS(is, 9)]), ivs, &(xi[WS(is, 1)]));
		    Ta = VSUB(T8, T9);
		    TW = VADD(T8, T9);
	       }
	       T1i = VADD(TW, TX);
	       T1j = VADD(TZ, T10);
	       T7 = VFNMS(LDK(KP923879532), T6, VMUL(LDK(KP382683432), T3));
	       Te = VFMA(LDK(KP382683432), Ta, VMUL(LDK(KP923879532), Td));
	       Tf = VSUB(T7, Te);
	       TI = VADD(Te, T7);
	       {
		    V Tx, Ty, TY, T11;
		    Tx = VFNMS(LDK(KP382683432), Td, VMUL(LDK(KP923879532), Ta));
		    Ty = VFMA(LDK(KP923879532), T3, VMUL(LDK(KP382683432), T6));
		    Tz = VADD(Tx, Ty);
		    TL = VSUB(Ty, Tx);
		    TY = VSUB(TW, TX);
		    T11 = VSUB(TZ, T10);
		    T12 = VMUL(LDK(KP707106781), VADD(TY, T11));
		    T17 = VMUL(LDK(KP707106781), VSUB(T11, TY));
	       }
	  }
	  {
	       V TB, TC, Tr, TA;
	       Tr = VBYI(VSUB(Tf, Tq));
	       TA = VSUB(Tw, Tz);
	       TB = VADD(Tr, TA);
	       TC = VSUB(TA, Tr);
	       ST(&(xo[14]), TB, ovs, &(xo[2]));
	       ST(&(xo[18]), TC, ovs, &(xo[2]));
	  }
	  {
	       V T1l, T1m, T1h, T1k;
	       T1h = VADD(T1f, T1g);
	       T1k = VADD(T1i, T1j);
	       T1l = VSUB(T1h, T1k);
	       T1m = VADD(T1h, T1k);
	       ST(&(xo[16]), T1l, ovs, &(xo[0]));
	       ST(&(xo[0]), T1m, ovs, &(xo[0]));
	  }
	  {
	       V T1p, T1q, T1n, T1o;
	       T1n = VSUB(T1f, T1g);
	       T1o = VBYI(VSUB(T1j, T1i));
	       T1p = VSUB(T1n, T1o);
	       T1q = VADD(T1n, T1o);
	       ST(&(xo[24]), T1p, ovs, &(xo[0]));
	       ST(&(xo[8]), T1q, ovs, &(xo[0]));
	  }
	  {
	       V TF, TG, TD, TE;
	       TD = VBYI(VADD(Tq, Tf));
	       TE = VADD(Tw, Tz);
	       TF = VADD(TD, TE);
	       TG = VSUB(TE, TD);
	       ST(&(xo[2]), TF, ovs, &(xo[2]));
	       ST(&(xo[30]), TG, ovs, &(xo[2]));
	  }
	  {
	       V TN, TO, TJ, TM;
	       TJ = VADD(TH, TI);
	       TM = VBYI(VADD(TK, TL));
	       TN = VSUB(TJ, TM);
	       TO = VADD(TJ, TM);
	       ST(&(xo[26]), TN, ovs, &(xo[2]));
	       ST(&(xo[6]), TO, ovs, &(xo[2]));
	  }
	  {
	       V T19, T1a, T13, T18;
	       T13 = VADD(TV, T12);
	       T18 = VBYI(VADD(T16, T17));
	       T19 = VSUB(T13, T18);
	       T1a = VADD(T13, T18);
	       ST(&(xo[28]), T19, ovs, &(xo[0]));
	       ST(&(xo[4]), T1a, ovs, &(xo[0]));
	  }
	  {
	       V T1d, T1e, T1b, T1c;
	       T1b = VSUB(TV, T12);
	       T1c = VBYI(VSUB(T17, T16));
	       T1d = VSUB(T1b, T1c);
	       T1e = VADD(T1b, T1c);
	       ST(&(xo[20]), T1d, ovs, &(xo[0]));
	       ST(&(xo[12]), T1e, ovs, &(xo[0]));
	  }
	  {
	       V TR, TS, TP, TQ;
	       TP = VSUB(TH, TI);
	       TQ = VBYI(VSUB(TL, TK));
	       TR = VSUB(TP, TQ);
	       TS = VADD(TP, TQ);
	       ST(&(xo[22]), TR, ovs, &(xo[2]));
	       ST(&(xo[10]), TS, ovs, &(xo[2]));
	  }
     }
}

static void m2fv_16(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     int i;
     BEGIN_SIMD();
     for (i = 0; i < v; i += VL) {
	  m2fv_16_0(ri, ro, is, ivs, ovs);
	  ri += VL * ivs;
	  ro += VL * ovs;
     }
     END_SIMD();
}

static const kdft_desc desc = { 16, "m2fv_16", {68, 8, 4, 0}, &GENUS, 0, 2, 0, 0 };
void X(codelet_m2fv_16) (planner *p) {
     X(kdft_register) (p, m2fv_16, &desc);
}
