/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:01:50 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -sign 1 -n 7 -name n1bv_7 -include n1b.h */

/*
 * This function contains 30 FP additions, 18 FP multiplications,
 * (or, 18 additions, 6 multiplications, 12 fused multiply/add),
 * 31 stack variables, and 14 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n1b.h"

static void n1bv_7(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP222520933, +0.222520933956314404288902564496794759466355569);
     DVK(KP900968867, +0.900968867902419126236102319507445051165919162);
     DVK(KP623489801, +0.623489801858733530525004884004239810632274731);
     DVK(KP781831482, +0.781831482468029808708444526674057750232334519);
     DVK(KP974927912, +0.974927912181823607018131682993931217232785801);
     DVK(KP433883739, +0.433883739117558120475768332848358754609990728);
     int i;
     const R *xi;
     R *xo;
     xi = ii;
     xo = io;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V Tb, Tc, Te, Td, Ta, Ti, Tn, To, Tj, Tf, Tg, Th, Tq;
	  {
	       V T9, T3, T6, T7, T8;
	       Tb = LD(&(xi[0]), ivs, &(xi[0]));
	       T7 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
	       T8 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
	       T9 = VSUB(T7, T8);
	       Tc = VADD(T7, T8);
	       {
		    V T1, T2, T4, T5;
		    T1 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T2 = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
		    T3 = VSUB(T1, T2);
		    Te = VADD(T1, T2);
		    T4 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    T5 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T6 = VSUB(T4, T5);
		    Td = VADD(T4, T5);
	       }
	       Ta = VBYI(VFMA(LDK(KP433883739), T3, VFNMS(LDK(KP781831482), T9, VMUL(LDK(KP974927912), T6))));
	       Ti = VBYI(VFMA(LDK(KP781831482), T3, VFMA(LDK(KP974927912), T9, VMUL(LDK(KP433883739), T6))));
	       Tn = VBYI(VFNMS(LDK(KP781831482), T6, VFNMS(LDK(KP433883739), T9, VMUL(LDK(KP974927912), T3))));
	       To = VFMA(LDK(KP623489801), Td, VFNMS(LDK(KP900968867), Tc, VFNMS(LDK(KP222520933), Te, Tb)));
	       Tj = VFMA(LDK(KP623489801), Te, VFNMS(LDK(KP900968867), Td, VFNMS(LDK(KP222520933), Tc, Tb)));
	       Tf = VFMA(LDK(KP623489801), Tc, VFNMS(LDK(KP222520933), Td, VFNMS(LDK(KP900968867), Te, Tb)));
	  }
	  Tg = VADD(Ta, Tf);
	  ST(&(xo[WS(os, 3)]), Tg, ovs, &(xo[WS(os, 1)]));
	  Th = VSUB(Tf, Ta);
	  ST(&(xo[WS(os, 4)]), Th, ovs, &(xo[0]));
	  Tq = VSUB(To, Tn);
	  ST(&(xo[WS(os, 5)]), Tq, ovs, &(xo[WS(os, 1)]));
	  {
	       V Tp, Tl, Tk, Tm;
	       Tp = VADD(Tn, To);
	       ST(&(xo[WS(os, 2)]), Tp, ovs, &(xo[0]));
	       Tl = VSUB(Tj, Ti);
	       ST(&(xo[WS(os, 6)]), Tl, ovs, &(xo[0]));
	       Tk = VADD(Ti, Tj);
	       ST(&(xo[WS(os, 1)]), Tk, ovs, &(xo[WS(os, 1)]));
	       Tm = VADD(Tb, VADD(Te, VADD(Tc, Td)));
	       ST(&(xo[0]), Tm, ovs, &(xo[0]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 7, "n1bv_7", {18, 6, 12, 0}, &GENUS, 0, 0, 0, 0 };
void X(codelet_n1bv_7) (planner *p) {
     X(kdft_register) (p, n1bv_7, &desc);
}
