/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:01:54 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -sign 1 -n 8 -name n1bv_8 -include n1b.h */

/*
 * This function contains 26 FP additions, 2 FP multiplications,
 * (or, 26 additions, 2 multiplications, 0 fused multiply/add),
 * 20 stack variables, and 16 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n1b.h"

static void n1bv_8(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     const R *xi;
     R *xo;
     xi = ii;
     xo = io;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V Ta, Tv, Te, Tp, T7, Tw, Tf, Ts;
	  {
	       V T8, T9, To, Tc, Td, Tn;
	       T8 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
	       T9 = LD(&(xi[WS(is, 6)]), ivs, &(xi[0]));
	       To = VADD(T8, T9);
	       Tc = LD(&(xi[0]), ivs, &(xi[0]));
	       Td = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
	       Tn = VADD(Tc, Td);
	       Ta = VSUB(T8, T9);
	       Tv = VADD(Tn, To);
	       Te = VSUB(Tc, Td);
	       Tp = VSUB(Tn, To);
	  }
	  {
	       V T3, Tq, T6, Tr;
	       {
		    V T1, T2, T4, T5;
		    T1 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T2 = LD(&(xi[WS(is, 5)]), ivs, &(xi[WS(is, 1)]));
		    T3 = VSUB(T1, T2);
		    Tq = VADD(T1, T2);
		    T4 = LD(&(xi[WS(is, 7)]), ivs, &(xi[WS(is, 1)]));
		    T5 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VSUB(T4, T5);
		    Tr = VADD(T4, T5);
	       }
	       T7 = VMUL(LDK(KP707106781), VSUB(T3, T6));
	       Tw = VADD(Tq, Tr);
	       Tf = VMUL(LDK(KP707106781), VADD(T3, T6));
	       Ts = VBYI(VSUB(Tq, Tr));
	  }
	  {
	       V Tt, Tu, Ty, Tx;
	       Tt = VSUB(Tp, Ts);
	       ST(&(xo[WS(os, 6)]), Tt, ovs, &(xo[0]));
	       Tu = VADD(Tp, Ts);
	       ST(&(xo[WS(os, 2)]), Tu, ovs, &(xo[0]));
	       Ty = VADD(Tv, Tw);
	       ST(&(xo[0]), Ty, ovs, &(xo[0]));
	       Tx = VSUB(Tv, Tw);
	       ST(&(xo[WS(os, 4)]), Tx, ovs, &(xo[0]));
	       {
		    V Tl, Tm, Tj, Tk;
		    Tj = VBYI(VADD(Ta, T7));
		    Tk = VADD(Te, Tf);
		    Tl = VADD(Tj, Tk);
		    Tm = VSUB(Tk, Tj);
		    ST(&(xo[WS(os, 1)]), Tl, ovs, &(xo[WS(os, 1)]));
		    ST(&(xo[WS(os, 7)]), Tm, ovs, &(xo[WS(os, 1)]));
	       }
	       {
		    V Th, Ti, Tb, Tg;
		    Tb = VBYI(VSUB(T7, Ta));
		    Tg = VSUB(Te, Tf);
		    Th = VADD(Tb, Tg);
		    Ti = VSUB(Tg, Tb);
		    ST(&(xo[WS(os, 3)]), Th, ovs, &(xo[WS(os, 1)]));
		    ST(&(xo[WS(os, 5)]), Ti, ovs, &(xo[WS(os, 1)]));
	       }
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 8, "n1bv_8", {26, 2, 0, 0}, &GENUS, 0, 0, 0, 0 };
void X(codelet_n1bv_8) (planner *p) {
     X(kdft_register) (p, n1bv_8, &desc);
}
