/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Apr 19 18:01:44 EDT 2003 */

#include "codelet-dft.h"

/* Generated by: /homea/athena/fftw3/genfft/gen_notw_c -simd -trivial-stores -compact -variables 4 -n 5 -name n1fv_5 -include n1f.h */

/*
 * This function contains 16 FP additions, 6 FP multiplications,
 * (or, 13 additions, 3 multiplications, 3 fused multiply/add),
 * 22 stack variables, and 10 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_notw_c.ml,v 1.9 2003/04/16 21:21:53 athena Exp $
 */

#include "n1f.h"

static void n1fv_5(const R *ri, const R *ii, R *ro, R *io, stride is, stride os, int v, int ivs, int ovs)
{
     DVK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DVK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DVK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DVK(KP559016994, +0.559016994374947424102293417182819058860154590);
     int i;
     const R *xi;
     R *xo;
     xi = ri;
     xo = ro;
     BEGIN_SIMD();
     for (i = v; i > 0; i = i - VL, xi = xi + (VL * ivs), xo = xo + (VL * ovs)) {
	  V T8, T7, Th, Te, T9, Ta, Tl;
	  {
	       V T6, Td, T3, Tc;
	       T8 = LD(&(xi[0]), ivs, &(xi[0]));
	       {
		    V T4, T5, T1, T2;
		    T4 = LD(&(xi[WS(is, 2)]), ivs, &(xi[0]));
		    T5 = LD(&(xi[WS(is, 3)]), ivs, &(xi[WS(is, 1)]));
		    T6 = VADD(T4, T5);
		    Td = VSUB(T4, T5);
		    T1 = LD(&(xi[WS(is, 1)]), ivs, &(xi[WS(is, 1)]));
		    T2 = LD(&(xi[WS(is, 4)]), ivs, &(xi[0]));
		    T3 = VADD(T1, T2);
		    Tc = VSUB(T1, T2);
	       }
	       T7 = VMUL(LDK(KP559016994), VSUB(T3, T6));
	       Th = VBYI(VFNMS(LDK(KP587785252), Tc, VMUL(LDK(KP951056516), Td)));
	       Te = VBYI(VFMA(LDK(KP951056516), Tc, VMUL(LDK(KP587785252), Td)));
	       T9 = VADD(T3, T6);
	       Ta = VFNMS(LDK(KP250000000), T9, T8);
	  }
	  Tl = VADD(T8, T9);
	  ST(&(xo[0]), Tl, ovs, &(xo[0]));
	  {
	       V Tj, Tk, Ti, Tf, Tg, Tb;
	       Ti = VSUB(Ta, T7);
	       Tj = VADD(Th, Ti);
	       Tk = VSUB(Ti, Th);
	       ST(&(xo[WS(os, 2)]), Tj, ovs, &(xo[0]));
	       ST(&(xo[WS(os, 3)]), Tk, ovs, &(xo[WS(os, 1)]));
	       Tb = VADD(T7, Ta);
	       Tf = VSUB(Tb, Te);
	       Tg = VADD(Te, Tb);
	       ST(&(xo[WS(os, 1)]), Tf, ovs, &(xo[WS(os, 1)]));
	       ST(&(xo[WS(os, 4)]), Tg, ovs, &(xo[0]));
	  }
     }
     END_SIMD();
}

static const kdft_desc desc = { 5, "n1fv_5", {13, 3, 3, 0}, &GENUS, 0, 0, 0, 0 };
void X(codelet_n1fv_5) (planner *p) {
     X(kdft_register) (p, n1fv_5, &desc);
}
